<?php


namespace Shop\Infrastructure\Repositories\Catalog;


use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;
use Shop\Domain\Catalog\CatalogCollection;
use Shop\Infrastructure\Models\Catalog\Catalog;
use Shop\Infrastructure\Models\Catalog\CatalogQuery;

class CatalogRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    /**
     * @return EntityInterface
     */
    public static function createEntity(): EntityInterface
    {
        return new Catalog();
    }

    protected function createQuery(): ModelCriteria
    {
        return CatalogQuery::create();
    }

    /**
     * @param PaginationInterface|CatalogCriteria $criteria
     * @param ModelCriteria|CatalogQuery $dbCriteria
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {
        $dbCriteria
            ->_if($criteria->getSearchByName() !== null)
            ->filterByName('%' . $criteria->getSearchByName() . '%', Criteria::LIKE)
            ->_endif()
            ->_if($criteria->getSearchByAlias() !== null)
            ->filterByAlias('%' . $criteria->getSearchByAlias() . '%', Criteria::LIKE)
            ->_endif()
            ->_if($criteria->getFilterByAlias()!==null)
            ->filterByAlias($criteria->getFilterByAlias())
            ->_endif()

            //------------------------

//            ->_if($criteria->getFilterByProductCategoryId()!==null)
//            ->_if($criteria->getFilterByDomainId()!==null)
//            ->useDomainQuery()
//            ->filterByDomainId($criteria->getFilterByDomainId())
//            ->endUse()
//            ->_endif()
            ->_if(is_array($criteria->getFilterByWeights()) && count($criteria->getFilterByWeights()))
            ->useDomainQuery()
            ->filterByWeight($criteria->getFilterByWeights())
            ->endUse()
            ->_endif()

//            ->_if($criteria->getFilterByPriceListScheetIds()!==null)
//            ->useProductQuery()
//            ->usePositionQuery()
//            ->filterByPricelistSheetId($criteria->getFilterByPriceListScheetIds())
//            ->endUse()
//            ->endUse()
//            ->_endif()

            ->_if($criteria->getFilterByAlias()!==null)
            ->filterByAlias($criteria->getFilterByAlias())
            ->_endif()

            ->_if($criteria->getSortByName() !== null)
            ->orderByName($criteria->getSortByName())
            ->_endif()

            ->groupById()
        ;
    }
    

    protected function createCollection(): CollectionInterface
    {
        return new CatalogCollection();
    }

}