<?php

namespace Shop\Domain\State;

use Core\Repository\DropDownInterface;
use Repo\Concrete\AbstractCollection;
use Shop\Domain\State\Contracts\StateEntityInterface;

/**
* Description of State
*
* @author Diamond Code Generator
*/
class StateCollection extends AbstractCollection implements DropDownInterface
{

    /**
     * @return string
     */
    protected function getEntityClass(): string
    {
        return StateEntityInterface::class;
    }

    public function getDropdownList(): array
    {
        $ar = [];
        foreach ($this->_entities as $entity){
            $ar[$entity->getId()] = $entity->getTitle();
        }

        return $ar;
    }


}               