<?php

namespace Shop\Infrastructure\Repositories\CustomerGroup;

use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;
use Shop\Domain\CustomerGroup\CustomerGroupCollection;
use Shop\Infrastructure\Models\CustomerGroup\CustomerGroup;
use Shop\Infrastructure\Models\CustomerGroup\CustomerGroupQuery;

class CustomerGroupRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    public static function createEntity(): EntityInterface
    {
        return new CustomerGroup();
    }

    protected function createQuery(): ModelCriteria
    {
        return CustomerGroupQuery::create();
    }

    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {
        // TODO: Implement modifyCriteria() method.
    }



    protected function createCollection(): CollectionInterface
    {
        return new CustomerGroupCollection();
    }
}