<?php

namespace Shop\Infrastructure\Models\Manager\Map;

use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;
use Shop\Infrastructure\Models\Manager\Manager;
use Shop\Infrastructure\Models\Manager\ManagerQuery;


/**
 * This class defines the structure of the 'shop_managers' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class ManagerTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    public const CLASS_NAME = 'Shop.Infrastructure.Models.Manager.Map.ManagerTableMap';

    /**
     * The default database name for this class
     */
    public const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    public const TABLE_NAME = 'shop_managers';

    /**
     * The related Propel class for this table
     */
    public const OM_CLASS = '\\Shop\\Infrastructure\\Models\\Manager\\Manager';

    /**
     * A class that can be returned by this tableMap
     */
    public const CLASS_DEFAULT = 'Shop.Infrastructure.Models.Manager.Manager';

    /**
     * The total number of columns
     */
    public const NUM_COLUMNS = 6;

    /**
     * The number of lazy-loaded columns
     */
    public const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    public const NUM_HYDRATE_COLUMNS = 6;

    /**
     * the column name for the id field
     */
    public const COL_ID = 'shop_managers.id';

    /**
     * the column name for the name field
     */
    public const COL_NAME = 'shop_managers.name';

    /**
     * the column name for the email field
     */
    public const COL_EMAIL = 'shop_managers.email';

    /**
     * the column name for the phone field
     */
    public const COL_PHONE = 'shop_managers.phone';

    /**
     * the column name for the comment field
     */
    public const COL_COMMENT = 'shop_managers.comment';

    /**
     * the column name for the shop_id field
     */
    public const COL_SHOP_ID = 'shop_managers.shop_id';

    /**
     * The default string format for model objects of the related table
     */
    public const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     *
     * @var array<string, mixed>
     */
    protected static $fieldNames = [
        self::TYPE_PHPNAME       => ['Id', 'Name', 'Email', 'Phone', 'Comment', 'ShopId', ],
        self::TYPE_CAMELNAME     => ['id', 'name', 'email', 'phone', 'comment', 'shopId', ],
        self::TYPE_COLNAME       => [ManagerTableMap::COL_ID, ManagerTableMap::COL_NAME, ManagerTableMap::COL_EMAIL, ManagerTableMap::COL_PHONE, ManagerTableMap::COL_COMMENT, ManagerTableMap::COL_SHOP_ID, ],
        self::TYPE_FIELDNAME     => ['id', 'name', 'email', 'phone', 'comment', 'shop_id', ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, ]
    ];

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     *
     * @var array<string, mixed>
     */
    protected static $fieldKeys = [
        self::TYPE_PHPNAME       => ['Id' => 0, 'Name' => 1, 'Email' => 2, 'Phone' => 3, 'Comment' => 4, 'ShopId' => 5, ],
        self::TYPE_CAMELNAME     => ['id' => 0, 'name' => 1, 'email' => 2, 'phone' => 3, 'comment' => 4, 'shopId' => 5, ],
        self::TYPE_COLNAME       => [ManagerTableMap::COL_ID => 0, ManagerTableMap::COL_NAME => 1, ManagerTableMap::COL_EMAIL => 2, ManagerTableMap::COL_PHONE => 3, ManagerTableMap::COL_COMMENT => 4, ManagerTableMap::COL_SHOP_ID => 5, ],
        self::TYPE_FIELDNAME     => ['id' => 0, 'name' => 1, 'email' => 2, 'phone' => 3, 'comment' => 4, 'shop_id' => 5, ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, ]
    ];

    /**
     * Holds a list of column names and their normalized version.
     *
     * @var array<string>
     */
    protected $normalizedColumnNameMap = [
        'Id' => 'ID',
        'Manager.Id' => 'ID',
        'id' => 'ID',
        'manager.id' => 'ID',
        'ManagerTableMap::COL_ID' => 'ID',
        'COL_ID' => 'ID',
        'shop_managers.id' => 'ID',
        'Name' => 'NAME',
        'Manager.Name' => 'NAME',
        'name' => 'NAME',
        'manager.name' => 'NAME',
        'ManagerTableMap::COL_NAME' => 'NAME',
        'COL_NAME' => 'NAME',
        'shop_managers.name' => 'NAME',
        'Email' => 'EMAIL',
        'Manager.Email' => 'EMAIL',
        'email' => 'EMAIL',
        'manager.email' => 'EMAIL',
        'ManagerTableMap::COL_EMAIL' => 'EMAIL',
        'COL_EMAIL' => 'EMAIL',
        'shop_managers.email' => 'EMAIL',
        'Phone' => 'PHONE',
        'Manager.Phone' => 'PHONE',
        'phone' => 'PHONE',
        'manager.phone' => 'PHONE',
        'ManagerTableMap::COL_PHONE' => 'PHONE',
        'COL_PHONE' => 'PHONE',
        'shop_managers.phone' => 'PHONE',
        'Comment' => 'COMMENT',
        'Manager.Comment' => 'COMMENT',
        'comment' => 'COMMENT',
        'manager.comment' => 'COMMENT',
        'ManagerTableMap::COL_COMMENT' => 'COMMENT',
        'COL_COMMENT' => 'COMMENT',
        'shop_managers.comment' => 'COMMENT',
        'ShopId' => 'SHOP_ID',
        'Manager.ShopId' => 'SHOP_ID',
        'shopId' => 'SHOP_ID',
        'manager.shopId' => 'SHOP_ID',
        'ManagerTableMap::COL_SHOP_ID' => 'SHOP_ID',
        'COL_SHOP_ID' => 'SHOP_ID',
        'shop_id' => 'SHOP_ID',
        'shop_managers.shop_id' => 'SHOP_ID',
    ];

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function initialize(): void
    {
        // attributes
        $this->setName('shop_managers');
        $this->setPhpName('Manager');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Shop\\Infrastructure\\Models\\Manager\\Manager');
        $this->setPackage('Shop.Infrastructure.Models.Manager');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('name', 'Name', 'VARCHAR', true, 255, null);
        $this->addColumn('email', 'Email', 'VARCHAR', true, 100, null);
        $this->addColumn('phone', 'Phone', 'VARCHAR', false, 100, null);
        $this->addColumn('comment', 'Comment', 'LONGVARCHAR', false, null, null);
        $this->addForeignKey('shop_id', 'ShopId', 'INTEGER', 'shop_shops', 'id', true, null, null);
    }

    /**
     * Build the RelationMap objects for this table relationships
     *
     * @return void
     */
    public function buildRelations(): void
    {
        $this->addRelation('Shop', '\\Shop\\Infrastructure\\Models\\Shop\\Shop', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':shop_id',
    1 => ':id',
  ),
), 'CASCADE', null, null, false);
        $this->addRelation('Customer', '\\Shop\\Infrastructure\\Models\\Customer\\Customer', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':manager_id',
    1 => ':id',
  ),
), null, null, 'Customers', false);
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string|null The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): ?string
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param bool $withPrefix Whether to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass(bool $withPrefix = true): string
    {
        return $withPrefix ? ManagerTableMap::CLASS_DEFAULT : ManagerTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array $row Row returned by DataFetcher->fetch().
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array (Manager object, last column rank)
     */
    public static function populateObject(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): array
    {
        $key = ManagerTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = ManagerTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + ManagerTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = ManagerTableMap::OM_CLASS;
            /** @var Manager $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            ManagerTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array<object>
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher): array
    {
        $results = [];

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = ManagerTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = ManagerTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var Manager $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                ManagerTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria Object containing the columns to add.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function addSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->addSelectColumn(ManagerTableMap::COL_ID);
            $criteria->addSelectColumn(ManagerTableMap::COL_NAME);
            $criteria->addSelectColumn(ManagerTableMap::COL_EMAIL);
            $criteria->addSelectColumn(ManagerTableMap::COL_PHONE);
            $criteria->addSelectColumn(ManagerTableMap::COL_COMMENT);
            $criteria->addSelectColumn(ManagerTableMap::COL_SHOP_ID);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.name');
            $criteria->addSelectColumn($alias . '.email');
            $criteria->addSelectColumn($alias . '.phone');
            $criteria->addSelectColumn($alias . '.comment');
            $criteria->addSelectColumn($alias . '.shop_id');
        }
    }

    /**
     * Remove all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be removed as they are only loaded on demand.
     *
     * @param Criteria $criteria Object containing the columns to remove.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function removeSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->removeSelectColumn(ManagerTableMap::COL_ID);
            $criteria->removeSelectColumn(ManagerTableMap::COL_NAME);
            $criteria->removeSelectColumn(ManagerTableMap::COL_EMAIL);
            $criteria->removeSelectColumn(ManagerTableMap::COL_PHONE);
            $criteria->removeSelectColumn(ManagerTableMap::COL_COMMENT);
            $criteria->removeSelectColumn(ManagerTableMap::COL_SHOP_ID);
        } else {
            $criteria->removeSelectColumn($alias . '.id');
            $criteria->removeSelectColumn($alias . '.name');
            $criteria->removeSelectColumn($alias . '.email');
            $criteria->removeSelectColumn($alias . '.phone');
            $criteria->removeSelectColumn($alias . '.comment');
            $criteria->removeSelectColumn($alias . '.shop_id');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap(): TableMap
    {
        return Propel::getServiceContainer()->getDatabaseMap(ManagerTableMap::DATABASE_NAME)->getTable(ManagerTableMap::TABLE_NAME);
    }

    /**
     * Performs a DELETE on the database, given a Manager or Criteria object OR a primary key value.
     *
     * @param mixed $values Criteria or Manager object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ?ConnectionInterface $con = null): int
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ManagerTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Shop\Infrastructure\Models\Manager\Manager) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(ManagerTableMap::DATABASE_NAME);
            $criteria->add(ManagerTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = ManagerQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            ManagerTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                ManagerTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the shop_managers table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(?ConnectionInterface $con = null): int
    {
        return ManagerQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a Manager or Criteria object.
     *
     * @param mixed $criteria Criteria or Manager object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed The new primary key.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ManagerTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from Manager object
        }

        if ($criteria->containsKey(ManagerTableMap::COL_ID) && $criteria->keyContainsValue(ManagerTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.ManagerTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = ManagerQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

}
