<?

namespace Shop\Presentation\Modules\Traits;

use Core\Form\Control\MenuItemWindowSelect;
use Repo\EntityInterface;
use Shop\Domain\CustomerOrder\Contracts\CustomerOrderEntityInterface;
use Shop\Presentation\Helpers\Formatter;

/**
 * Общще  для админ справочников
 *
 * @author Admin
 */
trait FormatterTrait
{

    /**
     * @param string $name
     * @param string $controlName
     * @param string $id
     * @return string
     */
    public function formatRowSelect(EntityInterface $projectEntity, string $name, string $controlName, string $id): string
    {
        $items = [];
        $items[] = new MenuItemWindowSelect($name, $controlName, $id);
        return parent::formatActions($projectEntity, $items);

    }

    /**
     *
     * @param \Shop\Infrastructure\Models\Order\Order $order
     * @return string
     */
    public function formatCustomer(\Shop\Infrastructure\Models\Order\Order $order)
    {
        $customer = $order->getCustomer();
        $name =  sprintf("%s / %s / %s",
            $customer->getName(),
            $customer->getCustomerGroup()->getName(),
            $customer->getManager()->getShop()->getTitle()
        );

        return anchor('/admin/shop/customers/customers',$name,[],[
            'fn'    => 'edit',
            'id'    => $customer->getId()
        ]);
    }

    /**
     * @param CustomerOrderEntityInterface|Order $order
     * @return string
     */
    public function formatStates(CustomerOrderEntityInterface $order): string
    {
        $sign = $img = '';


        if ($order->getOrderSign()) {

            $popup = sprintf(
                "window.open('/admin/shop/customers/sync_log?order_id=%s', 'moysklad_sync','right=100,width=600,height=400,left=100,menubar=no,location=no,status=no')",
                $order->getId()
            );

            switch (true) {

                case $order->getOrderSign()->getBitrixSync() === 'sucess':

                    $sign .= '<img title="Синхронизирован с Bitrix24 успешно" src="/_diamond/shop/assets/images/icons/bitrix24.png" />';

                    break;

                case $order->getOrderSign()->getBitrixSync() === 'error':

                    $sign .= '<img title="Синхронизирован с Bitrix24  с ошибкой" src="/_diamond/shop/assets/images/icons/bitrix24-error.png" />';

                    break;

                case $order->getOrderSign()->getMoyskladSync() === 'sucess':

                    $sign .= '<img title="Синхронизирован с МойСклад успешно" src="/_diamond/shop/assets/images/icons/moysklad.png" />';

                    break;

                case $order->getOrderSign()->getMoyskladSync() === 'error':

                    $sign .= '<img title="Синхронизирован с МойСклад с ошибками" src="/_diamond/shop/assets/images/icons/moysklad-error.png" />';

                    break;

                case $order->getOrderSign()->getMoyskladSync() === 'warning':

                    $sign .= '<img title="Синхронизирован с МойСклад с предупреждениями" src="/_diamond/shop/assets/images/icons/moysklad-error.png" />';
                    break;
            }

            if($order->getOrderSign()->getMoyskladSync() !== 'none' || $order->getOrderSign()->getBitrixSync() !== 'none'){
                $sign = sprintf('<a onclick="' . $popup . '" href="javascript:void(0)">%s</a>', $sign);
            }

        }

        if ($order->getOrderItems()->count()) {
            $stateImg = '<img width="16" height="16" title="' . $order->getState()->getTitle() . '" src="/_service/shop/order/' . $order->getId() . '/state/image" />';
        } else {
            $stateImg = '';
        }

        if ($order->isPayment() === true) {
            $sign .= '<img title="Оплачен" src="/assets/images/payment.gif" />';
        }

        $state = Formatter::formatColor($order->getState());

        //_service/shop/order/248/state/image

        return '<nobr>' . $state . nbs() . $stateImg . nbs() . $sign . '</nobr>';
    }


}