<?php

namespace Shop\Presentation\Modules\AdminProviders;

use ActiveTable\ColumnTable;
use Core\Form\ControlBuilder;
use Core\Form\NiftyControlBuilder;
use Core\Template\Template;
use Diamond\Helpers\Form;
use DiamondTable\TableFactory;
use Shop\Application\Office\Exceptions\MainStockNotFoundException;
use Shop\Application\Office\Exceptions\MainStockSomeFoundException;
use Shop\Application\Office\OfficeService;
use Shop\Presentation\Config\Main;
use Shop\Infrastructure\Repositories\City\CityRepository;
use Shop\Infrastructure\Repositories\Country\CountryRepository;
use Shop\Infrastructure\Repositories\Currency\CurrencyCriteria;
use Shop\Infrastructure\Repositories\Currency\CurrencyRepository;
use Shop\Infrastructure\Repositories\Customer\CustomerRepository;
use Shop\Infrastructure\Repositories\Manager\ManagerRepository;
use Shop\Infrastructure\Repositories\Provider\ProviderCriteria;
use Shop\Infrastructure\Repositories\Provider\ProviderRepository;
use Shop\Infrastructure\Repositories\Region\RegionRepository;
use Shop\Infrastructure\Repositories\Stock\StockRepository;


/**
 * Description of AdminProviders
 *
 * @author Diamond Code Generator
 */
class AdminProviders extends \Core\ModuleController
{

    use ColumnsFormatTrait;
    use ContractorFormTrait;

    public function __construct(protected ProviderRepository $providerRepository,
                                protected TableFactory $tableFactory,
                                protected NiftyControlBuilder $controlBuilder,
                                protected CurrencyRepository $currencyRepository,
                                protected ManagerRepository $managerRepository,
                                protected CustomerRepository $customerRepository,
                                protected CountryRepository $countryRepository,
                                protected OfficeService $officeService,
                                protected Main $mainConf,
                                protected CityRepository $cityRepository,
                                protected RegionRepository $regionRepository,
                                protected StockRepository $stockRepository,
                                protected Template $template
    )
    {

    }

    public function process(): string
    {


        $currencies = $this->currencyRepository->findByCriteria(
            CurrencyCriteria::create()
        );


        $table = $this->tableFactory->buildAdminTable($this->providerRepository, ProviderCriteria::create());
        $table->setDefaultSortColumn('id', 'DESC');


        //заменяем комманду стандратной записи на свою
//        $table
//            ->getCommandFactory()
//            ->addCommand(CommandFactory::FORM_SAVE,
//                new SaveProviderCommand($table, $this->officeUseCase, $this->customerRepository)
//            );


        $table
            ->addColumn(
                (new ColumnTable('id', '№'))->setWidth(40)
            )
            ->addColumn(
                (new ColumnTable('name', 'Название'))
            )
            ->addColumn(
                (new ColumnTable('term', 'Срок доставки, дней'))
            )
            ->addColumn(
                (new ColumnTable('destination', 'Направление'))
            )
            ->addColumn(
                (new ColumnTable('contact', 'Контакты'))
            )
            ->addColumn(
                (new ColumnTable('currencyId', 'Валюта'))
                    ->setFormat($this, 'formatCurrency')

            )
            ->addColumn(
                (new ColumnTable('contractorId', 'Контрагент'))
                    ->setFormat($this, 'formatContractor')

            )
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setFormat($this->tableFactory, 'formatActions')
                    ->setWidth(120)
            );



        $table
            ->addField(
                $this->controlBuilder->buildFormHeader('Основная информация о поставщике', 'mainData')
            )
            ->addField(
                $this->controlBuilder->buildInput('name'), true
            )
            ->addField(
                $this->controlBuilder->buildInput('term'), true,null,'За сколько дней товары будут дсотавлены поставщиком'
            )
            ->addField(
                $this->controlBuilder->buildDropdownUniform('currencyId', Form::prepareDropdown($currencies)), true
            )
            ->addField(
                $this->controlBuilder->buildColorPicker('color'), false, 'Цвет в поиске'
            )
            ->addField(
                $this->controlBuilder->buildInputSmall('destination'), true, null, 'Будет отображаться вместо наименования'
            )
            ->addField(
                $this->controlBuilder->buildTextArea('contact')
            )
            ->addField(
                $this->controlBuilder->buildTextArea('desc'), false, 'Описание'
            )

            ->addFilter(
                $this->controlBuilder->buildInput('search_by_name')
            )
            ->addFilter(
                $this->controlBuilder->buildInput('search_by_destination')
            )
            ;

        $this->makeContractorForm($table, $this->providerRepository);

        return $table->render();
    }

}