<?php

namespace Shop\Infrastructure\Models\OrderItem\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Infrastructure\Models\Currency\Currency;
use Shop\Infrastructure\Models\Order\Order;
use Shop\Infrastructure\Models\OrderItem\OrderItem as ChildOrderItem;
use Shop\Infrastructure\Models\OrderItem\OrderItemQuery as ChildOrderItemQuery;
use Shop\Infrastructure\Models\OrderItem\Map\OrderItemTableMap;
use Shop\Infrastructure\Models\Provider\Provider;
use Shop\Infrastructure\Models\State\State;

/**
 * Base class that represents a query for the 'shop_order_items' table.
 *
 *
 *
 * @method     ChildOrderItemQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildOrderItemQuery orderByOrderId($order = Criteria::ASC) Order by the order_id column
 * @method     ChildOrderItemQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method     ChildOrderItemQuery orderByBrand($order = Criteria::ASC) Order by the brand column
 * @method     ChildOrderItemQuery orderByArticle($order = Criteria::ASC) Order by the article column
 * @method     ChildOrderItemQuery orderByDesc($order = Criteria::ASC) Order by the desc column
 * @method     ChildOrderItemQuery orderByPrice($order = Criteria::ASC) Order by the price column
 * @method     ChildOrderItemQuery orderByAmount($order = Criteria::ASC) Order by the amount column
 * @method     ChildOrderItemQuery orderBymenagerComment($order = Criteria::ASC) Order by the menager_comment column
 * @method     ChildOrderItemQuery orderByDestination($order = Criteria::ASC) Order by the destination column
 * @method     ChildOrderItemQuery orderByRefId($order = Criteria::ASC) Order by the ref_id column
 * @method     ChildOrderItemQuery orderByCurrencyId($order = Criteria::ASC) Order by the crrency_id column
 * @method     ChildOrderItemQuery orderByStateId($order = Criteria::ASC) Order by the state_id column
 * @method     ChildOrderItemQuery orderByProviderId($order = Criteria::ASC) Order by the provider_id column
 *
 * @method     ChildOrderItemQuery groupById() Group by the id column
 * @method     ChildOrderItemQuery groupByOrderId() Group by the order_id column
 * @method     ChildOrderItemQuery groupByName() Group by the name column
 * @method     ChildOrderItemQuery groupByBrand() Group by the brand column
 * @method     ChildOrderItemQuery groupByArticle() Group by the article column
 * @method     ChildOrderItemQuery groupByDesc() Group by the desc column
 * @method     ChildOrderItemQuery groupByPrice() Group by the price column
 * @method     ChildOrderItemQuery groupByAmount() Group by the amount column
 * @method     ChildOrderItemQuery groupBymenagerComment() Group by the menager_comment column
 * @method     ChildOrderItemQuery groupByDestination() Group by the destination column
 * @method     ChildOrderItemQuery groupByRefId() Group by the ref_id column
 * @method     ChildOrderItemQuery groupByCurrencyId() Group by the crrency_id column
 * @method     ChildOrderItemQuery groupByStateId() Group by the state_id column
 * @method     ChildOrderItemQuery groupByProviderId() Group by the provider_id column
 *
 * @method     ChildOrderItemQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildOrderItemQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildOrderItemQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildOrderItemQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildOrderItemQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildOrderItemQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildOrderItemQuery leftJoinOrder($relationAlias = null) Adds a LEFT JOIN clause to the query using the Order relation
 * @method     ChildOrderItemQuery rightJoinOrder($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Order relation
 * @method     ChildOrderItemQuery innerJoinOrder($relationAlias = null) Adds a INNER JOIN clause to the query using the Order relation
 *
 * @method     ChildOrderItemQuery joinWithOrder($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Order relation
 *
 * @method     ChildOrderItemQuery leftJoinWithOrder() Adds a LEFT JOIN clause and with to the query using the Order relation
 * @method     ChildOrderItemQuery rightJoinWithOrder() Adds a RIGHT JOIN clause and with to the query using the Order relation
 * @method     ChildOrderItemQuery innerJoinWithOrder() Adds a INNER JOIN clause and with to the query using the Order relation
 *
 * @method     ChildOrderItemQuery leftJoinCurrency($relationAlias = null) Adds a LEFT JOIN clause to the query using the Currency relation
 * @method     ChildOrderItemQuery rightJoinCurrency($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Currency relation
 * @method     ChildOrderItemQuery innerJoinCurrency($relationAlias = null) Adds a INNER JOIN clause to the query using the Currency relation
 *
 * @method     ChildOrderItemQuery joinWithCurrency($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Currency relation
 *
 * @method     ChildOrderItemQuery leftJoinWithCurrency() Adds a LEFT JOIN clause and with to the query using the Currency relation
 * @method     ChildOrderItemQuery rightJoinWithCurrency() Adds a RIGHT JOIN clause and with to the query using the Currency relation
 * @method     ChildOrderItemQuery innerJoinWithCurrency() Adds a INNER JOIN clause and with to the query using the Currency relation
 *
 * @method     ChildOrderItemQuery leftJoinState($relationAlias = null) Adds a LEFT JOIN clause to the query using the State relation
 * @method     ChildOrderItemQuery rightJoinState($relationAlias = null) Adds a RIGHT JOIN clause to the query using the State relation
 * @method     ChildOrderItemQuery innerJoinState($relationAlias = null) Adds a INNER JOIN clause to the query using the State relation
 *
 * @method     ChildOrderItemQuery joinWithState($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the State relation
 *
 * @method     ChildOrderItemQuery leftJoinWithState() Adds a LEFT JOIN clause and with to the query using the State relation
 * @method     ChildOrderItemQuery rightJoinWithState() Adds a RIGHT JOIN clause and with to the query using the State relation
 * @method     ChildOrderItemQuery innerJoinWithState() Adds a INNER JOIN clause and with to the query using the State relation
 *
 * @method     ChildOrderItemQuery leftJoinProvider($relationAlias = null) Adds a LEFT JOIN clause to the query using the Provider relation
 * @method     ChildOrderItemQuery rightJoinProvider($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Provider relation
 * @method     ChildOrderItemQuery innerJoinProvider($relationAlias = null) Adds a INNER JOIN clause to the query using the Provider relation
 *
 * @method     ChildOrderItemQuery joinWithProvider($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Provider relation
 *
 * @method     ChildOrderItemQuery leftJoinWithProvider() Adds a LEFT JOIN clause and with to the query using the Provider relation
 * @method     ChildOrderItemQuery rightJoinWithProvider() Adds a RIGHT JOIN clause and with to the query using the Provider relation
 * @method     ChildOrderItemQuery innerJoinWithProvider() Adds a INNER JOIN clause and with to the query using the Provider relation
 *
 * @method     \Shop\Infrastructure\Models\Order\OrderQuery|\Shop\Infrastructure\Models\Currency\CurrencyQuery|\Shop\Infrastructure\Models\State\StateQuery|\Shop\Infrastructure\Models\Provider\ProviderQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildOrderItem|null findOne(?ConnectionInterface $con = null) Return the first ChildOrderItem matching the query
 * @method     ChildOrderItem findOneOrCreate(?ConnectionInterface $con = null) Return the first ChildOrderItem matching the query, or a new ChildOrderItem object populated from the query conditions when no match is found
 *
 * @method     ChildOrderItem|null findOneById(int $id) Return the first ChildOrderItem filtered by the id column
 * @method     ChildOrderItem|null findOneByOrderId(int $order_id) Return the first ChildOrderItem filtered by the order_id column
 * @method     ChildOrderItem|null findOneByName(string $name) Return the first ChildOrderItem filtered by the name column
 * @method     ChildOrderItem|null findOneByBrand(string $brand) Return the first ChildOrderItem filtered by the brand column
 * @method     ChildOrderItem|null findOneByArticle(string $article) Return the first ChildOrderItem filtered by the article column
 * @method     ChildOrderItem|null findOneByDesc(string $desc) Return the first ChildOrderItem filtered by the desc column
 * @method     ChildOrderItem|null findOneByPrice(string $price) Return the first ChildOrderItem filtered by the price column
 * @method     ChildOrderItem|null findOneByAmount(int $amount) Return the first ChildOrderItem filtered by the amount column
 * @method     ChildOrderItem|null findOneBymenagerComment(string $menager_comment) Return the first ChildOrderItem filtered by the menager_comment column
 * @method     ChildOrderItem|null findOneByDestination(string $destination) Return the first ChildOrderItem filtered by the destination column
 * @method     ChildOrderItem|null findOneByRefId(string $ref_id) Return the first ChildOrderItem filtered by the ref_id column
 * @method     ChildOrderItem|null findOneByCurrencyId(int $crrency_id) Return the first ChildOrderItem filtered by the crrency_id column
 * @method     ChildOrderItem|null findOneByStateId(int $state_id) Return the first ChildOrderItem filtered by the state_id column
 * @method     ChildOrderItem|null findOneByProviderId(int $provider_id) Return the first ChildOrderItem filtered by the provider_id column *

 * @method     ChildOrderItem requirePk($key, ?ConnectionInterface $con = null) Return the ChildOrderItem by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrderItem requireOne(?ConnectionInterface $con = null) Return the first ChildOrderItem matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildOrderItem requireOneById(int $id) Return the first ChildOrderItem filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrderItem requireOneByOrderId(int $order_id) Return the first ChildOrderItem filtered by the order_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrderItem requireOneByName(string $name) Return the first ChildOrderItem filtered by the name column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrderItem requireOneByBrand(string $brand) Return the first ChildOrderItem filtered by the brand column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrderItem requireOneByArticle(string $article) Return the first ChildOrderItem filtered by the article column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrderItem requireOneByDesc(string $desc) Return the first ChildOrderItem filtered by the desc column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrderItem requireOneByPrice(string $price) Return the first ChildOrderItem filtered by the price column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrderItem requireOneByAmount(int $amount) Return the first ChildOrderItem filtered by the amount column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrderItem requireOneBymenagerComment(string $menager_comment) Return the first ChildOrderItem filtered by the menager_comment column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrderItem requireOneByDestination(string $destination) Return the first ChildOrderItem filtered by the destination column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrderItem requireOneByRefId(string $ref_id) Return the first ChildOrderItem filtered by the ref_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrderItem requireOneByCurrencyId(int $crrency_id) Return the first ChildOrderItem filtered by the crrency_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrderItem requireOneByStateId(int $state_id) Return the first ChildOrderItem filtered by the state_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrderItem requireOneByProviderId(int $provider_id) Return the first ChildOrderItem filtered by the provider_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildOrderItem[]|Collection find(?ConnectionInterface $con = null) Return ChildOrderItem objects based on current ModelCriteria
 * @psalm-method Collection&\Traversable<ChildOrderItem> find(?ConnectionInterface $con = null) Return ChildOrderItem objects based on current ModelCriteria
 * @method     ChildOrderItem[]|Collection findById(int $id) Return ChildOrderItem objects filtered by the id column
 * @psalm-method Collection&\Traversable<ChildOrderItem> findById(int $id) Return ChildOrderItem objects filtered by the id column
 * @method     ChildOrderItem[]|Collection findByOrderId(int $order_id) Return ChildOrderItem objects filtered by the order_id column
 * @psalm-method Collection&\Traversable<ChildOrderItem> findByOrderId(int $order_id) Return ChildOrderItem objects filtered by the order_id column
 * @method     ChildOrderItem[]|Collection findByName(string $name) Return ChildOrderItem objects filtered by the name column
 * @psalm-method Collection&\Traversable<ChildOrderItem> findByName(string $name) Return ChildOrderItem objects filtered by the name column
 * @method     ChildOrderItem[]|Collection findByBrand(string $brand) Return ChildOrderItem objects filtered by the brand column
 * @psalm-method Collection&\Traversable<ChildOrderItem> findByBrand(string $brand) Return ChildOrderItem objects filtered by the brand column
 * @method     ChildOrderItem[]|Collection findByArticle(string $article) Return ChildOrderItem objects filtered by the article column
 * @psalm-method Collection&\Traversable<ChildOrderItem> findByArticle(string $article) Return ChildOrderItem objects filtered by the article column
 * @method     ChildOrderItem[]|Collection findByDesc(string $desc) Return ChildOrderItem objects filtered by the desc column
 * @psalm-method Collection&\Traversable<ChildOrderItem> findByDesc(string $desc) Return ChildOrderItem objects filtered by the desc column
 * @method     ChildOrderItem[]|Collection findByPrice(string $price) Return ChildOrderItem objects filtered by the price column
 * @psalm-method Collection&\Traversable<ChildOrderItem> findByPrice(string $price) Return ChildOrderItem objects filtered by the price column
 * @method     ChildOrderItem[]|Collection findByAmount(int $amount) Return ChildOrderItem objects filtered by the amount column
 * @psalm-method Collection&\Traversable<ChildOrderItem> findByAmount(int $amount) Return ChildOrderItem objects filtered by the amount column
 * @method     ChildOrderItem[]|Collection findBymenagerComment(string $menager_comment) Return ChildOrderItem objects filtered by the menager_comment column
 * @psalm-method Collection&\Traversable<ChildOrderItem> findBymenagerComment(string $menager_comment) Return ChildOrderItem objects filtered by the menager_comment column
 * @method     ChildOrderItem[]|Collection findByDestination(string $destination) Return ChildOrderItem objects filtered by the destination column
 * @psalm-method Collection&\Traversable<ChildOrderItem> findByDestination(string $destination) Return ChildOrderItem objects filtered by the destination column
 * @method     ChildOrderItem[]|Collection findByRefId(string $ref_id) Return ChildOrderItem objects filtered by the ref_id column
 * @psalm-method Collection&\Traversable<ChildOrderItem> findByRefId(string $ref_id) Return ChildOrderItem objects filtered by the ref_id column
 * @method     ChildOrderItem[]|Collection findByCurrencyId(int $crrency_id) Return ChildOrderItem objects filtered by the crrency_id column
 * @psalm-method Collection&\Traversable<ChildOrderItem> findByCurrencyId(int $crrency_id) Return ChildOrderItem objects filtered by the crrency_id column
 * @method     ChildOrderItem[]|Collection findByStateId(int $state_id) Return ChildOrderItem objects filtered by the state_id column
 * @psalm-method Collection&\Traversable<ChildOrderItem> findByStateId(int $state_id) Return ChildOrderItem objects filtered by the state_id column
 * @method     ChildOrderItem[]|Collection findByProviderId(int $provider_id) Return ChildOrderItem objects filtered by the provider_id column
 * @psalm-method Collection&\Traversable<ChildOrderItem> findByProviderId(int $provider_id) Return ChildOrderItem objects filtered by the provider_id column
 * @method     ChildOrderItem[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 * @psalm-method \Propel\Runtime\Util\PropelModelPager&\Traversable<ChildOrderItem> paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class OrderItemQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Infrastructure\Models\OrderItem\Base\OrderItemQuery object.
     *
     * @param string $dbName The database name
     * @param string $modelName The phpName of a model, e.g. 'Book'
     * @param string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Infrastructure\\Models\\OrderItem\\OrderItem', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildOrderItemQuery object.
     *
     * @param string $modelAlias The alias of a model in the query
     * @param Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildOrderItemQuery
     */
    public static function create(?string $modelAlias = null, ?Criteria $criteria = null): Criteria
    {
        if ($criteria instanceof ChildOrderItemQuery) {
            return $criteria;
        }
        $query = new ChildOrderItemQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildOrderItem|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ?ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(OrderItemTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = OrderItemTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildOrderItem A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `order_id`, `name`, `brand`, `article`, `desc`, `price`, `amount`, `menager_comment`, `destination`, `ref_id`, `crrency_id`, `state_id`, `provider_id` FROM `shop_order_items` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildOrderItem $obj */
            $obj = new ChildOrderItem();
            $obj->hydrate($row);
            OrderItemTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @return ChildOrderItem|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param array $keys Primary keys to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return Collection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param mixed $key Primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        $this->addUsingAlias(OrderItemTableMap::COL_ID, $key, Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param array|int $keys The list of primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        $this->addUsingAlias(OrderItemTableMap::COL_ID, $keys, Criteria::IN);

        return $this;
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterById($id = null, ?string $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(OrderItemTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(OrderItemTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(OrderItemTableMap::COL_ID, $id, $comparison);

        return $this;
    }

    /**
     * Filter the query on the order_id column
     *
     * Example usage:
     * <code>
     * $query->filterByOrderId(1234); // WHERE order_id = 1234
     * $query->filterByOrderId(array(12, 34)); // WHERE order_id IN (12, 34)
     * $query->filterByOrderId(array('min' => 12)); // WHERE order_id > 12
     * </code>
     *
     * @see       filterByOrder()
     *
     * @param mixed $orderId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByOrderId($orderId = null, ?string $comparison = null)
    {
        if (is_array($orderId)) {
            $useMinMax = false;
            if (isset($orderId['min'])) {
                $this->addUsingAlias(OrderItemTableMap::COL_ORDER_ID, $orderId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($orderId['max'])) {
                $this->addUsingAlias(OrderItemTableMap::COL_ORDER_ID, $orderId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(OrderItemTableMap::COL_ORDER_ID, $orderId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%', Criteria::LIKE); // WHERE name LIKE '%fooValue%'
     * $query->filterByName(['foo', 'bar']); // WHERE name IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $name The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByName($name = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(OrderItemTableMap::COL_NAME, $name, $comparison);

        return $this;
    }

    /**
     * Filter the query on the brand column
     *
     * Example usage:
     * <code>
     * $query->filterByBrand('fooValue');   // WHERE brand = 'fooValue'
     * $query->filterByBrand('%fooValue%', Criteria::LIKE); // WHERE brand LIKE '%fooValue%'
     * $query->filterByBrand(['foo', 'bar']); // WHERE brand IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $brand The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByBrand($brand = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($brand)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(OrderItemTableMap::COL_BRAND, $brand, $comparison);

        return $this;
    }

    /**
     * Filter the query on the article column
     *
     * Example usage:
     * <code>
     * $query->filterByArticle('fooValue');   // WHERE article = 'fooValue'
     * $query->filterByArticle('%fooValue%', Criteria::LIKE); // WHERE article LIKE '%fooValue%'
     * $query->filterByArticle(['foo', 'bar']); // WHERE article IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $article The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByArticle($article = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($article)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(OrderItemTableMap::COL_ARTICLE, $article, $comparison);

        return $this;
    }

    /**
     * Filter the query on the desc column
     *
     * Example usage:
     * <code>
     * $query->filterByDesc('fooValue');   // WHERE desc = 'fooValue'
     * $query->filterByDesc('%fooValue%', Criteria::LIKE); // WHERE desc LIKE '%fooValue%'
     * $query->filterByDesc(['foo', 'bar']); // WHERE desc IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $desc The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByDesc($desc = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($desc)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(OrderItemTableMap::COL_DESC, $desc, $comparison);

        return $this;
    }

    /**
     * Filter the query on the price column
     *
     * Example usage:
     * <code>
     * $query->filterByPrice(1234); // WHERE price = 1234
     * $query->filterByPrice(array(12, 34)); // WHERE price IN (12, 34)
     * $query->filterByPrice(array('min' => 12)); // WHERE price > 12
     * </code>
     *
     * @param mixed $price The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrice($price = null, ?string $comparison = null)
    {
        if (is_array($price)) {
            $useMinMax = false;
            if (isset($price['min'])) {
                $this->addUsingAlias(OrderItemTableMap::COL_PRICE, $price['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($price['max'])) {
                $this->addUsingAlias(OrderItemTableMap::COL_PRICE, $price['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(OrderItemTableMap::COL_PRICE, $price, $comparison);

        return $this;
    }

    /**
     * Filter the query on the amount column
     *
     * Example usage:
     * <code>
     * $query->filterByAmount(1234); // WHERE amount = 1234
     * $query->filterByAmount(array(12, 34)); // WHERE amount IN (12, 34)
     * $query->filterByAmount(array('min' => 12)); // WHERE amount > 12
     * </code>
     *
     * @param mixed $amount The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByAmount($amount = null, ?string $comparison = null)
    {
        if (is_array($amount)) {
            $useMinMax = false;
            if (isset($amount['min'])) {
                $this->addUsingAlias(OrderItemTableMap::COL_AMOUNT, $amount['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($amount['max'])) {
                $this->addUsingAlias(OrderItemTableMap::COL_AMOUNT, $amount['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(OrderItemTableMap::COL_AMOUNT, $amount, $comparison);

        return $this;
    }

    /**
     * Filter the query on the menager_comment column
     *
     * Example usage:
     * <code>
     * $query->filterBymenagerComment('fooValue');   // WHERE menager_comment = 'fooValue'
     * $query->filterBymenagerComment('%fooValue%', Criteria::LIKE); // WHERE menager_comment LIKE '%fooValue%'
     * $query->filterBymenagerComment(['foo', 'bar']); // WHERE menager_comment IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $menagerComment The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterBymenagerComment($menagerComment = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($menagerComment)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(OrderItemTableMap::COL_MENAGER_COMMENT, $menagerComment, $comparison);

        return $this;
    }

    /**
     * Filter the query on the destination column
     *
     * Example usage:
     * <code>
     * $query->filterByDestination('fooValue');   // WHERE destination = 'fooValue'
     * $query->filterByDestination('%fooValue%', Criteria::LIKE); // WHERE destination LIKE '%fooValue%'
     * $query->filterByDestination(['foo', 'bar']); // WHERE destination IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $destination The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByDestination($destination = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($destination)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(OrderItemTableMap::COL_DESTINATION, $destination, $comparison);

        return $this;
    }

    /**
     * Filter the query on the ref_id column
     *
     * Example usage:
     * <code>
     * $query->filterByRefId('fooValue');   // WHERE ref_id = 'fooValue'
     * $query->filterByRefId('%fooValue%', Criteria::LIKE); // WHERE ref_id LIKE '%fooValue%'
     * $query->filterByRefId(['foo', 'bar']); // WHERE ref_id IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $refId The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByRefId($refId = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($refId)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(OrderItemTableMap::COL_REF_ID, $refId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the crrency_id column
     *
     * Example usage:
     * <code>
     * $query->filterByCurrencyId(1234); // WHERE crrency_id = 1234
     * $query->filterByCurrencyId(array(12, 34)); // WHERE crrency_id IN (12, 34)
     * $query->filterByCurrencyId(array('min' => 12)); // WHERE crrency_id > 12
     * </code>
     *
     * @see       filterByCurrency()
     *
     * @param mixed $currencyId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByCurrencyId($currencyId = null, ?string $comparison = null)
    {
        if (is_array($currencyId)) {
            $useMinMax = false;
            if (isset($currencyId['min'])) {
                $this->addUsingAlias(OrderItemTableMap::COL_CRRENCY_ID, $currencyId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($currencyId['max'])) {
                $this->addUsingAlias(OrderItemTableMap::COL_CRRENCY_ID, $currencyId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(OrderItemTableMap::COL_CRRENCY_ID, $currencyId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the state_id column
     *
     * Example usage:
     * <code>
     * $query->filterByStateId(1234); // WHERE state_id = 1234
     * $query->filterByStateId(array(12, 34)); // WHERE state_id IN (12, 34)
     * $query->filterByStateId(array('min' => 12)); // WHERE state_id > 12
     * </code>
     *
     * @see       filterByState()
     *
     * @param mixed $stateId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByStateId($stateId = null, ?string $comparison = null)
    {
        if (is_array($stateId)) {
            $useMinMax = false;
            if (isset($stateId['min'])) {
                $this->addUsingAlias(OrderItemTableMap::COL_STATE_ID, $stateId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($stateId['max'])) {
                $this->addUsingAlias(OrderItemTableMap::COL_STATE_ID, $stateId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(OrderItemTableMap::COL_STATE_ID, $stateId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the provider_id column
     *
     * Example usage:
     * <code>
     * $query->filterByProviderId(1234); // WHERE provider_id = 1234
     * $query->filterByProviderId(array(12, 34)); // WHERE provider_id IN (12, 34)
     * $query->filterByProviderId(array('min' => 12)); // WHERE provider_id > 12
     * </code>
     *
     * @see       filterByProvider()
     *
     * @param mixed $providerId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByProviderId($providerId = null, ?string $comparison = null)
    {
        if (is_array($providerId)) {
            $useMinMax = false;
            if (isset($providerId['min'])) {
                $this->addUsingAlias(OrderItemTableMap::COL_PROVIDER_ID, $providerId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($providerId['max'])) {
                $this->addUsingAlias(OrderItemTableMap::COL_PROVIDER_ID, $providerId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(OrderItemTableMap::COL_PROVIDER_ID, $providerId, $comparison);

        return $this;
    }

    /**
     * Filter the query by a related \Shop\Infrastructure\Models\Order\Order object
     *
     * @param \Shop\Infrastructure\Models\Order\Order|ObjectCollection $order The related object(s) to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByOrder($order, ?string $comparison = null)
    {
        if ($order instanceof \Shop\Infrastructure\Models\Order\Order) {
            return $this
                ->addUsingAlias(OrderItemTableMap::COL_ORDER_ID, $order->getId(), $comparison);
        } elseif ($order instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            $this
                ->addUsingAlias(OrderItemTableMap::COL_ORDER_ID, $order->toKeyValue('PrimaryKey', 'Id'), $comparison);

            return $this;
        } else {
            throw new PropelException('filterByOrder() only accepts arguments of type \Shop\Infrastructure\Models\Order\Order or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Order relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinOrder(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Order');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Order');
        }

        return $this;
    }

    /**
     * Use the Order relation Order object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\Order\OrderQuery A secondary query class using the current class as primary query
     */
    public function useOrderQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinOrder($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Order', '\Shop\Infrastructure\Models\Order\OrderQuery');
    }

    /**
     * Use the Order relation Order object
     *
     * @param callable(\Shop\Infrastructure\Models\Order\OrderQuery):\Shop\Infrastructure\Models\Order\OrderQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withOrderQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useOrderQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to Order table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\Order\OrderQuery The inner query object of the EXISTS statement
     */
    public function useOrderExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('Order', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to Order table for a NOT EXISTS query.
     *
     * @see useOrderExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\Order\OrderQuery The inner query object of the NOT EXISTS statement
     */
    public function useOrderNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('Order', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Shop\Infrastructure\Models\Currency\Currency object
     *
     * @param \Shop\Infrastructure\Models\Currency\Currency|ObjectCollection $currency The related object(s) to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByCurrency($currency, ?string $comparison = null)
    {
        if ($currency instanceof \Shop\Infrastructure\Models\Currency\Currency) {
            return $this
                ->addUsingAlias(OrderItemTableMap::COL_CRRENCY_ID, $currency->getId(), $comparison);
        } elseif ($currency instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            $this
                ->addUsingAlias(OrderItemTableMap::COL_CRRENCY_ID, $currency->toKeyValue('PrimaryKey', 'Id'), $comparison);

            return $this;
        } else {
            throw new PropelException('filterByCurrency() only accepts arguments of type \Shop\Infrastructure\Models\Currency\Currency or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Currency relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinCurrency(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Currency');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Currency');
        }

        return $this;
    }

    /**
     * Use the Currency relation Currency object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\Currency\CurrencyQuery A secondary query class using the current class as primary query
     */
    public function useCurrencyQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinCurrency($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Currency', '\Shop\Infrastructure\Models\Currency\CurrencyQuery');
    }

    /**
     * Use the Currency relation Currency object
     *
     * @param callable(\Shop\Infrastructure\Models\Currency\CurrencyQuery):\Shop\Infrastructure\Models\Currency\CurrencyQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withCurrencyQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useCurrencyQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to Currency table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\Currency\CurrencyQuery The inner query object of the EXISTS statement
     */
    public function useCurrencyExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('Currency', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to Currency table for a NOT EXISTS query.
     *
     * @see useCurrencyExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\Currency\CurrencyQuery The inner query object of the NOT EXISTS statement
     */
    public function useCurrencyNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('Currency', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Shop\Infrastructure\Models\State\State object
     *
     * @param \Shop\Infrastructure\Models\State\State|ObjectCollection $state The related object(s) to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByState($state, ?string $comparison = null)
    {
        if ($state instanceof \Shop\Infrastructure\Models\State\State) {
            return $this
                ->addUsingAlias(OrderItemTableMap::COL_STATE_ID, $state->getId(), $comparison);
        } elseif ($state instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            $this
                ->addUsingAlias(OrderItemTableMap::COL_STATE_ID, $state->toKeyValue('PrimaryKey', 'Id'), $comparison);

            return $this;
        } else {
            throw new PropelException('filterByState() only accepts arguments of type \Shop\Infrastructure\Models\State\State or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the State relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinState(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('State');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'State');
        }

        return $this;
    }

    /**
     * Use the State relation State object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\State\StateQuery A secondary query class using the current class as primary query
     */
    public function useStateQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinState($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'State', '\Shop\Infrastructure\Models\State\StateQuery');
    }

    /**
     * Use the State relation State object
     *
     * @param callable(\Shop\Infrastructure\Models\State\StateQuery):\Shop\Infrastructure\Models\State\StateQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withStateQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useStateQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to State table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\State\StateQuery The inner query object of the EXISTS statement
     */
    public function useStateExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('State', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to State table for a NOT EXISTS query.
     *
     * @see useStateExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\State\StateQuery The inner query object of the NOT EXISTS statement
     */
    public function useStateNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('State', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Shop\Infrastructure\Models\Provider\Provider object
     *
     * @param \Shop\Infrastructure\Models\Provider\Provider|ObjectCollection $provider The related object(s) to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByProvider($provider, ?string $comparison = null)
    {
        if ($provider instanceof \Shop\Infrastructure\Models\Provider\Provider) {
            return $this
                ->addUsingAlias(OrderItemTableMap::COL_PROVIDER_ID, $provider->getId(), $comparison);
        } elseif ($provider instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            $this
                ->addUsingAlias(OrderItemTableMap::COL_PROVIDER_ID, $provider->toKeyValue('PrimaryKey', 'Id'), $comparison);

            return $this;
        } else {
            throw new PropelException('filterByProvider() only accepts arguments of type \Shop\Infrastructure\Models\Provider\Provider or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Provider relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinProvider(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Provider');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Provider');
        }

        return $this;
    }

    /**
     * Use the Provider relation Provider object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\Provider\ProviderQuery A secondary query class using the current class as primary query
     */
    public function useProviderQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProvider($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Provider', '\Shop\Infrastructure\Models\Provider\ProviderQuery');
    }

    /**
     * Use the Provider relation Provider object
     *
     * @param callable(\Shop\Infrastructure\Models\Provider\ProviderQuery):\Shop\Infrastructure\Models\Provider\ProviderQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withProviderQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useProviderQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to Provider table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\Provider\ProviderQuery The inner query object of the EXISTS statement
     */
    public function useProviderExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('Provider', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to Provider table for a NOT EXISTS query.
     *
     * @see useProviderExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\Provider\ProviderQuery The inner query object of the NOT EXISTS statement
     */
    public function useProviderNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('Provider', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Exclude object from result
     *
     * @param ChildOrderItem $orderItem Object to remove from the list of results
     *
     * @return $this The current query, for fluid interface
     */
    public function prune($orderItem = null)
    {
        if ($orderItem) {
            $this->addUsingAlias(OrderItemTableMap::COL_ID, $orderItem->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the shop_order_items table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(OrderItemTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            OrderItemTableMap::clearInstancePool();
            OrderItemTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(OrderItemTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(OrderItemTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            OrderItemTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            OrderItemTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

}
