<?php


namespace Shop\Application\Shopping\CreateProviderOrdersFromCustomerOrderItem;


use Shop\Application\Shopping\Exceptions\ShoppingException;
use Shop\Domain\ProviderOrder\ProviderOrderCollection;

class CreateProviderOrdersException extends ShoppingException
{
    protected $success = [];
    protected $errorFoundsIds = [];
    protected $errorContractors = [];
    protected $errorStates;

    public function __construct(ProviderOrderCollection $success, array $errorFounds = [], $errorContractors = [], array $errorStates = [])
    {
        parent::__construct('create provider order error');
        $this->success = $success;
        $this->errorFoundsIds = $errorFounds;
        $this->errorContractors = $errorContractors;
        $this->errorStates = $errorStates;
    }

    /**
     * @return ProviderOrderCollection
     */
    public function getSuccess(): ProviderOrderCollection
    {
        return $this->success;
    }

    /**
     * @return array
     */
    public function getErrorFoundsIds(): array
    {
        return $this->errorFoundsIds;
    }

    /**
     * @return array
     */
    public function getErrorContractors(): array
    {
        return $this->errorContractors;
    }

    /**
     * @return array
     */
    public function getErrorStates(): array
    {
        return $this->errorStates;
    }
}