<?php


namespace Shop\Presentation\UseCases\SecurePolicy;

use Shop\Application\Office\OfficeService;

use Core\Concrete\AuthFactory;
use Core\Helpers\Date;
use Core\Security\Access;
use Diamond\Repositories\User\UserRepository;
use Diamond\Services\Auth;
use Diamond\UseCases\Notification\NotificationException;
use Diamond\UseCases\SecurePolicy\SecurePolicyException;

use Shop\Presentation\Config\Main;
use Shop\Domain\Customer\Contracts\CustomerEntityInterface;
use Shop\Infrastructure\Models\Customer\Customer;
use Shop\Infrastructure\Repositories\City\CityRepository;
use Shop\Infrastructure\Repositories\Customer\CustomerCriteria;
use Shop\Infrastructure\Repositories\Customer\CustomerRepository;
use Shop\Presentation\UseCases\Notification\Notification;
use Shop\Presentation\UseCases\Office\Exceptions\ManagerNotFoundException;
use Shop\Presentation\UseCases\Office\Exceptions\StockNotFoundException;
use Shop\Presentation\UseCases\Office\Office;

/**
 * @deprecated
 * Class SecurePolicy
 * @package Shop\Presentation\UseCases\SecurePolicy
 */
class SecurePolicy extends OfficeService
{

    protected const PERSON_KEY = 'customer_id';

    //private static $customer;

//    protected $customerRepository;
//    protected $notification;
//    protected $mainConfig;
//    protected $officeUseCase;
//    protected $authFactory;
//    protected $cityRepository;
//
//    public function __construct(UserRepository $userRepository,
//                                Auth $authService,
//                                Access $access,
//                                CustomerRepository $customerRepository,
//                                Notification $notification,
//                                Main $mainConfig,
//                                Office $officeUseCase,
//                                AuthFactory $authFactory,
//                                CityRepository $cityRepository)
//    {
//        parent::__construct($userRepository, $authService, $access);
//        $this->customerRepository = $customerRepository;
//        $this->notification = $notification;
//        $this->mainConfig = $mainConfig;
//        $this->officeUseCase = $officeUseCase;
//        $this->authFactory = $authFactory;
//        $this->cityRepository = $cityRepository;
//    }


    /**
     * Авторизация клиента
     * @param CustomerEntityInterface $customerEntity
     */
//    public function authCustomer(CustomerEntityInterface $customerEntity): void
//    {
//
//        $userdata = array(
//            'customer_name' => $customerEntity->getName(),
//            self::PERSON_KEY => $customerEntity->getId(),
//            'customer_email' => $customerEntity->getEmail()
//        );
//
//        $userName = md5(serialize($userdata));
//
//        //авторизующий серсис
//        $loginService = $this->authFactory->newLoginService();
//
//        //объект авторизации
//        $authService = $this->authFactory->newInstance();
//        if ($authService->isAnon() || $authService->getUserName() !== $userName) {
//            $loginService->forceLogin($authService, $userName, $userdata);
//        }
//
//        $customerEntity->setLastAuth(time());
//
//        $this->customerRepository->save($customerEntity);
//    }


    /**]
     * @return CustomerEntityInterface
     * @throws \Repo\Concrete\Exceptions\Collection
     */
//    public function getCurrentCustomer(): CustomerEntityInterface
//    {
//
//        if (self::$customer !== null) {
//            return self::$customer;
//        }
//
//        if (!$authData = $this->authService->getAuth()) {
//            $userData = [];
//        } else {
//            $userData = $authData->getUserData();
//        }
//
//        if (!$authData || !isset($userData['customer_id'])) {
//
//            try {
//                $stock = $this->officeUseCase->getCurrentSiteStock();
//                $manager = $this->officeUseCase->getFirstManagerByStockId($stock->getId());
//            } catch (ManagerNotFoundException | StockNotFoundException $ex) {
//                $stock = $this->officeUseCase->getMainStock();
//                $manager = $this->officeUseCase->getFirstManagerByStockId($stock->getId());
//                //throw new SecurePolicyException('current stock not found for temporary customer');
//            }
//
//            $city = $this->cityRepository->findById($this->mainConfig->getDefaultCity());
//
//            $customer = (new TemporaryCustomer())
//                ->setName('guest' . time())
//                ->setPhone(time())
//                ->setEmail('guest' . time() . '@guest.ru')
//                ->setCityId($city->getId())
//                ->setCustomerCity($city)
//                ->setManagerId($manager->getId())
//                ->setManager($manager)
//                ->setGroupId($this->mainConfig->getDefaultGuestGroup());
//        } else {
//            $customer = $this->customerRepository->findById($userData['customer_id']);
//        }
//
//        //Замешиваем доступ к прайсам
//        $pricesIds = [];
//
////        $pricesQ =
////            PriceAccessQuery::create('ac')
//////                ->usePricelistFileQuery()
//////                ->useProviderQuery()
//////                ->filterByContractorId($customer->getManager()->getShop()->getContractorId())
//////                ->endUse()
//////                ->endUse()
////                ->addAlias('s', 'shop_pricelist_sheets')
////                ->addJoin('ac.price_scheet_id','s.id','RIGHT JOIN')
////                ->_if($customer->getGroupId()!==null)
////                    ->where($customer->getGroupId() . ' LIKE ac.customer_group_id')
////                ->_endif()
////                ->_if($customer->getGroupId()!==null)
////                ->where($customer->getGroupId() . ' LIKE ac.customer_group_id')
////                ->_endif()
////                ->_if($customer->getId()!==null)
////                ->where($customer->getId() . ' LIKE ac.customer_id')
////                ->_endif()
////                ->_if($customer->getManager()->getShop()!==null)
////                ->where($customer->getManager()->getShop()->getId() . ' LIKE ac.shop_id')
////                ->_endif()
////        ;
//        $sql = 'SELECT
// GROUP_CONCAT(shop_pricelist_sheets.id) AS c
//FROM shop_price_access
//  INNER JOIN shop_pricelist_sheets
//    ON shop_pricelist_sheets.id LIKE shop_price_access.price_scheet_id
//
//WHERE ' . (int)$customer->getGroupId() . ' LIKE customer_group_id AND ' . (int)$customer->getManager()->getShop()->getId() .
//            ' LIKE shop_id AND ' . (int)$customer->getId() . ' LIKE customer_id';
//
//
//        $con = Propel::getServiceContainer()->getReadConnection(PriceAccessTableMap::DATABASE_NAME);
//        $stmt = $con->prepare($sql);
//        $stmt->execute();
//
//        $res = $stmt->fetch();
//
//        $priceIds = explode(',', $res['c']);
//
//        array_walk($priceIds, function (&$v) {
//            $v = (int)$v;
//        });
//
//        $customer->setAccessPrices($priceIds);
//
//        self::$customer = $customer;
//
//        return $customer;
//    }


}