<?php


namespace Shop\Presentation\Modules\AdminOrderItems;


use Core\Helpers\Date;
use Diamond\Helpers\Form;
use Shop\Domain\OrderItem\Contracts\OrderItemEntityInterface;
use Shop\Presentation\Helpers\Formatter;
use Shop\Infrastructure\Models\Order\Order;
use Shop\Infrastructure\Models\OrderItem\OrderItem;

trait FormatColumnsTrait
{

    /**
     * @param OrderItemEntityInterface|OrderItem $itemEntity
     * @return string
     */
    public function formatDate(OrderItemEntityInterface $itemEntity): string
    {
        return '<nobr>'.$itemEntity->getOrder()->getDatetime()->format(Date::formatDisplay()).'</nobr>';
    }

    /**
     * @param OrderItemEntityInterface $itemEntity
     * @return string
     */
    public function formatStock(OrderItemEntityInterface $itemEntity): string
    {
        return $itemEntity->getOrder()->getContractor()->getName();
    }

    /**
     * @param OrderItemEntityInterface $itemEntity
     * @return string
     */
    public function formatState(OrderItemEntityInterface $itemEntity): string
    {
        return Formatter::formatColor($itemEntity->getState());
    }

    /**
     * @param OrderItemEntityInterface $itemEntity
     * @return string
     */
    public function formatProvider(OrderItemEntityInterface $itemEntity): string
    {
        return $itemEntity->getProvider()->getName() .
            ($itemEntity->getProvider()->getContractorId() > 0 ? '' : Form::buildIcon('info', 'Контрагент не определен, при создании заказа возможен сбой'));
    }

    /**
     * @param OrderItemEntityInterface $itemEntity
     * @return string
     */
    public function formatActions(OrderItemEntityInterface $itemEntity): string
    {
        return $this->controlBuilder->buildActionMenuAdmin([], $itemEntity->getId())->render();
    }

    /**
     * @param OrderItemEntityInterface $itemEntity
     * @return string
     */
    public function formatOrder(OrderItemEntityInterface $itemEntity): string
    {
        return $itemEntity->getOrder()->getOrderCode();
    }

    /**
     * @param OrderItemEntityInterface $orderItem
     * @return string
     */
    public function formatClientFull(OrderItemEntityInterface $orderItem): string
    {
        return sprintf('%s (%s)',
            $orderItem->getOrder()->getCustomer()->getName(),
            $orderItem->getOrder()->getCustomer()->getCustomerGroup()->getName()
        );
    }

}