<?php


namespace Shop\Application\Office\SendNotifyCustomerRegistration;


use Shop\Domain\Customer\Contracts\CustomerEntityInterface;

class SendNotifyCustomerRegistrationCommand
{

    public function __construct(protected CustomerEntityInterface $customer, protected string $linkPersonal = '')
    {
        $this->customer = $customer;
    }

    /**
     * @return CustomerEntityInterface
     */
    public function getCustomer(): CustomerEntityInterface
    {
        return $this->customer;
    }

    public function getLinkPersonal(): string
    {
        return $this->linkPersonal;
    }

}