<?php


namespace Shop\Infrastructure\Repositories\FastLink;


use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;
use Shop\Domain\FastLink\FastLinkCollection;
use Shop\Infrastructure\Models\FastLink\FastLink;
use Shop\Infrastructure\Models\FastLink\FastLinkQuery;

class FastLinkRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    public static function createEntity(): EntityInterface
    {
        return new FastLink();
    }

    protected function createQuery(): ModelCriteria
    {
        return FastLinkQuery::create();
    }

    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {

    }


    protected function createCollection(): CollectionInterface
    {
        return new FastLinkCollection();
    }

}