<?php


namespace Shop\Infrastructure\Repositories\ComplexRate;


use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;
use Shop\Domain\ComplexRate\ComplexRateCollection;
use Shop\Infrastructure\Models\ComplexRate\ComplexRate;
use Shop\Infrastructure\Models\ComplexRate\ComplexRateQuery;

class ComplexRateRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    /**
     * @return EntityInterface
     */
    public static function createEntity(): EntityInterface
    {
        return new ComplexRate();
    }

    /**
     * @return ModelCriteria
     */
    protected function createQuery(): ModelCriteria
    {
        return ComplexRateQuery::create();
    }

    /**
     * @param PaginationInterface $criteria
     * @param ModelCriteria $dbCriteria
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {

    }

    protected function createCollection(): CollectionInterface
    {
        return new ComplexRateCollection();
    }
}