<?php

namespace Shop\Infrastructure\Models\Customer\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Infrastructure\Models\Basket\Basket;
use Shop\Infrastructure\Models\City\City;
use Shop\Infrastructure\Models\Customer\Customer as ChildCustomer;
use Shop\Infrastructure\Models\Customer\CustomerQuery as ChildCustomerQuery;
use Shop\Infrastructure\Models\CustomerGroup\CustomerGroup;
use Shop\Infrastructure\Models\CustomerSocialLogin\CustomerSocialLogin;
use Shop\Infrastructure\Models\Customer\Map\CustomerTableMap;
use Shop\Infrastructure\Models\DraftProduct\DraftProduct;
use Shop\Infrastructure\Models\FastLink\FastLink;
use Shop\Infrastructure\Models\Manager\Manager;
use Shop\Infrastructure\Models\Order\Order;
use Shop\Infrastructure\Models\Provider\Provider;
use Shop\Infrastructure\Models\Score\Score;
use Shop\Infrastructure\Models\Shop\Shop;

/**
 * Base class that represents a query for the 'shop_customer' table.
 *
 *
 *
 * @method     ChildCustomerQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildCustomerQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method     ChildCustomerQuery orderByEmail($order = Criteria::ASC) Order by the email column
 * @method     ChildCustomerQuery orderByPassword($order = Criteria::ASC) Order by the password column
 * @method     ChildCustomerQuery orderByPhone($order = Criteria::ASC) Order by the phone column
 * @method     ChildCustomerQuery orderByRegistred($order = Criteria::ASC) Order by the registred column
 * @method     ChildCustomerQuery orderByLastauth($order = Criteria::ASC) Order by the lastauth column
 * @method     ChildCustomerQuery orderByBlocked($order = Criteria::ASC) Order by the blocked column
 * @method     ChildCustomerQuery orderByNotifyType($order = Criteria::ASC) Order by the notify_type column
 * @method     ChildCustomerQuery orderByDelete($order = Criteria::ASC) Order by the delete column
 * @method     ChildCustomerQuery orderByDiscount($order = Criteria::ASC) Order by the discount column
 * @method     ChildCustomerQuery orderByInn($order = Criteria::ASC) Order by the inn column
 * @method     ChildCustomerQuery orderByOgrn($order = Criteria::ASC) Order by the ogrn column
 * @method     ChildCustomerQuery orderByCompany($order = Criteria::ASC) Order by the company column
 * @method     ChildCustomerQuery orderByInfoHidden($order = Criteria::ASC) Order by the info_hidden column
 * @method     ChildCustomerQuery orderByGroupId($order = Criteria::ASC) Order by the group_id column
 * @method     ChildCustomerQuery orderByCityId($order = Criteria::ASC) Order by the city_id column
 * @method     ChildCustomerQuery orderByManagerId($order = Criteria::ASC) Order by the manager_id column
 * @method     ChildCustomerQuery orderByNotifyOrder($order = Criteria::ASC) Order by the notify_order column
 * @method     ChildCustomerQuery orderByNotifyNews($order = Criteria::ASC) Order by the notify_news column
 * @method     ChildCustomerQuery orderByNotifyProducts($order = Criteria::ASC) Order by the notify_products column
 *
 * @method     ChildCustomerQuery groupById() Group by the id column
 * @method     ChildCustomerQuery groupByName() Group by the name column
 * @method     ChildCustomerQuery groupByEmail() Group by the email column
 * @method     ChildCustomerQuery groupByPassword() Group by the password column
 * @method     ChildCustomerQuery groupByPhone() Group by the phone column
 * @method     ChildCustomerQuery groupByRegistred() Group by the registred column
 * @method     ChildCustomerQuery groupByLastauth() Group by the lastauth column
 * @method     ChildCustomerQuery groupByBlocked() Group by the blocked column
 * @method     ChildCustomerQuery groupByNotifyType() Group by the notify_type column
 * @method     ChildCustomerQuery groupByDelete() Group by the delete column
 * @method     ChildCustomerQuery groupByDiscount() Group by the discount column
 * @method     ChildCustomerQuery groupByInn() Group by the inn column
 * @method     ChildCustomerQuery groupByOgrn() Group by the ogrn column
 * @method     ChildCustomerQuery groupByCompany() Group by the company column
 * @method     ChildCustomerQuery groupByInfoHidden() Group by the info_hidden column
 * @method     ChildCustomerQuery groupByGroupId() Group by the group_id column
 * @method     ChildCustomerQuery groupByCityId() Group by the city_id column
 * @method     ChildCustomerQuery groupByManagerId() Group by the manager_id column
 * @method     ChildCustomerQuery groupByNotifyOrder() Group by the notify_order column
 * @method     ChildCustomerQuery groupByNotifyNews() Group by the notify_news column
 * @method     ChildCustomerQuery groupByNotifyProducts() Group by the notify_products column
 *
 * @method     ChildCustomerQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildCustomerQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildCustomerQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildCustomerQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildCustomerQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildCustomerQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildCustomerQuery leftJoinCustomerGroup($relationAlias = null) Adds a LEFT JOIN clause to the query using the CustomerGroup relation
 * @method     ChildCustomerQuery rightJoinCustomerGroup($relationAlias = null) Adds a RIGHT JOIN clause to the query using the CustomerGroup relation
 * @method     ChildCustomerQuery innerJoinCustomerGroup($relationAlias = null) Adds a INNER JOIN clause to the query using the CustomerGroup relation
 *
 * @method     ChildCustomerQuery joinWithCustomerGroup($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the CustomerGroup relation
 *
 * @method     ChildCustomerQuery leftJoinWithCustomerGroup() Adds a LEFT JOIN clause and with to the query using the CustomerGroup relation
 * @method     ChildCustomerQuery rightJoinWithCustomerGroup() Adds a RIGHT JOIN clause and with to the query using the CustomerGroup relation
 * @method     ChildCustomerQuery innerJoinWithCustomerGroup() Adds a INNER JOIN clause and with to the query using the CustomerGroup relation
 *
 * @method     ChildCustomerQuery leftJoinCustomerCity($relationAlias = null) Adds a LEFT JOIN clause to the query using the CustomerCity relation
 * @method     ChildCustomerQuery rightJoinCustomerCity($relationAlias = null) Adds a RIGHT JOIN clause to the query using the CustomerCity relation
 * @method     ChildCustomerQuery innerJoinCustomerCity($relationAlias = null) Adds a INNER JOIN clause to the query using the CustomerCity relation
 *
 * @method     ChildCustomerQuery joinWithCustomerCity($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the CustomerCity relation
 *
 * @method     ChildCustomerQuery leftJoinWithCustomerCity() Adds a LEFT JOIN clause and with to the query using the CustomerCity relation
 * @method     ChildCustomerQuery rightJoinWithCustomerCity() Adds a RIGHT JOIN clause and with to the query using the CustomerCity relation
 * @method     ChildCustomerQuery innerJoinWithCustomerCity() Adds a INNER JOIN clause and with to the query using the CustomerCity relation
 *
 * @method     ChildCustomerQuery leftJoinManager($relationAlias = null) Adds a LEFT JOIN clause to the query using the Manager relation
 * @method     ChildCustomerQuery rightJoinManager($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Manager relation
 * @method     ChildCustomerQuery innerJoinManager($relationAlias = null) Adds a INNER JOIN clause to the query using the Manager relation
 *
 * @method     ChildCustomerQuery joinWithManager($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Manager relation
 *
 * @method     ChildCustomerQuery leftJoinWithManager() Adds a LEFT JOIN clause and with to the query using the Manager relation
 * @method     ChildCustomerQuery rightJoinWithManager() Adds a RIGHT JOIN clause and with to the query using the Manager relation
 * @method     ChildCustomerQuery innerJoinWithManager() Adds a INNER JOIN clause and with to the query using the Manager relation
 *
 * @method     ChildCustomerQuery leftJoinCustomerSocialLogin($relationAlias = null) Adds a LEFT JOIN clause to the query using the CustomerSocialLogin relation
 * @method     ChildCustomerQuery rightJoinCustomerSocialLogin($relationAlias = null) Adds a RIGHT JOIN clause to the query using the CustomerSocialLogin relation
 * @method     ChildCustomerQuery innerJoinCustomerSocialLogin($relationAlias = null) Adds a INNER JOIN clause to the query using the CustomerSocialLogin relation
 *
 * @method     ChildCustomerQuery joinWithCustomerSocialLogin($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the CustomerSocialLogin relation
 *
 * @method     ChildCustomerQuery leftJoinWithCustomerSocialLogin() Adds a LEFT JOIN clause and with to the query using the CustomerSocialLogin relation
 * @method     ChildCustomerQuery rightJoinWithCustomerSocialLogin() Adds a RIGHT JOIN clause and with to the query using the CustomerSocialLogin relation
 * @method     ChildCustomerQuery innerJoinWithCustomerSocialLogin() Adds a INNER JOIN clause and with to the query using the CustomerSocialLogin relation
 *
 * @method     ChildCustomerQuery leftJoinBasket($relationAlias = null) Adds a LEFT JOIN clause to the query using the Basket relation
 * @method     ChildCustomerQuery rightJoinBasket($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Basket relation
 * @method     ChildCustomerQuery innerJoinBasket($relationAlias = null) Adds a INNER JOIN clause to the query using the Basket relation
 *
 * @method     ChildCustomerQuery joinWithBasket($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Basket relation
 *
 * @method     ChildCustomerQuery leftJoinWithBasket() Adds a LEFT JOIN clause and with to the query using the Basket relation
 * @method     ChildCustomerQuery rightJoinWithBasket() Adds a RIGHT JOIN clause and with to the query using the Basket relation
 * @method     ChildCustomerQuery innerJoinWithBasket() Adds a INNER JOIN clause and with to the query using the Basket relation
 *
 * @method     ChildCustomerQuery leftJoinShop($relationAlias = null) Adds a LEFT JOIN clause to the query using the Shop relation
 * @method     ChildCustomerQuery rightJoinShop($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Shop relation
 * @method     ChildCustomerQuery innerJoinShop($relationAlias = null) Adds a INNER JOIN clause to the query using the Shop relation
 *
 * @method     ChildCustomerQuery joinWithShop($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Shop relation
 *
 * @method     ChildCustomerQuery leftJoinWithShop() Adds a LEFT JOIN clause and with to the query using the Shop relation
 * @method     ChildCustomerQuery rightJoinWithShop() Adds a RIGHT JOIN clause and with to the query using the Shop relation
 * @method     ChildCustomerQuery innerJoinWithShop() Adds a INNER JOIN clause and with to the query using the Shop relation
 *
 * @method     ChildCustomerQuery leftJoinOrderRelatedByCustomerId($relationAlias = null) Adds a LEFT JOIN clause to the query using the OrderRelatedByCustomerId relation
 * @method     ChildCustomerQuery rightJoinOrderRelatedByCustomerId($relationAlias = null) Adds a RIGHT JOIN clause to the query using the OrderRelatedByCustomerId relation
 * @method     ChildCustomerQuery innerJoinOrderRelatedByCustomerId($relationAlias = null) Adds a INNER JOIN clause to the query using the OrderRelatedByCustomerId relation
 *
 * @method     ChildCustomerQuery joinWithOrderRelatedByCustomerId($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the OrderRelatedByCustomerId relation
 *
 * @method     ChildCustomerQuery leftJoinWithOrderRelatedByCustomerId() Adds a LEFT JOIN clause and with to the query using the OrderRelatedByCustomerId relation
 * @method     ChildCustomerQuery rightJoinWithOrderRelatedByCustomerId() Adds a RIGHT JOIN clause and with to the query using the OrderRelatedByCustomerId relation
 * @method     ChildCustomerQuery innerJoinWithOrderRelatedByCustomerId() Adds a INNER JOIN clause and with to the query using the OrderRelatedByCustomerId relation
 *
 * @method     ChildCustomerQuery leftJoinOrderRelatedByContractorId($relationAlias = null) Adds a LEFT JOIN clause to the query using the OrderRelatedByContractorId relation
 * @method     ChildCustomerQuery rightJoinOrderRelatedByContractorId($relationAlias = null) Adds a RIGHT JOIN clause to the query using the OrderRelatedByContractorId relation
 * @method     ChildCustomerQuery innerJoinOrderRelatedByContractorId($relationAlias = null) Adds a INNER JOIN clause to the query using the OrderRelatedByContractorId relation
 *
 * @method     ChildCustomerQuery joinWithOrderRelatedByContractorId($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the OrderRelatedByContractorId relation
 *
 * @method     ChildCustomerQuery leftJoinWithOrderRelatedByContractorId() Adds a LEFT JOIN clause and with to the query using the OrderRelatedByContractorId relation
 * @method     ChildCustomerQuery rightJoinWithOrderRelatedByContractorId() Adds a RIGHT JOIN clause and with to the query using the OrderRelatedByContractorId relation
 * @method     ChildCustomerQuery innerJoinWithOrderRelatedByContractorId() Adds a INNER JOIN clause and with to the query using the OrderRelatedByContractorId relation
 *
 * @method     ChildCustomerQuery leftJoinFastLinkRelatedByOwnerCustomerId($relationAlias = null) Adds a LEFT JOIN clause to the query using the FastLinkRelatedByOwnerCustomerId relation
 * @method     ChildCustomerQuery rightJoinFastLinkRelatedByOwnerCustomerId($relationAlias = null) Adds a RIGHT JOIN clause to the query using the FastLinkRelatedByOwnerCustomerId relation
 * @method     ChildCustomerQuery innerJoinFastLinkRelatedByOwnerCustomerId($relationAlias = null) Adds a INNER JOIN clause to the query using the FastLinkRelatedByOwnerCustomerId relation
 *
 * @method     ChildCustomerQuery joinWithFastLinkRelatedByOwnerCustomerId($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the FastLinkRelatedByOwnerCustomerId relation
 *
 * @method     ChildCustomerQuery leftJoinWithFastLinkRelatedByOwnerCustomerId() Adds a LEFT JOIN clause and with to the query using the FastLinkRelatedByOwnerCustomerId relation
 * @method     ChildCustomerQuery rightJoinWithFastLinkRelatedByOwnerCustomerId() Adds a RIGHT JOIN clause and with to the query using the FastLinkRelatedByOwnerCustomerId relation
 * @method     ChildCustomerQuery innerJoinWithFastLinkRelatedByOwnerCustomerId() Adds a INNER JOIN clause and with to the query using the FastLinkRelatedByOwnerCustomerId relation
 *
 * @method     ChildCustomerQuery leftJoinFastLinkRelatedByCode($relationAlias = null) Adds a LEFT JOIN clause to the query using the FastLinkRelatedByCode relation
 * @method     ChildCustomerQuery rightJoinFastLinkRelatedByCode($relationAlias = null) Adds a RIGHT JOIN clause to the query using the FastLinkRelatedByCode relation
 * @method     ChildCustomerQuery innerJoinFastLinkRelatedByCode($relationAlias = null) Adds a INNER JOIN clause to the query using the FastLinkRelatedByCode relation
 *
 * @method     ChildCustomerQuery joinWithFastLinkRelatedByCode($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the FastLinkRelatedByCode relation
 *
 * @method     ChildCustomerQuery leftJoinWithFastLinkRelatedByCode() Adds a LEFT JOIN clause and with to the query using the FastLinkRelatedByCode relation
 * @method     ChildCustomerQuery rightJoinWithFastLinkRelatedByCode() Adds a RIGHT JOIN clause and with to the query using the FastLinkRelatedByCode relation
 * @method     ChildCustomerQuery innerJoinWithFastLinkRelatedByCode() Adds a INNER JOIN clause and with to the query using the FastLinkRelatedByCode relation
 *
 * @method     ChildCustomerQuery leftJoinProvider($relationAlias = null) Adds a LEFT JOIN clause to the query using the Provider relation
 * @method     ChildCustomerQuery rightJoinProvider($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Provider relation
 * @method     ChildCustomerQuery innerJoinProvider($relationAlias = null) Adds a INNER JOIN clause to the query using the Provider relation
 *
 * @method     ChildCustomerQuery joinWithProvider($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Provider relation
 *
 * @method     ChildCustomerQuery leftJoinWithProvider() Adds a LEFT JOIN clause and with to the query using the Provider relation
 * @method     ChildCustomerQuery rightJoinWithProvider() Adds a RIGHT JOIN clause and with to the query using the Provider relation
 * @method     ChildCustomerQuery innerJoinWithProvider() Adds a INNER JOIN clause and with to the query using the Provider relation
 *
 * @method     ChildCustomerQuery leftJoinScore($relationAlias = null) Adds a LEFT JOIN clause to the query using the Score relation
 * @method     ChildCustomerQuery rightJoinScore($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Score relation
 * @method     ChildCustomerQuery innerJoinScore($relationAlias = null) Adds a INNER JOIN clause to the query using the Score relation
 *
 * @method     ChildCustomerQuery joinWithScore($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Score relation
 *
 * @method     ChildCustomerQuery leftJoinWithScore() Adds a LEFT JOIN clause and with to the query using the Score relation
 * @method     ChildCustomerQuery rightJoinWithScore() Adds a RIGHT JOIN clause and with to the query using the Score relation
 * @method     ChildCustomerQuery innerJoinWithScore() Adds a INNER JOIN clause and with to the query using the Score relation
 *
 * @method     ChildCustomerQuery leftJoinDraftProduct($relationAlias = null) Adds a LEFT JOIN clause to the query using the DraftProduct relation
 * @method     ChildCustomerQuery rightJoinDraftProduct($relationAlias = null) Adds a RIGHT JOIN clause to the query using the DraftProduct relation
 * @method     ChildCustomerQuery innerJoinDraftProduct($relationAlias = null) Adds a INNER JOIN clause to the query using the DraftProduct relation
 *
 * @method     ChildCustomerQuery joinWithDraftProduct($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the DraftProduct relation
 *
 * @method     ChildCustomerQuery leftJoinWithDraftProduct() Adds a LEFT JOIN clause and with to the query using the DraftProduct relation
 * @method     ChildCustomerQuery rightJoinWithDraftProduct() Adds a RIGHT JOIN clause and with to the query using the DraftProduct relation
 * @method     ChildCustomerQuery innerJoinWithDraftProduct() Adds a INNER JOIN clause and with to the query using the DraftProduct relation
 *
 * @method     \Shop\Infrastructure\Models\CustomerGroup\CustomerGroupQuery|\Shop\Infrastructure\Models\City\CityQuery|\Shop\Infrastructure\Models\Manager\ManagerQuery|\Shop\Infrastructure\Models\CustomerSocialLogin\CustomerSocialLoginQuery|\Shop\Infrastructure\Models\Basket\BasketQuery|\Shop\Infrastructure\Models\Shop\ShopQuery|\Shop\Infrastructure\Models\Order\OrderQuery|\Shop\Infrastructure\Models\FastLink\FastLinkQuery|\Shop\Infrastructure\Models\Provider\ProviderQuery|\Shop\Infrastructure\Models\Score\ScoreQuery|\Shop\Infrastructure\Models\DraftProduct\DraftProductQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildCustomer|null findOne(?ConnectionInterface $con = null) Return the first ChildCustomer matching the query
 * @method     ChildCustomer findOneOrCreate(?ConnectionInterface $con = null) Return the first ChildCustomer matching the query, or a new ChildCustomer object populated from the query conditions when no match is found
 *
 * @method     ChildCustomer|null findOneById(int $id) Return the first ChildCustomer filtered by the id column
 * @method     ChildCustomer|null findOneByName(string $name) Return the first ChildCustomer filtered by the name column
 * @method     ChildCustomer|null findOneByEmail(string $email) Return the first ChildCustomer filtered by the email column
 * @method     ChildCustomer|null findOneByPassword(string $password) Return the first ChildCustomer filtered by the password column
 * @method     ChildCustomer|null findOneByPhone(string $phone) Return the first ChildCustomer filtered by the phone column
 * @method     ChildCustomer|null findOneByRegistred(string $registred) Return the first ChildCustomer filtered by the registred column
 * @method     ChildCustomer|null findOneByLastauth(string $lastauth) Return the first ChildCustomer filtered by the lastauth column
 * @method     ChildCustomer|null findOneByBlocked(string $blocked) Return the first ChildCustomer filtered by the blocked column
 * @method     ChildCustomer|null findOneByNotifyType(string $notify_type) Return the first ChildCustomer filtered by the notify_type column
 * @method     ChildCustomer|null findOneByDelete(int $delete) Return the first ChildCustomer filtered by the delete column
 * @method     ChildCustomer|null findOneByDiscount(string $discount) Return the first ChildCustomer filtered by the discount column
 * @method     ChildCustomer|null findOneByInn(string $inn) Return the first ChildCustomer filtered by the inn column
 * @method     ChildCustomer|null findOneByOgrn(string $ogrn) Return the first ChildCustomer filtered by the ogrn column
 * @method     ChildCustomer|null findOneByCompany(string $company) Return the first ChildCustomer filtered by the company column
 * @method     ChildCustomer|null findOneByInfoHidden(string $info_hidden) Return the first ChildCustomer filtered by the info_hidden column
 * @method     ChildCustomer|null findOneByGroupId(int $group_id) Return the first ChildCustomer filtered by the group_id column
 * @method     ChildCustomer|null findOneByCityId(int $city_id) Return the first ChildCustomer filtered by the city_id column
 * @method     ChildCustomer|null findOneByManagerId(int $manager_id) Return the first ChildCustomer filtered by the manager_id column
 * @method     ChildCustomer|null findOneByNotifyOrder(string $notify_order) Return the first ChildCustomer filtered by the notify_order column
 * @method     ChildCustomer|null findOneByNotifyNews(string $notify_news) Return the first ChildCustomer filtered by the notify_news column
 * @method     ChildCustomer|null findOneByNotifyProducts(string $notify_products) Return the first ChildCustomer filtered by the notify_products column *

 * @method     ChildCustomer requirePk($key, ?ConnectionInterface $con = null) Return the ChildCustomer by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOne(?ConnectionInterface $con = null) Return the first ChildCustomer matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildCustomer requireOneById(int $id) Return the first ChildCustomer filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByName(string $name) Return the first ChildCustomer filtered by the name column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByEmail(string $email) Return the first ChildCustomer filtered by the email column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByPassword(string $password) Return the first ChildCustomer filtered by the password column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByPhone(string $phone) Return the first ChildCustomer filtered by the phone column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByRegistred(string $registred) Return the first ChildCustomer filtered by the registred column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByLastauth(string $lastauth) Return the first ChildCustomer filtered by the lastauth column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByBlocked(string $blocked) Return the first ChildCustomer filtered by the blocked column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByNotifyType(string $notify_type) Return the first ChildCustomer filtered by the notify_type column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByDelete(int $delete) Return the first ChildCustomer filtered by the delete column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByDiscount(string $discount) Return the first ChildCustomer filtered by the discount column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByInn(string $inn) Return the first ChildCustomer filtered by the inn column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByOgrn(string $ogrn) Return the first ChildCustomer filtered by the ogrn column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByCompany(string $company) Return the first ChildCustomer filtered by the company column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByInfoHidden(string $info_hidden) Return the first ChildCustomer filtered by the info_hidden column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByGroupId(int $group_id) Return the first ChildCustomer filtered by the group_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByCityId(int $city_id) Return the first ChildCustomer filtered by the city_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByManagerId(int $manager_id) Return the first ChildCustomer filtered by the manager_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByNotifyOrder(string $notify_order) Return the first ChildCustomer filtered by the notify_order column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByNotifyNews(string $notify_news) Return the first ChildCustomer filtered by the notify_news column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCustomer requireOneByNotifyProducts(string $notify_products) Return the first ChildCustomer filtered by the notify_products column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildCustomer[]|Collection find(?ConnectionInterface $con = null) Return ChildCustomer objects based on current ModelCriteria
 * @psalm-method Collection&\Traversable<ChildCustomer> find(?ConnectionInterface $con = null) Return ChildCustomer objects based on current ModelCriteria
 * @method     ChildCustomer[]|Collection findById(int $id) Return ChildCustomer objects filtered by the id column
 * @psalm-method Collection&\Traversable<ChildCustomer> findById(int $id) Return ChildCustomer objects filtered by the id column
 * @method     ChildCustomer[]|Collection findByName(string $name) Return ChildCustomer objects filtered by the name column
 * @psalm-method Collection&\Traversable<ChildCustomer> findByName(string $name) Return ChildCustomer objects filtered by the name column
 * @method     ChildCustomer[]|Collection findByEmail(string $email) Return ChildCustomer objects filtered by the email column
 * @psalm-method Collection&\Traversable<ChildCustomer> findByEmail(string $email) Return ChildCustomer objects filtered by the email column
 * @method     ChildCustomer[]|Collection findByPassword(string $password) Return ChildCustomer objects filtered by the password column
 * @psalm-method Collection&\Traversable<ChildCustomer> findByPassword(string $password) Return ChildCustomer objects filtered by the password column
 * @method     ChildCustomer[]|Collection findByPhone(string $phone) Return ChildCustomer objects filtered by the phone column
 * @psalm-method Collection&\Traversable<ChildCustomer> findByPhone(string $phone) Return ChildCustomer objects filtered by the phone column
 * @method     ChildCustomer[]|Collection findByRegistred(string $registred) Return ChildCustomer objects filtered by the registred column
 * @psalm-method Collection&\Traversable<ChildCustomer> findByRegistred(string $registred) Return ChildCustomer objects filtered by the registred column
 * @method     ChildCustomer[]|Collection findByLastauth(string $lastauth) Return ChildCustomer objects filtered by the lastauth column
 * @psalm-method Collection&\Traversable<ChildCustomer> findByLastauth(string $lastauth) Return ChildCustomer objects filtered by the lastauth column
 * @method     ChildCustomer[]|Collection findByBlocked(string $blocked) Return ChildCustomer objects filtered by the blocked column
 * @psalm-method Collection&\Traversable<ChildCustomer> findByBlocked(string $blocked) Return ChildCustomer objects filtered by the blocked column
 * @method     ChildCustomer[]|Collection findByNotifyType(string $notify_type) Return ChildCustomer objects filtered by the notify_type column
 * @psalm-method Collection&\Traversable<ChildCustomer> findByNotifyType(string $notify_type) Return ChildCustomer objects filtered by the notify_type column
 * @method     ChildCustomer[]|Collection findByDelete(int $delete) Return ChildCustomer objects filtered by the delete column
 * @psalm-method Collection&\Traversable<ChildCustomer> findByDelete(int $delete) Return ChildCustomer objects filtered by the delete column
 * @method     ChildCustomer[]|Collection findByDiscount(string $discount) Return ChildCustomer objects filtered by the discount column
 * @psalm-method Collection&\Traversable<ChildCustomer> findByDiscount(string $discount) Return ChildCustomer objects filtered by the discount column
 * @method     ChildCustomer[]|Collection findByInn(string $inn) Return ChildCustomer objects filtered by the inn column
 * @psalm-method Collection&\Traversable<ChildCustomer> findByInn(string $inn) Return ChildCustomer objects filtered by the inn column
 * @method     ChildCustomer[]|Collection findByOgrn(string $ogrn) Return ChildCustomer objects filtered by the ogrn column
 * @psalm-method Collection&\Traversable<ChildCustomer> findByOgrn(string $ogrn) Return ChildCustomer objects filtered by the ogrn column
 * @method     ChildCustomer[]|Collection findByCompany(string $company) Return ChildCustomer objects filtered by the company column
 * @psalm-method Collection&\Traversable<ChildCustomer> findByCompany(string $company) Return ChildCustomer objects filtered by the company column
 * @method     ChildCustomer[]|Collection findByInfoHidden(string $info_hidden) Return ChildCustomer objects filtered by the info_hidden column
 * @psalm-method Collection&\Traversable<ChildCustomer> findByInfoHidden(string $info_hidden) Return ChildCustomer objects filtered by the info_hidden column
 * @method     ChildCustomer[]|Collection findByGroupId(int $group_id) Return ChildCustomer objects filtered by the group_id column
 * @psalm-method Collection&\Traversable<ChildCustomer> findByGroupId(int $group_id) Return ChildCustomer objects filtered by the group_id column
 * @method     ChildCustomer[]|Collection findByCityId(int $city_id) Return ChildCustomer objects filtered by the city_id column
 * @psalm-method Collection&\Traversable<ChildCustomer> findByCityId(int $city_id) Return ChildCustomer objects filtered by the city_id column
 * @method     ChildCustomer[]|Collection findByManagerId(int $manager_id) Return ChildCustomer objects filtered by the manager_id column
 * @psalm-method Collection&\Traversable<ChildCustomer> findByManagerId(int $manager_id) Return ChildCustomer objects filtered by the manager_id column
 * @method     ChildCustomer[]|Collection findByNotifyOrder(string $notify_order) Return ChildCustomer objects filtered by the notify_order column
 * @psalm-method Collection&\Traversable<ChildCustomer> findByNotifyOrder(string $notify_order) Return ChildCustomer objects filtered by the notify_order column
 * @method     ChildCustomer[]|Collection findByNotifyNews(string $notify_news) Return ChildCustomer objects filtered by the notify_news column
 * @psalm-method Collection&\Traversable<ChildCustomer> findByNotifyNews(string $notify_news) Return ChildCustomer objects filtered by the notify_news column
 * @method     ChildCustomer[]|Collection findByNotifyProducts(string $notify_products) Return ChildCustomer objects filtered by the notify_products column
 * @psalm-method Collection&\Traversable<ChildCustomer> findByNotifyProducts(string $notify_products) Return ChildCustomer objects filtered by the notify_products column
 * @method     ChildCustomer[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 * @psalm-method \Propel\Runtime\Util\PropelModelPager&\Traversable<ChildCustomer> paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class CustomerQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Infrastructure\Models\Customer\Base\CustomerQuery object.
     *
     * @param string $dbName The database name
     * @param string $modelName The phpName of a model, e.g. 'Book'
     * @param string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Infrastructure\\Models\\Customer\\Customer', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildCustomerQuery object.
     *
     * @param string $modelAlias The alias of a model in the query
     * @param Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildCustomerQuery
     */
    public static function create(?string $modelAlias = null, ?Criteria $criteria = null): Criteria
    {
        if ($criteria instanceof ChildCustomerQuery) {
            return $criteria;
        }
        $query = new ChildCustomerQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildCustomer|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ?ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(CustomerTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = CustomerTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildCustomer A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `name`, `email`, `password`, `phone`, `registred`, `lastauth`, `blocked`, `notify_type`, `delete`, `discount`, `inn`, `ogrn`, `company`, `info_hidden`, `group_id`, `city_id`, `manager_id`, `notify_order`, `notify_news`, `notify_products` FROM `shop_customer` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildCustomer $obj */
            $obj = new ChildCustomer();
            $obj->hydrate($row);
            CustomerTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @return ChildCustomer|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param array $keys Primary keys to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return Collection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param mixed $key Primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        $this->addUsingAlias(CustomerTableMap::COL_ID, $key, Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param array|int $keys The list of primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        $this->addUsingAlias(CustomerTableMap::COL_ID, $keys, Criteria::IN);

        return $this;
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterById($id = null, ?string $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(CustomerTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(CustomerTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CustomerTableMap::COL_ID, $id, $comparison);

        return $this;
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%', Criteria::LIKE); // WHERE name LIKE '%fooValue%'
     * $query->filterByName(['foo', 'bar']); // WHERE name IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $name The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByName($name = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CustomerTableMap::COL_NAME, $name, $comparison);

        return $this;
    }

    /**
     * Filter the query on the email column
     *
     * Example usage:
     * <code>
     * $query->filterByEmail('fooValue');   // WHERE email = 'fooValue'
     * $query->filterByEmail('%fooValue%', Criteria::LIKE); // WHERE email LIKE '%fooValue%'
     * $query->filterByEmail(['foo', 'bar']); // WHERE email IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $email The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByEmail($email = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($email)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CustomerTableMap::COL_EMAIL, $email, $comparison);

        return $this;
    }

    /**
     * Filter the query on the password column
     *
     * Example usage:
     * <code>
     * $query->filterByPassword('fooValue');   // WHERE password = 'fooValue'
     * $query->filterByPassword('%fooValue%', Criteria::LIKE); // WHERE password LIKE '%fooValue%'
     * $query->filterByPassword(['foo', 'bar']); // WHERE password IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $password The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPassword($password = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($password)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CustomerTableMap::COL_PASSWORD, $password, $comparison);

        return $this;
    }

    /**
     * Filter the query on the phone column
     *
     * Example usage:
     * <code>
     * $query->filterByPhone('fooValue');   // WHERE phone = 'fooValue'
     * $query->filterByPhone('%fooValue%', Criteria::LIKE); // WHERE phone LIKE '%fooValue%'
     * $query->filterByPhone(['foo', 'bar']); // WHERE phone IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $phone The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPhone($phone = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($phone)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CustomerTableMap::COL_PHONE, $phone, $comparison);

        return $this;
    }

    /**
     * Filter the query on the registred column
     *
     * Example usage:
     * <code>
     * $query->filterByRegistred('2011-03-14'); // WHERE registred = '2011-03-14'
     * $query->filterByRegistred('now'); // WHERE registred = '2011-03-14'
     * $query->filterByRegistred(array('max' => 'yesterday')); // WHERE registred > '2011-03-13'
     * </code>
     *
     * @param mixed $registred The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByRegistred($registred = null, ?string $comparison = null)
    {
        if (is_array($registred)) {
            $useMinMax = false;
            if (isset($registred['min'])) {
                $this->addUsingAlias(CustomerTableMap::COL_REGISTRED, $registred['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($registred['max'])) {
                $this->addUsingAlias(CustomerTableMap::COL_REGISTRED, $registred['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CustomerTableMap::COL_REGISTRED, $registred, $comparison);

        return $this;
    }

    /**
     * Filter the query on the lastauth column
     *
     * Example usage:
     * <code>
     * $query->filterByLastauth('2011-03-14'); // WHERE lastauth = '2011-03-14'
     * $query->filterByLastauth('now'); // WHERE lastauth = '2011-03-14'
     * $query->filterByLastauth(array('max' => 'yesterday')); // WHERE lastauth > '2011-03-13'
     * </code>
     *
     * @param mixed $lastauth The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByLastauth($lastauth = null, ?string $comparison = null)
    {
        if (is_array($lastauth)) {
            $useMinMax = false;
            if (isset($lastauth['min'])) {
                $this->addUsingAlias(CustomerTableMap::COL_LASTAUTH, $lastauth['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($lastauth['max'])) {
                $this->addUsingAlias(CustomerTableMap::COL_LASTAUTH, $lastauth['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CustomerTableMap::COL_LASTAUTH, $lastauth, $comparison);

        return $this;
    }

    /**
     * Filter the query on the blocked column
     *
     * Example usage:
     * <code>
     * $query->filterByBlocked('fooValue');   // WHERE blocked = 'fooValue'
     * $query->filterByBlocked('%fooValue%', Criteria::LIKE); // WHERE blocked LIKE '%fooValue%'
     * $query->filterByBlocked(['foo', 'bar']); // WHERE blocked IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $blocked The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByBlocked($blocked = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($blocked)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CustomerTableMap::COL_BLOCKED, $blocked, $comparison);

        return $this;
    }

    /**
     * Filter the query on the notify_type column
     *
     * Example usage:
     * <code>
     * $query->filterByNotifyType('fooValue');   // WHERE notify_type = 'fooValue'
     * $query->filterByNotifyType('%fooValue%', Criteria::LIKE); // WHERE notify_type LIKE '%fooValue%'
     * $query->filterByNotifyType(['foo', 'bar']); // WHERE notify_type IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $notifyType The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByNotifyType($notifyType = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($notifyType)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CustomerTableMap::COL_NOTIFY_TYPE, $notifyType, $comparison);

        return $this;
    }

    /**
     * Filter the query on the delete column
     *
     * Example usage:
     * <code>
     * $query->filterByDelete(1234); // WHERE delete = 1234
     * $query->filterByDelete(array(12, 34)); // WHERE delete IN (12, 34)
     * $query->filterByDelete(array('min' => 12)); // WHERE delete > 12
     * </code>
     *
     * @param mixed $delete The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByDelete($delete = null, ?string $comparison = null)
    {
        if (is_array($delete)) {
            $useMinMax = false;
            if (isset($delete['min'])) {
                $this->addUsingAlias(CustomerTableMap::COL_DELETE, $delete['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($delete['max'])) {
                $this->addUsingAlias(CustomerTableMap::COL_DELETE, $delete['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CustomerTableMap::COL_DELETE, $delete, $comparison);

        return $this;
    }

    /**
     * Filter the query on the discount column
     *
     * Example usage:
     * <code>
     * $query->filterByDiscount(1234); // WHERE discount = 1234
     * $query->filterByDiscount(array(12, 34)); // WHERE discount IN (12, 34)
     * $query->filterByDiscount(array('min' => 12)); // WHERE discount > 12
     * </code>
     *
     * @param mixed $discount The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByDiscount($discount = null, ?string $comparison = null)
    {
        if (is_array($discount)) {
            $useMinMax = false;
            if (isset($discount['min'])) {
                $this->addUsingAlias(CustomerTableMap::COL_DISCOUNT, $discount['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($discount['max'])) {
                $this->addUsingAlias(CustomerTableMap::COL_DISCOUNT, $discount['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CustomerTableMap::COL_DISCOUNT, $discount, $comparison);

        return $this;
    }

    /**
     * Filter the query on the inn column
     *
     * Example usage:
     * <code>
     * $query->filterByInn('fooValue');   // WHERE inn = 'fooValue'
     * $query->filterByInn('%fooValue%', Criteria::LIKE); // WHERE inn LIKE '%fooValue%'
     * $query->filterByInn(['foo', 'bar']); // WHERE inn IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $inn The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByInn($inn = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($inn)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CustomerTableMap::COL_INN, $inn, $comparison);

        return $this;
    }

    /**
     * Filter the query on the ogrn column
     *
     * Example usage:
     * <code>
     * $query->filterByOgrn('fooValue');   // WHERE ogrn = 'fooValue'
     * $query->filterByOgrn('%fooValue%', Criteria::LIKE); // WHERE ogrn LIKE '%fooValue%'
     * $query->filterByOgrn(['foo', 'bar']); // WHERE ogrn IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $ogrn The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByOgrn($ogrn = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($ogrn)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CustomerTableMap::COL_OGRN, $ogrn, $comparison);

        return $this;
    }

    /**
     * Filter the query on the company column
     *
     * Example usage:
     * <code>
     * $query->filterByCompany('fooValue');   // WHERE company = 'fooValue'
     * $query->filterByCompany('%fooValue%', Criteria::LIKE); // WHERE company LIKE '%fooValue%'
     * $query->filterByCompany(['foo', 'bar']); // WHERE company IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $company The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByCompany($company = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($company)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CustomerTableMap::COL_COMPANY, $company, $comparison);

        return $this;
    }

    /**
     * Filter the query on the info_hidden column
     *
     * Example usage:
     * <code>
     * $query->filterByInfoHidden('fooValue');   // WHERE info_hidden = 'fooValue'
     * $query->filterByInfoHidden('%fooValue%', Criteria::LIKE); // WHERE info_hidden LIKE '%fooValue%'
     * $query->filterByInfoHidden(['foo', 'bar']); // WHERE info_hidden IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $infoHidden The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByInfoHidden($infoHidden = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($infoHidden)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CustomerTableMap::COL_INFO_HIDDEN, $infoHidden, $comparison);

        return $this;
    }

    /**
     * Filter the query on the group_id column
     *
     * Example usage:
     * <code>
     * $query->filterByGroupId(1234); // WHERE group_id = 1234
     * $query->filterByGroupId(array(12, 34)); // WHERE group_id IN (12, 34)
     * $query->filterByGroupId(array('min' => 12)); // WHERE group_id > 12
     * </code>
     *
     * @see       filterByCustomerGroup()
     *
     * @param mixed $groupId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByGroupId($groupId = null, ?string $comparison = null)
    {
        if (is_array($groupId)) {
            $useMinMax = false;
            if (isset($groupId['min'])) {
                $this->addUsingAlias(CustomerTableMap::COL_GROUP_ID, $groupId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($groupId['max'])) {
                $this->addUsingAlias(CustomerTableMap::COL_GROUP_ID, $groupId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CustomerTableMap::COL_GROUP_ID, $groupId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the city_id column
     *
     * Example usage:
     * <code>
     * $query->filterByCityId(1234); // WHERE city_id = 1234
     * $query->filterByCityId(array(12, 34)); // WHERE city_id IN (12, 34)
     * $query->filterByCityId(array('min' => 12)); // WHERE city_id > 12
     * </code>
     *
     * @see       filterByCustomerCity()
     *
     * @param mixed $cityId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByCityId($cityId = null, ?string $comparison = null)
    {
        if (is_array($cityId)) {
            $useMinMax = false;
            if (isset($cityId['min'])) {
                $this->addUsingAlias(CustomerTableMap::COL_CITY_ID, $cityId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($cityId['max'])) {
                $this->addUsingAlias(CustomerTableMap::COL_CITY_ID, $cityId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CustomerTableMap::COL_CITY_ID, $cityId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the manager_id column
     *
     * Example usage:
     * <code>
     * $query->filterByManagerId(1234); // WHERE manager_id = 1234
     * $query->filterByManagerId(array(12, 34)); // WHERE manager_id IN (12, 34)
     * $query->filterByManagerId(array('min' => 12)); // WHERE manager_id > 12
     * </code>
     *
     * @see       filterByManager()
     *
     * @param mixed $managerId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByManagerId($managerId = null, ?string $comparison = null)
    {
        if (is_array($managerId)) {
            $useMinMax = false;
            if (isset($managerId['min'])) {
                $this->addUsingAlias(CustomerTableMap::COL_MANAGER_ID, $managerId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($managerId['max'])) {
                $this->addUsingAlias(CustomerTableMap::COL_MANAGER_ID, $managerId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CustomerTableMap::COL_MANAGER_ID, $managerId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the notify_order column
     *
     * Example usage:
     * <code>
     * $query->filterByNotifyOrder('fooValue');   // WHERE notify_order = 'fooValue'
     * $query->filterByNotifyOrder('%fooValue%', Criteria::LIKE); // WHERE notify_order LIKE '%fooValue%'
     * $query->filterByNotifyOrder(['foo', 'bar']); // WHERE notify_order IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $notifyOrder The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByNotifyOrder($notifyOrder = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($notifyOrder)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CustomerTableMap::COL_NOTIFY_ORDER, $notifyOrder, $comparison);

        return $this;
    }

    /**
     * Filter the query on the notify_news column
     *
     * Example usage:
     * <code>
     * $query->filterByNotifyNews('fooValue');   // WHERE notify_news = 'fooValue'
     * $query->filterByNotifyNews('%fooValue%', Criteria::LIKE); // WHERE notify_news LIKE '%fooValue%'
     * $query->filterByNotifyNews(['foo', 'bar']); // WHERE notify_news IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $notifyNews The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByNotifyNews($notifyNews = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($notifyNews)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CustomerTableMap::COL_NOTIFY_NEWS, $notifyNews, $comparison);

        return $this;
    }

    /**
     * Filter the query on the notify_products column
     *
     * Example usage:
     * <code>
     * $query->filterByNotifyProducts('fooValue');   // WHERE notify_products = 'fooValue'
     * $query->filterByNotifyProducts('%fooValue%', Criteria::LIKE); // WHERE notify_products LIKE '%fooValue%'
     * $query->filterByNotifyProducts(['foo', 'bar']); // WHERE notify_products IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $notifyProducts The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByNotifyProducts($notifyProducts = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($notifyProducts)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CustomerTableMap::COL_NOTIFY_PRODUCTS, $notifyProducts, $comparison);

        return $this;
    }

    /**
     * Filter the query by a related \Shop\Infrastructure\Models\CustomerGroup\CustomerGroup object
     *
     * @param \Shop\Infrastructure\Models\CustomerGroup\CustomerGroup|ObjectCollection $customerGroup The related object(s) to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByCustomerGroup($customerGroup, ?string $comparison = null)
    {
        if ($customerGroup instanceof \Shop\Infrastructure\Models\CustomerGroup\CustomerGroup) {
            return $this
                ->addUsingAlias(CustomerTableMap::COL_GROUP_ID, $customerGroup->getId(), $comparison);
        } elseif ($customerGroup instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            $this
                ->addUsingAlias(CustomerTableMap::COL_GROUP_ID, $customerGroup->toKeyValue('PrimaryKey', 'Id'), $comparison);

            return $this;
        } else {
            throw new PropelException('filterByCustomerGroup() only accepts arguments of type \Shop\Infrastructure\Models\CustomerGroup\CustomerGroup or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the CustomerGroup relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinCustomerGroup(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('CustomerGroup');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'CustomerGroup');
        }

        return $this;
    }

    /**
     * Use the CustomerGroup relation CustomerGroup object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\CustomerGroup\CustomerGroupQuery A secondary query class using the current class as primary query
     */
    public function useCustomerGroupQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinCustomerGroup($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'CustomerGroup', '\Shop\Infrastructure\Models\CustomerGroup\CustomerGroupQuery');
    }

    /**
     * Use the CustomerGroup relation CustomerGroup object
     *
     * @param callable(\Shop\Infrastructure\Models\CustomerGroup\CustomerGroupQuery):\Shop\Infrastructure\Models\CustomerGroup\CustomerGroupQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withCustomerGroupQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useCustomerGroupQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to CustomerGroup table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\CustomerGroup\CustomerGroupQuery The inner query object of the EXISTS statement
     */
    public function useCustomerGroupExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('CustomerGroup', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to CustomerGroup table for a NOT EXISTS query.
     *
     * @see useCustomerGroupExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\CustomerGroup\CustomerGroupQuery The inner query object of the NOT EXISTS statement
     */
    public function useCustomerGroupNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('CustomerGroup', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Shop\Infrastructure\Models\City\City object
     *
     * @param \Shop\Infrastructure\Models\City\City|ObjectCollection $city The related object(s) to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByCustomerCity($city, ?string $comparison = null)
    {
        if ($city instanceof \Shop\Infrastructure\Models\City\City) {
            return $this
                ->addUsingAlias(CustomerTableMap::COL_CITY_ID, $city->getId(), $comparison);
        } elseif ($city instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            $this
                ->addUsingAlias(CustomerTableMap::COL_CITY_ID, $city->toKeyValue('PrimaryKey', 'Id'), $comparison);

            return $this;
        } else {
            throw new PropelException('filterByCustomerCity() only accepts arguments of type \Shop\Infrastructure\Models\City\City or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the CustomerCity relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinCustomerCity(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('CustomerCity');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'CustomerCity');
        }

        return $this;
    }

    /**
     * Use the CustomerCity relation City object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\City\CityQuery A secondary query class using the current class as primary query
     */
    public function useCustomerCityQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinCustomerCity($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'CustomerCity', '\Shop\Infrastructure\Models\City\CityQuery');
    }

    /**
     * Use the CustomerCity relation City object
     *
     * @param callable(\Shop\Infrastructure\Models\City\CityQuery):\Shop\Infrastructure\Models\City\CityQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withCustomerCityQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useCustomerCityQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the CustomerCity relation to the City table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\City\CityQuery The inner query object of the EXISTS statement
     */
    public function useCustomerCityExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('CustomerCity', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the CustomerCity relation to the City table for a NOT EXISTS query.
     *
     * @see useCustomerCityExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\City\CityQuery The inner query object of the NOT EXISTS statement
     */
    public function useCustomerCityNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('CustomerCity', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Shop\Infrastructure\Models\Manager\Manager object
     *
     * @param \Shop\Infrastructure\Models\Manager\Manager|ObjectCollection $manager The related object(s) to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByManager($manager, ?string $comparison = null)
    {
        if ($manager instanceof \Shop\Infrastructure\Models\Manager\Manager) {
            return $this
                ->addUsingAlias(CustomerTableMap::COL_MANAGER_ID, $manager->getId(), $comparison);
        } elseif ($manager instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            $this
                ->addUsingAlias(CustomerTableMap::COL_MANAGER_ID, $manager->toKeyValue('PrimaryKey', 'Id'), $comparison);

            return $this;
        } else {
            throw new PropelException('filterByManager() only accepts arguments of type \Shop\Infrastructure\Models\Manager\Manager or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Manager relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinManager(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Manager');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Manager');
        }

        return $this;
    }

    /**
     * Use the Manager relation Manager object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\Manager\ManagerQuery A secondary query class using the current class as primary query
     */
    public function useManagerQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinManager($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Manager', '\Shop\Infrastructure\Models\Manager\ManagerQuery');
    }

    /**
     * Use the Manager relation Manager object
     *
     * @param callable(\Shop\Infrastructure\Models\Manager\ManagerQuery):\Shop\Infrastructure\Models\Manager\ManagerQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withManagerQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useManagerQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to Manager table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\Manager\ManagerQuery The inner query object of the EXISTS statement
     */
    public function useManagerExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('Manager', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to Manager table for a NOT EXISTS query.
     *
     * @see useManagerExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\Manager\ManagerQuery The inner query object of the NOT EXISTS statement
     */
    public function useManagerNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('Manager', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Shop\Infrastructure\Models\CustomerSocialLogin\CustomerSocialLogin object
     *
     * @param \Shop\Infrastructure\Models\CustomerSocialLogin\CustomerSocialLogin|ObjectCollection $customerSocialLogin the related object to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByCustomerSocialLogin($customerSocialLogin, ?string $comparison = null)
    {
        if ($customerSocialLogin instanceof \Shop\Infrastructure\Models\CustomerSocialLogin\CustomerSocialLogin) {
            $this
                ->addUsingAlias(CustomerTableMap::COL_ID, $customerSocialLogin->getcustomerId(), $comparison);

            return $this;
        } elseif ($customerSocialLogin instanceof ObjectCollection) {
            $this
                ->useCustomerSocialLoginQuery()
                ->filterByPrimaryKeys($customerSocialLogin->getPrimaryKeys())
                ->endUse();

            return $this;
        } else {
            throw new PropelException('filterByCustomerSocialLogin() only accepts arguments of type \Shop\Infrastructure\Models\CustomerSocialLogin\CustomerSocialLogin or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the CustomerSocialLogin relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinCustomerSocialLogin(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('CustomerSocialLogin');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'CustomerSocialLogin');
        }

        return $this;
    }

    /**
     * Use the CustomerSocialLogin relation CustomerSocialLogin object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\CustomerSocialLogin\CustomerSocialLoginQuery A secondary query class using the current class as primary query
     */
    public function useCustomerSocialLoginQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinCustomerSocialLogin($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'CustomerSocialLogin', '\Shop\Infrastructure\Models\CustomerSocialLogin\CustomerSocialLoginQuery');
    }

    /**
     * Use the CustomerSocialLogin relation CustomerSocialLogin object
     *
     * @param callable(\Shop\Infrastructure\Models\CustomerSocialLogin\CustomerSocialLoginQuery):\Shop\Infrastructure\Models\CustomerSocialLogin\CustomerSocialLoginQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withCustomerSocialLoginQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useCustomerSocialLoginQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to CustomerSocialLogin table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\CustomerSocialLogin\CustomerSocialLoginQuery The inner query object of the EXISTS statement
     */
    public function useCustomerSocialLoginExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('CustomerSocialLogin', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to CustomerSocialLogin table for a NOT EXISTS query.
     *
     * @see useCustomerSocialLoginExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\CustomerSocialLogin\CustomerSocialLoginQuery The inner query object of the NOT EXISTS statement
     */
    public function useCustomerSocialLoginNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('CustomerSocialLogin', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Shop\Infrastructure\Models\Basket\Basket object
     *
     * @param \Shop\Infrastructure\Models\Basket\Basket|ObjectCollection $basket the related object to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByBasket($basket, ?string $comparison = null)
    {
        if ($basket instanceof \Shop\Infrastructure\Models\Basket\Basket) {
            $this
                ->addUsingAlias(CustomerTableMap::COL_ID, $basket->getcustomerId(), $comparison);

            return $this;
        } elseif ($basket instanceof ObjectCollection) {
            $this
                ->useBasketQuery()
                ->filterByPrimaryKeys($basket->getPrimaryKeys())
                ->endUse();

            return $this;
        } else {
            throw new PropelException('filterByBasket() only accepts arguments of type \Shop\Infrastructure\Models\Basket\Basket or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Basket relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinBasket(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Basket');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Basket');
        }

        return $this;
    }

    /**
     * Use the Basket relation Basket object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\Basket\BasketQuery A secondary query class using the current class as primary query
     */
    public function useBasketQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinBasket($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Basket', '\Shop\Infrastructure\Models\Basket\BasketQuery');
    }

    /**
     * Use the Basket relation Basket object
     *
     * @param callable(\Shop\Infrastructure\Models\Basket\BasketQuery):\Shop\Infrastructure\Models\Basket\BasketQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withBasketQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useBasketQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to Basket table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\Basket\BasketQuery The inner query object of the EXISTS statement
     */
    public function useBasketExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('Basket', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to Basket table for a NOT EXISTS query.
     *
     * @see useBasketExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\Basket\BasketQuery The inner query object of the NOT EXISTS statement
     */
    public function useBasketNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('Basket', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Shop\Infrastructure\Models\Shop\Shop object
     *
     * @param \Shop\Infrastructure\Models\Shop\Shop|ObjectCollection $shop the related object to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByShop($shop, ?string $comparison = null)
    {
        if ($shop instanceof \Shop\Infrastructure\Models\Shop\Shop) {
            $this
                ->addUsingAlias(CustomerTableMap::COL_ID, $shop->getContractorId(), $comparison);

            return $this;
        } elseif ($shop instanceof ObjectCollection) {
            $this
                ->useShopQuery()
                ->filterByPrimaryKeys($shop->getPrimaryKeys())
                ->endUse();

            return $this;
        } else {
            throw new PropelException('filterByShop() only accepts arguments of type \Shop\Infrastructure\Models\Shop\Shop or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Shop relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinShop(?string $relationAlias = null, ?string $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Shop');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Shop');
        }

        return $this;
    }

    /**
     * Use the Shop relation Shop object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\Shop\ShopQuery A secondary query class using the current class as primary query
     */
    public function useShopQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinShop($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Shop', '\Shop\Infrastructure\Models\Shop\ShopQuery');
    }

    /**
     * Use the Shop relation Shop object
     *
     * @param callable(\Shop\Infrastructure\Models\Shop\ShopQuery):\Shop\Infrastructure\Models\Shop\ShopQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withShopQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::LEFT_JOIN
    ) {
        $relatedQuery = $this->useShopQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to Shop table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\Shop\ShopQuery The inner query object of the EXISTS statement
     */
    public function useShopExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('Shop', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to Shop table for a NOT EXISTS query.
     *
     * @see useShopExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\Shop\ShopQuery The inner query object of the NOT EXISTS statement
     */
    public function useShopNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('Shop', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Shop\Infrastructure\Models\Order\Order object
     *
     * @param \Shop\Infrastructure\Models\Order\Order|ObjectCollection $order the related object to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByOrderRelatedByCustomerId($order, ?string $comparison = null)
    {
        if ($order instanceof \Shop\Infrastructure\Models\Order\Order) {
            $this
                ->addUsingAlias(CustomerTableMap::COL_ID, $order->getCustomerId(), $comparison);

            return $this;
        } elseif ($order instanceof ObjectCollection) {
            $this
                ->useOrderRelatedByCustomerIdQuery()
                ->filterByPrimaryKeys($order->getPrimaryKeys())
                ->endUse();

            return $this;
        } else {
            throw new PropelException('filterByOrderRelatedByCustomerId() only accepts arguments of type \Shop\Infrastructure\Models\Order\Order or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the OrderRelatedByCustomerId relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinOrderRelatedByCustomerId(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('OrderRelatedByCustomerId');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'OrderRelatedByCustomerId');
        }

        return $this;
    }

    /**
     * Use the OrderRelatedByCustomerId relation Order object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\Order\OrderQuery A secondary query class using the current class as primary query
     */
    public function useOrderRelatedByCustomerIdQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinOrderRelatedByCustomerId($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'OrderRelatedByCustomerId', '\Shop\Infrastructure\Models\Order\OrderQuery');
    }

    /**
     * Use the OrderRelatedByCustomerId relation Order object
     *
     * @param callable(\Shop\Infrastructure\Models\Order\OrderQuery):\Shop\Infrastructure\Models\Order\OrderQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withOrderRelatedByCustomerIdQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useOrderRelatedByCustomerIdQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the OrderRelatedByCustomerId relation to the Order table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\Order\OrderQuery The inner query object of the EXISTS statement
     */
    public function useOrderRelatedByCustomerIdExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('OrderRelatedByCustomerId', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the OrderRelatedByCustomerId relation to the Order table for a NOT EXISTS query.
     *
     * @see useOrderRelatedByCustomerIdExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\Order\OrderQuery The inner query object of the NOT EXISTS statement
     */
    public function useOrderRelatedByCustomerIdNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('OrderRelatedByCustomerId', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Shop\Infrastructure\Models\Order\Order object
     *
     * @param \Shop\Infrastructure\Models\Order\Order|ObjectCollection $order the related object to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByOrderRelatedByContractorId($order, ?string $comparison = null)
    {
        if ($order instanceof \Shop\Infrastructure\Models\Order\Order) {
            $this
                ->addUsingAlias(CustomerTableMap::COL_ID, $order->getContractorId(), $comparison);

            return $this;
        } elseif ($order instanceof ObjectCollection) {
            $this
                ->useOrderRelatedByContractorIdQuery()
                ->filterByPrimaryKeys($order->getPrimaryKeys())
                ->endUse();

            return $this;
        } else {
            throw new PropelException('filterByOrderRelatedByContractorId() only accepts arguments of type \Shop\Infrastructure\Models\Order\Order or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the OrderRelatedByContractorId relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinOrderRelatedByContractorId(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('OrderRelatedByContractorId');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'OrderRelatedByContractorId');
        }

        return $this;
    }

    /**
     * Use the OrderRelatedByContractorId relation Order object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\Order\OrderQuery A secondary query class using the current class as primary query
     */
    public function useOrderRelatedByContractorIdQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinOrderRelatedByContractorId($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'OrderRelatedByContractorId', '\Shop\Infrastructure\Models\Order\OrderQuery');
    }

    /**
     * Use the OrderRelatedByContractorId relation Order object
     *
     * @param callable(\Shop\Infrastructure\Models\Order\OrderQuery):\Shop\Infrastructure\Models\Order\OrderQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withOrderRelatedByContractorIdQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useOrderRelatedByContractorIdQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the OrderRelatedByContractorId relation to the Order table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\Order\OrderQuery The inner query object of the EXISTS statement
     */
    public function useOrderRelatedByContractorIdExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('OrderRelatedByContractorId', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the OrderRelatedByContractorId relation to the Order table for a NOT EXISTS query.
     *
     * @see useOrderRelatedByContractorIdExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\Order\OrderQuery The inner query object of the NOT EXISTS statement
     */
    public function useOrderRelatedByContractorIdNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('OrderRelatedByContractorId', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Shop\Infrastructure\Models\FastLink\FastLink object
     *
     * @param \Shop\Infrastructure\Models\FastLink\FastLink|ObjectCollection $fastLink the related object to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByFastLinkRelatedByOwnerCustomerId($fastLink, ?string $comparison = null)
    {
        if ($fastLink instanceof \Shop\Infrastructure\Models\FastLink\FastLink) {
            $this
                ->addUsingAlias(CustomerTableMap::COL_ID, $fastLink->getOwnerCustomerId(), $comparison);

            return $this;
        } elseif ($fastLink instanceof ObjectCollection) {
            $this
                ->useFastLinkRelatedByOwnerCustomerIdQuery()
                ->filterByPrimaryKeys($fastLink->getPrimaryKeys())
                ->endUse();

            return $this;
        } else {
            throw new PropelException('filterByFastLinkRelatedByOwnerCustomerId() only accepts arguments of type \Shop\Infrastructure\Models\FastLink\FastLink or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the FastLinkRelatedByOwnerCustomerId relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinFastLinkRelatedByOwnerCustomerId(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('FastLinkRelatedByOwnerCustomerId');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'FastLinkRelatedByOwnerCustomerId');
        }

        return $this;
    }

    /**
     * Use the FastLinkRelatedByOwnerCustomerId relation FastLink object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\FastLink\FastLinkQuery A secondary query class using the current class as primary query
     */
    public function useFastLinkRelatedByOwnerCustomerIdQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinFastLinkRelatedByOwnerCustomerId($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'FastLinkRelatedByOwnerCustomerId', '\Shop\Infrastructure\Models\FastLink\FastLinkQuery');
    }

    /**
     * Use the FastLinkRelatedByOwnerCustomerId relation FastLink object
     *
     * @param callable(\Shop\Infrastructure\Models\FastLink\FastLinkQuery):\Shop\Infrastructure\Models\FastLink\FastLinkQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withFastLinkRelatedByOwnerCustomerIdQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useFastLinkRelatedByOwnerCustomerIdQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the FastLinkRelatedByOwnerCustomerId relation to the FastLink table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\FastLink\FastLinkQuery The inner query object of the EXISTS statement
     */
    public function useFastLinkRelatedByOwnerCustomerIdExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('FastLinkRelatedByOwnerCustomerId', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the FastLinkRelatedByOwnerCustomerId relation to the FastLink table for a NOT EXISTS query.
     *
     * @see useFastLinkRelatedByOwnerCustomerIdExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\FastLink\FastLinkQuery The inner query object of the NOT EXISTS statement
     */
    public function useFastLinkRelatedByOwnerCustomerIdNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('FastLinkRelatedByOwnerCustomerId', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Shop\Infrastructure\Models\FastLink\FastLink object
     *
     * @param \Shop\Infrastructure\Models\FastLink\FastLink|ObjectCollection $fastLink the related object to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByFastLinkRelatedByCode($fastLink, ?string $comparison = null)
    {
        if ($fastLink instanceof \Shop\Infrastructure\Models\FastLink\FastLink) {
            $this
                ->addUsingAlias(CustomerTableMap::COL_PASSWORD, $fastLink->getCode(), $comparison);

            return $this;
        } elseif ($fastLink instanceof ObjectCollection) {
            $this
                ->useFastLinkRelatedByCodeQuery()
                ->filterByPrimaryKeys($fastLink->getPrimaryKeys())
                ->endUse();

            return $this;
        } else {
            throw new PropelException('filterByFastLinkRelatedByCode() only accepts arguments of type \Shop\Infrastructure\Models\FastLink\FastLink or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the FastLinkRelatedByCode relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinFastLinkRelatedByCode(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('FastLinkRelatedByCode');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'FastLinkRelatedByCode');
        }

        return $this;
    }

    /**
     * Use the FastLinkRelatedByCode relation FastLink object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\FastLink\FastLinkQuery A secondary query class using the current class as primary query
     */
    public function useFastLinkRelatedByCodeQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinFastLinkRelatedByCode($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'FastLinkRelatedByCode', '\Shop\Infrastructure\Models\FastLink\FastLinkQuery');
    }

    /**
     * Use the FastLinkRelatedByCode relation FastLink object
     *
     * @param callable(\Shop\Infrastructure\Models\FastLink\FastLinkQuery):\Shop\Infrastructure\Models\FastLink\FastLinkQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withFastLinkRelatedByCodeQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useFastLinkRelatedByCodeQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the FastLinkRelatedByCode relation to the FastLink table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\FastLink\FastLinkQuery The inner query object of the EXISTS statement
     */
    public function useFastLinkRelatedByCodeExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('FastLinkRelatedByCode', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the FastLinkRelatedByCode relation to the FastLink table for a NOT EXISTS query.
     *
     * @see useFastLinkRelatedByCodeExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\FastLink\FastLinkQuery The inner query object of the NOT EXISTS statement
     */
    public function useFastLinkRelatedByCodeNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('FastLinkRelatedByCode', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Shop\Infrastructure\Models\Provider\Provider object
     *
     * @param \Shop\Infrastructure\Models\Provider\Provider|ObjectCollection $provider the related object to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByProvider($provider, ?string $comparison = null)
    {
        if ($provider instanceof \Shop\Infrastructure\Models\Provider\Provider) {
            $this
                ->addUsingAlias(CustomerTableMap::COL_ID, $provider->getContractorId(), $comparison);

            return $this;
        } elseif ($provider instanceof ObjectCollection) {
            $this
                ->useProviderQuery()
                ->filterByPrimaryKeys($provider->getPrimaryKeys())
                ->endUse();

            return $this;
        } else {
            throw new PropelException('filterByProvider() only accepts arguments of type \Shop\Infrastructure\Models\Provider\Provider or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Provider relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinProvider(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Provider');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Provider');
        }

        return $this;
    }

    /**
     * Use the Provider relation Provider object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\Provider\ProviderQuery A secondary query class using the current class as primary query
     */
    public function useProviderQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProvider($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Provider', '\Shop\Infrastructure\Models\Provider\ProviderQuery');
    }

    /**
     * Use the Provider relation Provider object
     *
     * @param callable(\Shop\Infrastructure\Models\Provider\ProviderQuery):\Shop\Infrastructure\Models\Provider\ProviderQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withProviderQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useProviderQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to Provider table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\Provider\ProviderQuery The inner query object of the EXISTS statement
     */
    public function useProviderExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('Provider', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to Provider table for a NOT EXISTS query.
     *
     * @see useProviderExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\Provider\ProviderQuery The inner query object of the NOT EXISTS statement
     */
    public function useProviderNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('Provider', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Shop\Infrastructure\Models\Score\Score object
     *
     * @param \Shop\Infrastructure\Models\Score\Score|ObjectCollection $score the related object to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByScore($score, ?string $comparison = null)
    {
        if ($score instanceof \Shop\Infrastructure\Models\Score\Score) {
            $this
                ->addUsingAlias(CustomerTableMap::COL_ID, $score->getcustomerId(), $comparison);

            return $this;
        } elseif ($score instanceof ObjectCollection) {
            $this
                ->useScoreQuery()
                ->filterByPrimaryKeys($score->getPrimaryKeys())
                ->endUse();

            return $this;
        } else {
            throw new PropelException('filterByScore() only accepts arguments of type \Shop\Infrastructure\Models\Score\Score or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Score relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinScore(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Score');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Score');
        }

        return $this;
    }

    /**
     * Use the Score relation Score object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\Score\ScoreQuery A secondary query class using the current class as primary query
     */
    public function useScoreQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinScore($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Score', '\Shop\Infrastructure\Models\Score\ScoreQuery');
    }

    /**
     * Use the Score relation Score object
     *
     * @param callable(\Shop\Infrastructure\Models\Score\ScoreQuery):\Shop\Infrastructure\Models\Score\ScoreQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withScoreQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useScoreQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to Score table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\Score\ScoreQuery The inner query object of the EXISTS statement
     */
    public function useScoreExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('Score', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to Score table for a NOT EXISTS query.
     *
     * @see useScoreExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\Score\ScoreQuery The inner query object of the NOT EXISTS statement
     */
    public function useScoreNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('Score', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Shop\Infrastructure\Models\DraftProduct\DraftProduct object
     *
     * @param \Shop\Infrastructure\Models\DraftProduct\DraftProduct|ObjectCollection $draftProduct the related object to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByDraftProduct($draftProduct, ?string $comparison = null)
    {
        if ($draftProduct instanceof \Shop\Infrastructure\Models\DraftProduct\DraftProduct) {
            $this
                ->addUsingAlias(CustomerTableMap::COL_ID, $draftProduct->getCustomerId(), $comparison);

            return $this;
        } elseif ($draftProduct instanceof ObjectCollection) {
            $this
                ->useDraftProductQuery()
                ->filterByPrimaryKeys($draftProduct->getPrimaryKeys())
                ->endUse();

            return $this;
        } else {
            throw new PropelException('filterByDraftProduct() only accepts arguments of type \Shop\Infrastructure\Models\DraftProduct\DraftProduct or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the DraftProduct relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinDraftProduct(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('DraftProduct');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'DraftProduct');
        }

        return $this;
    }

    /**
     * Use the DraftProduct relation DraftProduct object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\DraftProduct\DraftProductQuery A secondary query class using the current class as primary query
     */
    public function useDraftProductQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinDraftProduct($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'DraftProduct', '\Shop\Infrastructure\Models\DraftProduct\DraftProductQuery');
    }

    /**
     * Use the DraftProduct relation DraftProduct object
     *
     * @param callable(\Shop\Infrastructure\Models\DraftProduct\DraftProductQuery):\Shop\Infrastructure\Models\DraftProduct\DraftProductQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withDraftProductQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useDraftProductQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to DraftProduct table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\DraftProduct\DraftProductQuery The inner query object of the EXISTS statement
     */
    public function useDraftProductExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('DraftProduct', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to DraftProduct table for a NOT EXISTS query.
     *
     * @see useDraftProductExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\DraftProduct\DraftProductQuery The inner query object of the NOT EXISTS statement
     */
    public function useDraftProductNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('DraftProduct', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Exclude object from result
     *
     * @param ChildCustomer $customer Object to remove from the list of results
     *
     * @return $this The current query, for fluid interface
     */
    public function prune($customer = null)
    {
        if ($customer) {
            $this->addUsingAlias(CustomerTableMap::COL_ID, $customer->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the shop_customer table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(CustomerTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            CustomerTableMap::clearInstancePool();
            CustomerTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(CustomerTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(CustomerTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            CustomerTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            CustomerTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

}
