<?php

namespace Shop\Domain\Product;

use Core\Repository\DropDownInterface;
use Repo\Concrete\AbstractCollection;
use Shop\Domain\Product\Contracts\ProductEntityInterface;
use Shop\Infrastructure\Models\Product\Product;

/**
 * Description of Product
 *
 * @author Diamond Code Generator
 */
class ProductCollection extends AbstractCollection implements DropDownInterface
{

    /**
     * @return string
     */
    protected function getEntityClass(): string
    {
        return ProductEntityInterface::class;
    }

    public function getDropdownList(): array
    {
        $ar = [];
        foreach ($this->_entities as $entity) {
            $ar[$entity->getId()] = $entity->getTitle();
        }

        return $ar;
    }

    /**
     * @return array
     */
    public function getDropdownListFull(): array
    {
        $ar = [];
        /**
         * @var Product $entity
         */
        foreach ($this->_entities as $entity) {
            $ar[$entity->getId()] = sprintf(
                '[' . $entity->getId() . '] %s, изображение: %s',
                $entity->getTitleWithArticleBrand(),
                $entity->getImg() > '' ? 'есть' : '-'
            );
        }

        return $ar;
    }
}               