<?php


namespace Shop\Infrastructure\Repositories\FastLink;


use Repo\Concrete\AbstractCriteria;
use Shop\Domain\FastLink\Contracts\FastLinkCriteriaInterface;

class FastLinkCriteria extends AbstractCriteria implements FastLinkCriteriaInterface
{
    public static function create()
    {
        return new self;
    }

    /**
     * @var null|string
     */
    protected $sortBydatetime;

    /**
     * @return string|null
     */
    public function getSortBydatetime(): ?string
    {
        return $this->sortBydatetime;
    }

    /**
     * @param string|null $sortBydatetime
     * @return FastLinkCriteria
     */
    public function setSortBydatetime(?string $sortBydatetime): FastLinkCriteria
    {
        $this->sortBydatetime = $sortBydatetime;
        return $this;
    }



}