<?php

namespace Shop\Infrastructure\Models\Provider\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Infrastructure\Models\Currency\Currency;
use Shop\Infrastructure\Models\Customer\Customer;
use Shop\Infrastructure\Models\OrderItem\OrderItem;
use Shop\Infrastructure\Models\PricelistFile\PricelistFile;
use Shop\Infrastructure\Models\Provider\Provider as ChildProvider;
use Shop\Infrastructure\Models\Provider\ProviderQuery as ChildProviderQuery;
use Shop\Infrastructure\Models\Provider\ShopProvidersArchive as ChildShopProvidersArchive;
use Shop\Infrastructure\Models\Provider\Map\ProviderTableMap;

/**
 * Base class that represents a query for the 'shop_providers' table.
 *
 *
 *
 * @method     ChildProviderQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildProviderQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method     ChildProviderQuery orderByTerm($order = Criteria::ASC) Order by the term column
 * @method     ChildProviderQuery orderByDesc($order = Criteria::ASC) Order by the desc column
 * @method     ChildProviderQuery orderByContact($order = Criteria::ASC) Order by the contact column
 * @method     ChildProviderQuery orderByDestination($order = Criteria::ASC) Order by the destination column
 * @method     ChildProviderQuery orderByColor($order = Criteria::ASC) Order by the color column
 * @method     ChildProviderQuery orderByShopId($order = Criteria::ASC) Order by the shop_id column
 * @method     ChildProviderQuery orderByCurrencyId($order = Criteria::ASC) Order by the crrency_id column
 * @method     ChildProviderQuery orderByContractorId($order = Criteria::ASC) Order by the contractor_id column
 *
 * @method     ChildProviderQuery groupById() Group by the id column
 * @method     ChildProviderQuery groupByName() Group by the name column
 * @method     ChildProviderQuery groupByTerm() Group by the term column
 * @method     ChildProviderQuery groupByDesc() Group by the desc column
 * @method     ChildProviderQuery groupByContact() Group by the contact column
 * @method     ChildProviderQuery groupByDestination() Group by the destination column
 * @method     ChildProviderQuery groupByColor() Group by the color column
 * @method     ChildProviderQuery groupByShopId() Group by the shop_id column
 * @method     ChildProviderQuery groupByCurrencyId() Group by the crrency_id column
 * @method     ChildProviderQuery groupByContractorId() Group by the contractor_id column
 *
 * @method     ChildProviderQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildProviderQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildProviderQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildProviderQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildProviderQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildProviderQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildProviderQuery leftJoinCurrency($relationAlias = null) Adds a LEFT JOIN clause to the query using the Currency relation
 * @method     ChildProviderQuery rightJoinCurrency($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Currency relation
 * @method     ChildProviderQuery innerJoinCurrency($relationAlias = null) Adds a INNER JOIN clause to the query using the Currency relation
 *
 * @method     ChildProviderQuery joinWithCurrency($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Currency relation
 *
 * @method     ChildProviderQuery leftJoinWithCurrency() Adds a LEFT JOIN clause and with to the query using the Currency relation
 * @method     ChildProviderQuery rightJoinWithCurrency() Adds a RIGHT JOIN clause and with to the query using the Currency relation
 * @method     ChildProviderQuery innerJoinWithCurrency() Adds a INNER JOIN clause and with to the query using the Currency relation
 *
 * @method     ChildProviderQuery leftJoinContractor($relationAlias = null) Adds a LEFT JOIN clause to the query using the Contractor relation
 * @method     ChildProviderQuery rightJoinContractor($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Contractor relation
 * @method     ChildProviderQuery innerJoinContractor($relationAlias = null) Adds a INNER JOIN clause to the query using the Contractor relation
 *
 * @method     ChildProviderQuery joinWithContractor($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Contractor relation
 *
 * @method     ChildProviderQuery leftJoinWithContractor() Adds a LEFT JOIN clause and with to the query using the Contractor relation
 * @method     ChildProviderQuery rightJoinWithContractor() Adds a RIGHT JOIN clause and with to the query using the Contractor relation
 * @method     ChildProviderQuery innerJoinWithContractor() Adds a INNER JOIN clause and with to the query using the Contractor relation
 *
 * @method     ChildProviderQuery leftJoinOrderItem($relationAlias = null) Adds a LEFT JOIN clause to the query using the OrderItem relation
 * @method     ChildProviderQuery rightJoinOrderItem($relationAlias = null) Adds a RIGHT JOIN clause to the query using the OrderItem relation
 * @method     ChildProviderQuery innerJoinOrderItem($relationAlias = null) Adds a INNER JOIN clause to the query using the OrderItem relation
 *
 * @method     ChildProviderQuery joinWithOrderItem($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the OrderItem relation
 *
 * @method     ChildProviderQuery leftJoinWithOrderItem() Adds a LEFT JOIN clause and with to the query using the OrderItem relation
 * @method     ChildProviderQuery rightJoinWithOrderItem() Adds a RIGHT JOIN clause and with to the query using the OrderItem relation
 * @method     ChildProviderQuery innerJoinWithOrderItem() Adds a INNER JOIN clause and with to the query using the OrderItem relation
 *
 * @method     ChildProviderQuery leftJoinPricelistFile($relationAlias = null) Adds a LEFT JOIN clause to the query using the PricelistFile relation
 * @method     ChildProviderQuery rightJoinPricelistFile($relationAlias = null) Adds a RIGHT JOIN clause to the query using the PricelistFile relation
 * @method     ChildProviderQuery innerJoinPricelistFile($relationAlias = null) Adds a INNER JOIN clause to the query using the PricelistFile relation
 *
 * @method     ChildProviderQuery joinWithPricelistFile($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the PricelistFile relation
 *
 * @method     ChildProviderQuery leftJoinWithPricelistFile() Adds a LEFT JOIN clause and with to the query using the PricelistFile relation
 * @method     ChildProviderQuery rightJoinWithPricelistFile() Adds a RIGHT JOIN clause and with to the query using the PricelistFile relation
 * @method     ChildProviderQuery innerJoinWithPricelistFile() Adds a INNER JOIN clause and with to the query using the PricelistFile relation
 *
 * @method     \Shop\Infrastructure\Models\Currency\CurrencyQuery|\Shop\Infrastructure\Models\Customer\CustomerQuery|\Shop\Infrastructure\Models\OrderItem\OrderItemQuery|\Shop\Infrastructure\Models\PricelistFile\PricelistFileQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildProvider|null findOne(?ConnectionInterface $con = null) Return the first ChildProvider matching the query
 * @method     ChildProvider findOneOrCreate(?ConnectionInterface $con = null) Return the first ChildProvider matching the query, or a new ChildProvider object populated from the query conditions when no match is found
 *
 * @method     ChildProvider|null findOneById(int $id) Return the first ChildProvider filtered by the id column
 * @method     ChildProvider|null findOneByName(string $name) Return the first ChildProvider filtered by the name column
 * @method     ChildProvider|null findOneByTerm(int $term) Return the first ChildProvider filtered by the term column
 * @method     ChildProvider|null findOneByDesc(string $desc) Return the first ChildProvider filtered by the desc column
 * @method     ChildProvider|null findOneByContact(string $contact) Return the first ChildProvider filtered by the contact column
 * @method     ChildProvider|null findOneByDestination(string $destination) Return the first ChildProvider filtered by the destination column
 * @method     ChildProvider|null findOneByColor(string $color) Return the first ChildProvider filtered by the color column
 * @method     ChildProvider|null findOneByShopId(int $shop_id) Return the first ChildProvider filtered by the shop_id column
 * @method     ChildProvider|null findOneByCurrencyId(int $crrency_id) Return the first ChildProvider filtered by the crrency_id column
 * @method     ChildProvider|null findOneByContractorId(int $contractor_id) Return the first ChildProvider filtered by the contractor_id column *

 * @method     ChildProvider requirePk($key, ?ConnectionInterface $con = null) Return the ChildProvider by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProvider requireOne(?ConnectionInterface $con = null) Return the first ChildProvider matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildProvider requireOneById(int $id) Return the first ChildProvider filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProvider requireOneByName(string $name) Return the first ChildProvider filtered by the name column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProvider requireOneByTerm(int $term) Return the first ChildProvider filtered by the term column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProvider requireOneByDesc(string $desc) Return the first ChildProvider filtered by the desc column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProvider requireOneByContact(string $contact) Return the first ChildProvider filtered by the contact column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProvider requireOneByDestination(string $destination) Return the first ChildProvider filtered by the destination column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProvider requireOneByColor(string $color) Return the first ChildProvider filtered by the color column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProvider requireOneByShopId(int $shop_id) Return the first ChildProvider filtered by the shop_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProvider requireOneByCurrencyId(int $crrency_id) Return the first ChildProvider filtered by the crrency_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProvider requireOneByContractorId(int $contractor_id) Return the first ChildProvider filtered by the contractor_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildProvider[]|Collection find(?ConnectionInterface $con = null) Return ChildProvider objects based on current ModelCriteria
 * @psalm-method Collection&\Traversable<ChildProvider> find(?ConnectionInterface $con = null) Return ChildProvider objects based on current ModelCriteria
 * @method     ChildProvider[]|Collection findById(int $id) Return ChildProvider objects filtered by the id column
 * @psalm-method Collection&\Traversable<ChildProvider> findById(int $id) Return ChildProvider objects filtered by the id column
 * @method     ChildProvider[]|Collection findByName(string $name) Return ChildProvider objects filtered by the name column
 * @psalm-method Collection&\Traversable<ChildProvider> findByName(string $name) Return ChildProvider objects filtered by the name column
 * @method     ChildProvider[]|Collection findByTerm(int $term) Return ChildProvider objects filtered by the term column
 * @psalm-method Collection&\Traversable<ChildProvider> findByTerm(int $term) Return ChildProvider objects filtered by the term column
 * @method     ChildProvider[]|Collection findByDesc(string $desc) Return ChildProvider objects filtered by the desc column
 * @psalm-method Collection&\Traversable<ChildProvider> findByDesc(string $desc) Return ChildProvider objects filtered by the desc column
 * @method     ChildProvider[]|Collection findByContact(string $contact) Return ChildProvider objects filtered by the contact column
 * @psalm-method Collection&\Traversable<ChildProvider> findByContact(string $contact) Return ChildProvider objects filtered by the contact column
 * @method     ChildProvider[]|Collection findByDestination(string $destination) Return ChildProvider objects filtered by the destination column
 * @psalm-method Collection&\Traversable<ChildProvider> findByDestination(string $destination) Return ChildProvider objects filtered by the destination column
 * @method     ChildProvider[]|Collection findByColor(string $color) Return ChildProvider objects filtered by the color column
 * @psalm-method Collection&\Traversable<ChildProvider> findByColor(string $color) Return ChildProvider objects filtered by the color column
 * @method     ChildProvider[]|Collection findByShopId(int $shop_id) Return ChildProvider objects filtered by the shop_id column
 * @psalm-method Collection&\Traversable<ChildProvider> findByShopId(int $shop_id) Return ChildProvider objects filtered by the shop_id column
 * @method     ChildProvider[]|Collection findByCurrencyId(int $crrency_id) Return ChildProvider objects filtered by the crrency_id column
 * @psalm-method Collection&\Traversable<ChildProvider> findByCurrencyId(int $crrency_id) Return ChildProvider objects filtered by the crrency_id column
 * @method     ChildProvider[]|Collection findByContractorId(int $contractor_id) Return ChildProvider objects filtered by the contractor_id column
 * @psalm-method Collection&\Traversable<ChildProvider> findByContractorId(int $contractor_id) Return ChildProvider objects filtered by the contractor_id column
 * @method     ChildProvider[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 * @psalm-method \Propel\Runtime\Util\PropelModelPager&\Traversable<ChildProvider> paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class ProviderQuery extends ModelCriteria
{

    // archivable behavior
    protected $archiveOnDelete = true;
protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Infrastructure\Models\Provider\Base\ProviderQuery object.
     *
     * @param string $dbName The database name
     * @param string $modelName The phpName of a model, e.g. 'Book'
     * @param string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Infrastructure\\Models\\Provider\\Provider', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildProviderQuery object.
     *
     * @param string $modelAlias The alias of a model in the query
     * @param Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildProviderQuery
     */
    public static function create(?string $modelAlias = null, ?Criteria $criteria = null): Criteria
    {
        if ($criteria instanceof ChildProviderQuery) {
            return $criteria;
        }
        $query = new ChildProviderQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildProvider|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ?ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(ProviderTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = ProviderTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildProvider A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `name`, `term`, `desc`, `contact`, `destination`, `color`, `shop_id`, `crrency_id`, `contractor_id` FROM `shop_providers` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildProvider $obj */
            $obj = new ChildProvider();
            $obj->hydrate($row);
            ProviderTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @return ChildProvider|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param array $keys Primary keys to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return Collection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param mixed $key Primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        $this->addUsingAlias(ProviderTableMap::COL_ID, $key, Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param array|int $keys The list of primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        $this->addUsingAlias(ProviderTableMap::COL_ID, $keys, Criteria::IN);

        return $this;
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterById($id = null, ?string $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(ProviderTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(ProviderTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ProviderTableMap::COL_ID, $id, $comparison);

        return $this;
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%', Criteria::LIKE); // WHERE name LIKE '%fooValue%'
     * $query->filterByName(['foo', 'bar']); // WHERE name IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $name The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByName($name = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ProviderTableMap::COL_NAME, $name, $comparison);

        return $this;
    }

    /**
     * Filter the query on the term column
     *
     * Example usage:
     * <code>
     * $query->filterByTerm(1234); // WHERE term = 1234
     * $query->filterByTerm(array(12, 34)); // WHERE term IN (12, 34)
     * $query->filterByTerm(array('min' => 12)); // WHERE term > 12
     * </code>
     *
     * @param mixed $term The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByTerm($term = null, ?string $comparison = null)
    {
        if (is_array($term)) {
            $useMinMax = false;
            if (isset($term['min'])) {
                $this->addUsingAlias(ProviderTableMap::COL_TERM, $term['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($term['max'])) {
                $this->addUsingAlias(ProviderTableMap::COL_TERM, $term['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ProviderTableMap::COL_TERM, $term, $comparison);

        return $this;
    }

    /**
     * Filter the query on the desc column
     *
     * Example usage:
     * <code>
     * $query->filterByDesc('fooValue');   // WHERE desc = 'fooValue'
     * $query->filterByDesc('%fooValue%', Criteria::LIKE); // WHERE desc LIKE '%fooValue%'
     * $query->filterByDesc(['foo', 'bar']); // WHERE desc IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $desc The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByDesc($desc = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($desc)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ProviderTableMap::COL_DESC, $desc, $comparison);

        return $this;
    }

    /**
     * Filter the query on the contact column
     *
     * Example usage:
     * <code>
     * $query->filterByContact('fooValue');   // WHERE contact = 'fooValue'
     * $query->filterByContact('%fooValue%', Criteria::LIKE); // WHERE contact LIKE '%fooValue%'
     * $query->filterByContact(['foo', 'bar']); // WHERE contact IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $contact The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByContact($contact = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($contact)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ProviderTableMap::COL_CONTACT, $contact, $comparison);

        return $this;
    }

    /**
     * Filter the query on the destination column
     *
     * Example usage:
     * <code>
     * $query->filterByDestination('fooValue');   // WHERE destination = 'fooValue'
     * $query->filterByDestination('%fooValue%', Criteria::LIKE); // WHERE destination LIKE '%fooValue%'
     * $query->filterByDestination(['foo', 'bar']); // WHERE destination IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $destination The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByDestination($destination = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($destination)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ProviderTableMap::COL_DESTINATION, $destination, $comparison);

        return $this;
    }

    /**
     * Filter the query on the color column
     *
     * Example usage:
     * <code>
     * $query->filterByColor('fooValue');   // WHERE color = 'fooValue'
     * $query->filterByColor('%fooValue%', Criteria::LIKE); // WHERE color LIKE '%fooValue%'
     * $query->filterByColor(['foo', 'bar']); // WHERE color IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $color The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByColor($color = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($color)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ProviderTableMap::COL_COLOR, $color, $comparison);

        return $this;
    }

    /**
     * Filter the query on the shop_id column
     *
     * Example usage:
     * <code>
     * $query->filterByShopId(1234); // WHERE shop_id = 1234
     * $query->filterByShopId(array(12, 34)); // WHERE shop_id IN (12, 34)
     * $query->filterByShopId(array('min' => 12)); // WHERE shop_id > 12
     * </code>
     *
     * @param mixed $shopId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByShopId($shopId = null, ?string $comparison = null)
    {
        if (is_array($shopId)) {
            $useMinMax = false;
            if (isset($shopId['min'])) {
                $this->addUsingAlias(ProviderTableMap::COL_SHOP_ID, $shopId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($shopId['max'])) {
                $this->addUsingAlias(ProviderTableMap::COL_SHOP_ID, $shopId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ProviderTableMap::COL_SHOP_ID, $shopId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the crrency_id column
     *
     * Example usage:
     * <code>
     * $query->filterByCurrencyId(1234); // WHERE crrency_id = 1234
     * $query->filterByCurrencyId(array(12, 34)); // WHERE crrency_id IN (12, 34)
     * $query->filterByCurrencyId(array('min' => 12)); // WHERE crrency_id > 12
     * </code>
     *
     * @see       filterByCurrency()
     *
     * @param mixed $currencyId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByCurrencyId($currencyId = null, ?string $comparison = null)
    {
        if (is_array($currencyId)) {
            $useMinMax = false;
            if (isset($currencyId['min'])) {
                $this->addUsingAlias(ProviderTableMap::COL_CRRENCY_ID, $currencyId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($currencyId['max'])) {
                $this->addUsingAlias(ProviderTableMap::COL_CRRENCY_ID, $currencyId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ProviderTableMap::COL_CRRENCY_ID, $currencyId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the contractor_id column
     *
     * Example usage:
     * <code>
     * $query->filterByContractorId(1234); // WHERE contractor_id = 1234
     * $query->filterByContractorId(array(12, 34)); // WHERE contractor_id IN (12, 34)
     * $query->filterByContractorId(array('min' => 12)); // WHERE contractor_id > 12
     * </code>
     *
     * @see       filterByContractor()
     *
     * @param mixed $contractorId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByContractorId($contractorId = null, ?string $comparison = null)
    {
        if (is_array($contractorId)) {
            $useMinMax = false;
            if (isset($contractorId['min'])) {
                $this->addUsingAlias(ProviderTableMap::COL_CONTRACTOR_ID, $contractorId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($contractorId['max'])) {
                $this->addUsingAlias(ProviderTableMap::COL_CONTRACTOR_ID, $contractorId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ProviderTableMap::COL_CONTRACTOR_ID, $contractorId, $comparison);

        return $this;
    }

    /**
     * Filter the query by a related \Shop\Infrastructure\Models\Currency\Currency object
     *
     * @param \Shop\Infrastructure\Models\Currency\Currency|ObjectCollection $currency The related object(s) to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByCurrency($currency, ?string $comparison = null)
    {
        if ($currency instanceof \Shop\Infrastructure\Models\Currency\Currency) {
            return $this
                ->addUsingAlias(ProviderTableMap::COL_CRRENCY_ID, $currency->getId(), $comparison);
        } elseif ($currency instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            $this
                ->addUsingAlias(ProviderTableMap::COL_CRRENCY_ID, $currency->toKeyValue('PrimaryKey', 'Id'), $comparison);

            return $this;
        } else {
            throw new PropelException('filterByCurrency() only accepts arguments of type \Shop\Infrastructure\Models\Currency\Currency or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Currency relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinCurrency(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Currency');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Currency');
        }

        return $this;
    }

    /**
     * Use the Currency relation Currency object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\Currency\CurrencyQuery A secondary query class using the current class as primary query
     */
    public function useCurrencyQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinCurrency($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Currency', '\Shop\Infrastructure\Models\Currency\CurrencyQuery');
    }

    /**
     * Use the Currency relation Currency object
     *
     * @param callable(\Shop\Infrastructure\Models\Currency\CurrencyQuery):\Shop\Infrastructure\Models\Currency\CurrencyQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withCurrencyQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useCurrencyQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to Currency table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\Currency\CurrencyQuery The inner query object of the EXISTS statement
     */
    public function useCurrencyExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('Currency', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to Currency table for a NOT EXISTS query.
     *
     * @see useCurrencyExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\Currency\CurrencyQuery The inner query object of the NOT EXISTS statement
     */
    public function useCurrencyNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('Currency', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Shop\Infrastructure\Models\Customer\Customer object
     *
     * @param \Shop\Infrastructure\Models\Customer\Customer|ObjectCollection $customer The related object(s) to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByContractor($customer, ?string $comparison = null)
    {
        if ($customer instanceof \Shop\Infrastructure\Models\Customer\Customer) {
            return $this
                ->addUsingAlias(ProviderTableMap::COL_CONTRACTOR_ID, $customer->getId(), $comparison);
        } elseif ($customer instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            $this
                ->addUsingAlias(ProviderTableMap::COL_CONTRACTOR_ID, $customer->toKeyValue('PrimaryKey', 'Id'), $comparison);

            return $this;
        } else {
            throw new PropelException('filterByContractor() only accepts arguments of type \Shop\Infrastructure\Models\Customer\Customer or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Contractor relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinContractor(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Contractor');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Contractor');
        }

        return $this;
    }

    /**
     * Use the Contractor relation Customer object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\Customer\CustomerQuery A secondary query class using the current class as primary query
     */
    public function useContractorQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinContractor($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Contractor', '\Shop\Infrastructure\Models\Customer\CustomerQuery');
    }

    /**
     * Use the Contractor relation Customer object
     *
     * @param callable(\Shop\Infrastructure\Models\Customer\CustomerQuery):\Shop\Infrastructure\Models\Customer\CustomerQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withContractorQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useContractorQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the Contractor relation to the Customer table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\Customer\CustomerQuery The inner query object of the EXISTS statement
     */
    public function useContractorExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('Contractor', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the Contractor relation to the Customer table for a NOT EXISTS query.
     *
     * @see useContractorExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\Customer\CustomerQuery The inner query object of the NOT EXISTS statement
     */
    public function useContractorNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('Contractor', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Shop\Infrastructure\Models\OrderItem\OrderItem object
     *
     * @param \Shop\Infrastructure\Models\OrderItem\OrderItem|ObjectCollection $orderItem the related object to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByOrderItem($orderItem, ?string $comparison = null)
    {
        if ($orderItem instanceof \Shop\Infrastructure\Models\OrderItem\OrderItem) {
            $this
                ->addUsingAlias(ProviderTableMap::COL_ID, $orderItem->getProviderId(), $comparison);

            return $this;
        } elseif ($orderItem instanceof ObjectCollection) {
            $this
                ->useOrderItemQuery()
                ->filterByPrimaryKeys($orderItem->getPrimaryKeys())
                ->endUse();

            return $this;
        } else {
            throw new PropelException('filterByOrderItem() only accepts arguments of type \Shop\Infrastructure\Models\OrderItem\OrderItem or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the OrderItem relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinOrderItem(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('OrderItem');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'OrderItem');
        }

        return $this;
    }

    /**
     * Use the OrderItem relation OrderItem object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\OrderItem\OrderItemQuery A secondary query class using the current class as primary query
     */
    public function useOrderItemQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinOrderItem($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'OrderItem', '\Shop\Infrastructure\Models\OrderItem\OrderItemQuery');
    }

    /**
     * Use the OrderItem relation OrderItem object
     *
     * @param callable(\Shop\Infrastructure\Models\OrderItem\OrderItemQuery):\Shop\Infrastructure\Models\OrderItem\OrderItemQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withOrderItemQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useOrderItemQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to OrderItem table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\OrderItem\OrderItemQuery The inner query object of the EXISTS statement
     */
    public function useOrderItemExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('OrderItem', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to OrderItem table for a NOT EXISTS query.
     *
     * @see useOrderItemExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\OrderItem\OrderItemQuery The inner query object of the NOT EXISTS statement
     */
    public function useOrderItemNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('OrderItem', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Shop\Infrastructure\Models\PricelistFile\PricelistFile object
     *
     * @param \Shop\Infrastructure\Models\PricelistFile\PricelistFile|ObjectCollection $pricelistFile the related object to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPricelistFile($pricelistFile, ?string $comparison = null)
    {
        if ($pricelistFile instanceof \Shop\Infrastructure\Models\PricelistFile\PricelistFile) {
            $this
                ->addUsingAlias(ProviderTableMap::COL_ID, $pricelistFile->getProviderId(), $comparison);

            return $this;
        } elseif ($pricelistFile instanceof ObjectCollection) {
            $this
                ->usePricelistFileQuery()
                ->filterByPrimaryKeys($pricelistFile->getPrimaryKeys())
                ->endUse();

            return $this;
        } else {
            throw new PropelException('filterByPricelistFile() only accepts arguments of type \Shop\Infrastructure\Models\PricelistFile\PricelistFile or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the PricelistFile relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinPricelistFile(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('PricelistFile');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'PricelistFile');
        }

        return $this;
    }

    /**
     * Use the PricelistFile relation PricelistFile object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\PricelistFile\PricelistFileQuery A secondary query class using the current class as primary query
     */
    public function usePricelistFileQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinPricelistFile($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'PricelistFile', '\Shop\Infrastructure\Models\PricelistFile\PricelistFileQuery');
    }

    /**
     * Use the PricelistFile relation PricelistFile object
     *
     * @param callable(\Shop\Infrastructure\Models\PricelistFile\PricelistFileQuery):\Shop\Infrastructure\Models\PricelistFile\PricelistFileQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withPricelistFileQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->usePricelistFileQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to PricelistFile table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\PricelistFile\PricelistFileQuery The inner query object of the EXISTS statement
     */
    public function usePricelistFileExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('PricelistFile', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to PricelistFile table for a NOT EXISTS query.
     *
     * @see usePricelistFileExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\PricelistFile\PricelistFileQuery The inner query object of the NOT EXISTS statement
     */
    public function usePricelistFileNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('PricelistFile', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Exclude object from result
     *
     * @param ChildProvider $provider Object to remove from the list of results
     *
     * @return $this The current query, for fluid interface
     */
    public function prune($provider = null)
    {
        if ($provider) {
            $this->addUsingAlias(ProviderTableMap::COL_ID, $provider->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Code to execute before every DELETE statement
     *
     * @param ConnectionInterface $con The connection object used by the query
     * @return int|null
     */
    protected function basePreDelete(ConnectionInterface $con): ?int
    {
        // archivable behavior

        if ($this->archiveOnDelete) {
            $this->archive($con);
        } else {
            $this->archiveOnDelete = true;
        }


        return $this->preDelete($con);
    }

    /**
     * Deletes all rows from the shop_providers table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ProviderTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            ProviderTableMap::clearInstancePool();
            ProviderTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ProviderTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(ProviderTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            ProviderTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            ProviderTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    // archivable behavior

    /**
     * Copy the data of the objects satisfying the query into ChildShopProvidersArchive archive objects.
     * The archived objects are then saved.
     * If any of the objects has already been archived, the archived object
     * is updated and not duplicated.
     * Warning: This termination methods issues 2n+1 queries.
     *
     * @param ConnectionInterface|null $con    Connection to use.
     * @param bool $useLittleMemory Whether to use OnDemandFormatter to retrieve objects.
     *               Set to false if the identity map matters.
     *               Set to true (default) to use less memory.
     *
     * @return int the number of archived objects
     */
    public function archive($con = null, $useLittleMemory = true)
    {
        $criteria = clone $this;
        // prepare the query
        $criteria->setWith(array());
        if ($useLittleMemory) {
            $criteria->setFormatter(ModelCriteria::FORMAT_ON_DEMAND);
        }
        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(ProviderTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con, $criteria) {
            $totalArchivedObjects = 0;

            // archive all results one by one
            foreach ($criteria->find($con) as $object) {
                $object->archive($con);
                $totalArchivedObjects++;
            }

            return $totalArchivedObjects;
        });
    }

    /**
     * Enable/disable auto-archiving on delete for the next query.
     *
     * @param bool True if the query must archive deleted objects, false otherwise.
     */
    public function setArchiveOnDelete(bool $archiveOnDelete)
    {
        $this->archiveOnDelete = $archiveOnDelete;
    }

    /**
     * Delete records matching the current query without archiving them.
     *
     * @param ConnectionInterface|null $con    Connection to use.
     *
     * @return int The number of deleted rows
     */
    public function deleteWithoutArchive($con = null): int
    {
        $this->archiveOnDelete = false;

        return $this->delete($con);
    }

    /**
     * Delete all records without archiving them.
     *
     * @param ConnectionInterface|null $con    Connection to use.
     *
     * @return int The number of deleted rows
     */
    public function deleteAllWithoutArchive($con = null): int
    {
        $this->archiveOnDelete = false;

        return $this->deleteAll($con);
    }

}
