<?php declare(strict_types=1);

namespace Shop\Presentation\Transformers;

use League\Fractal\TransformerAbstract;
use Shop\Domain\ProductCategory\Contracts\ProductCategoryEntityInterface;
use Shop\Infrastructure\Models\Category\Category;

class CategoryTransformer  extends TransformerAbstract
{
    /**
     * @param ProductCategoryEntityInterface|Category $cat
     * @return array
     */
    public function transform(ProductCategoryEntityInterface $cat):array
    {
        return [
            'id' => $cat->getId(),
            'name' => $cat->getNameWithParentName('->')
        ];
    }
}