<?php


namespace Shop\Infrastructure\Repositories\PricePosition;


use Repo\Concrete\AbstractCriteria;
use Shop\Domain\PricePosition\Contracts\PricePositionCriteriaInterface;

class PricePositionCriteria extends AbstractCriteria implements PricePositionCriteriaInterface
{
    /**
     * @var int|null
     */
    protected $filterByPricelistSheetId;

    /**
     * @var string|null
     */
    protected $filterByRefId;

    /**
     * @var string|null
     */
    protected $searchByProductName;

    /**
     * @var string|null
     */
    protected $searchByDesc;

    /**
     * @var int|null
     */
    protected $filterByProductId;

    /**
     * @return string|null
     */
    public function getSearchByDesc(): ?string
    {
        return $this->searchByDesc;
    }

    /**
     * @param string|null $searchByProductDesc
     * @return PricePositionCriteriaInterface
     */
    public function setSearchByDesc(?string $desc): PricePositionCriteriaInterface
    {
        $this->searchByDesc = $desc;
        return $this;
    }


    /**
     * @return int|null
     */
    public function getFilterByProductId(): ?int
    {
        return $this->filterByProductId;
    }

    /**
     * @param int|null $filterByProductId
     * @return PricePositionCriteriaInterface
     */
    public function setFilterByProductId(?int $filterByProductId): PricePositionCriteriaInterface
    {
        $this->filterByProductId = $filterByProductId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getFilterByRefId(): ?string
    {
        return $this->filterByRefId;
    }

    /**
     * @param string|null $filterByRefId
     * @return PricePositionCriteriaInterface
     */
    public function setFilterByRefId(?string $filterByRefId): PricePositionCriteriaInterface
    {
        $this->filterByRefId = $filterByRefId;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getSearchByProductName(): ?string
    {
        return $this->searchByProductName;
    }

    /**
     * @param string|null $searchByProductName
     * @return PricePositionCriteriaInterface
     */
    public function setSearchByProductName(?string $searchByProductName): PricePositionCriteriaInterface
    {
        $this->searchByProductName = $searchByProductName;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getFilterByPricelistSheetId(): ?int
    {
        return $this->filterByPricelistSheetId;
    }

    /**
     * @param int|null $filterByPricelistSheetId
     * @return PricePositionCriteriaInterface
     */
    public function setFilterByPricelistSheetId(?int $filterByPricelistSheetId): PricePositionCriteriaInterface
    {
        $this->filterByPricelistSheetId = $filterByPricelistSheetId;
        return $this;
    }

    public static function create()
    {
        return new self;
    }

}