<?php

namespace Shop\Infrastructure\Models\Catalog\Map;

use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;
use Shop\Infrastructure\Models\Catalog\Catalog;
use Shop\Infrastructure\Models\Catalog\CatalogQuery;


/**
 * This class defines the structure of the 'shop_catalogs' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class CatalogTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    public const CLASS_NAME = 'Shop.Infrastructure.Models.Catalog.Map.CatalogTableMap';

    /**
     * The default database name for this class
     */
    public const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    public const TABLE_NAME = 'shop_catalogs';

    /**
     * The related Propel class for this table
     */
    public const OM_CLASS = '\\Shop\\Infrastructure\\Models\\Catalog\\Catalog';

    /**
     * A class that can be returned by this tableMap
     */
    public const CLASS_DEFAULT = 'Shop.Infrastructure.Models.Catalog.Catalog';

    /**
     * The total number of columns
     */
    public const NUM_COLUMNS = 6;

    /**
     * The number of lazy-loaded columns
     */
    public const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    public const NUM_HYDRATE_COLUMNS = 6;

    /**
     * the column name for the id field
     */
    public const COL_ID = 'shop_catalogs.id';

    /**
     * the column name for the name field
     */
    public const COL_NAME = 'shop_catalogs.name';

    /**
     * the column name for the alias field
     */
    public const COL_ALIAS = 'shop_catalogs.alias';

    /**
     * the column name for the desc field
     */
    public const COL_DESC = 'shop_catalogs.desc';

    /**
     * the column name for the domain_id field
     */
    public const COL_DOMAIN_ID = 'shop_catalogs.domain_id';

    /**
     * the column name for the active field
     */
    public const COL_ACTIVE = 'shop_catalogs.active';

    /**
     * The default string format for model objects of the related table
     */
    public const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     *
     * @var array<string, mixed>
     */
    protected static $fieldNames = [
        self::TYPE_PHPNAME       => ['Id', 'Name', 'Alias', 'Desc', 'DomainId', 'Active', ],
        self::TYPE_CAMELNAME     => ['id', 'name', 'alias', 'desc', 'domainId', 'active', ],
        self::TYPE_COLNAME       => [CatalogTableMap::COL_ID, CatalogTableMap::COL_NAME, CatalogTableMap::COL_ALIAS, CatalogTableMap::COL_DESC, CatalogTableMap::COL_DOMAIN_ID, CatalogTableMap::COL_ACTIVE, ],
        self::TYPE_FIELDNAME     => ['id', 'name', 'alias', 'desc', 'domain_id', 'active', ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, ]
    ];

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     *
     * @var array<string, mixed>
     */
    protected static $fieldKeys = [
        self::TYPE_PHPNAME       => ['Id' => 0, 'Name' => 1, 'Alias' => 2, 'Desc' => 3, 'DomainId' => 4, 'Active' => 5, ],
        self::TYPE_CAMELNAME     => ['id' => 0, 'name' => 1, 'alias' => 2, 'desc' => 3, 'domainId' => 4, 'active' => 5, ],
        self::TYPE_COLNAME       => [CatalogTableMap::COL_ID => 0, CatalogTableMap::COL_NAME => 1, CatalogTableMap::COL_ALIAS => 2, CatalogTableMap::COL_DESC => 3, CatalogTableMap::COL_DOMAIN_ID => 4, CatalogTableMap::COL_ACTIVE => 5, ],
        self::TYPE_FIELDNAME     => ['id' => 0, 'name' => 1, 'alias' => 2, 'desc' => 3, 'domain_id' => 4, 'active' => 5, ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, ]
    ];

    /**
     * Holds a list of column names and their normalized version.
     *
     * @var array<string>
     */
    protected $normalizedColumnNameMap = [
        'Id' => 'ID',
        'Catalog.Id' => 'ID',
        'id' => 'ID',
        'catalog.id' => 'ID',
        'CatalogTableMap::COL_ID' => 'ID',
        'COL_ID' => 'ID',
        'shop_catalogs.id' => 'ID',
        'Name' => 'NAME',
        'Catalog.Name' => 'NAME',
        'name' => 'NAME',
        'catalog.name' => 'NAME',
        'CatalogTableMap::COL_NAME' => 'NAME',
        'COL_NAME' => 'NAME',
        'shop_catalogs.name' => 'NAME',
        'Alias' => 'ALIAS',
        'Catalog.Alias' => 'ALIAS',
        'alias' => 'ALIAS',
        'catalog.alias' => 'ALIAS',
        'CatalogTableMap::COL_ALIAS' => 'ALIAS',
        'COL_ALIAS' => 'ALIAS',
        'shop_catalogs.alias' => 'ALIAS',
        'Desc' => 'DESC',
        'Catalog.Desc' => 'DESC',
        'desc' => 'DESC',
        'catalog.desc' => 'DESC',
        'CatalogTableMap::COL_DESC' => 'DESC',
        'COL_DESC' => 'DESC',
        'shop_catalogs.desc' => 'DESC',
        'DomainId' => 'DOMAIN_ID',
        'Catalog.DomainId' => 'DOMAIN_ID',
        'domainId' => 'DOMAIN_ID',
        'catalog.domainId' => 'DOMAIN_ID',
        'CatalogTableMap::COL_DOMAIN_ID' => 'DOMAIN_ID',
        'COL_DOMAIN_ID' => 'DOMAIN_ID',
        'domain_id' => 'DOMAIN_ID',
        'shop_catalogs.domain_id' => 'DOMAIN_ID',
        'Active' => 'ACTIVE',
        'Catalog.Active' => 'ACTIVE',
        'active' => 'ACTIVE',
        'catalog.active' => 'ACTIVE',
        'CatalogTableMap::COL_ACTIVE' => 'ACTIVE',
        'COL_ACTIVE' => 'ACTIVE',
        'shop_catalogs.active' => 'ACTIVE',
    ];

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function initialize(): void
    {
        // attributes
        $this->setName('shop_catalogs');
        $this->setPhpName('Catalog');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Shop\\Infrastructure\\Models\\Catalog\\Catalog');
        $this->setPackage('Shop.Infrastructure.Models.Catalog');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('name', 'Name', 'VARCHAR', false, 255, null);
        $this->addColumn('alias', 'Alias', 'VARCHAR', false, 255, null);
        $this->addColumn('desc', 'Desc', 'LONGVARCHAR', false, null, null);
        $this->addForeignKey('domain_id', 'DomainId', 'INTEGER', '_domains', 'id', true, null, null);
        $this->addColumn('active', 'Active', 'TINYINT', false, null, 1);
    }

    /**
     * Build the RelationMap objects for this table relationships
     *
     * @return void
     */
    public function buildRelations(): void
    {
        $this->addRelation('Domain', '\\Diamond\\Infrastructure\\Models\\Domain\\Domain', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':domain_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('Category', '\\Shop\\Infrastructure\\Models\\Category\\Category', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':catalog_id',
    1 => ':id',
  ),
), null, null, 'Categories', false);
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string|null The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): ?string
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param bool $withPrefix Whether to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass(bool $withPrefix = true): string
    {
        return $withPrefix ? CatalogTableMap::CLASS_DEFAULT : CatalogTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array $row Row returned by DataFetcher->fetch().
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array (Catalog object, last column rank)
     */
    public static function populateObject(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): array
    {
        $key = CatalogTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = CatalogTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + CatalogTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = CatalogTableMap::OM_CLASS;
            /** @var Catalog $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            CatalogTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array<object>
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher): array
    {
        $results = [];

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = CatalogTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = CatalogTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var Catalog $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                CatalogTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria Object containing the columns to add.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function addSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->addSelectColumn(CatalogTableMap::COL_ID);
            $criteria->addSelectColumn(CatalogTableMap::COL_NAME);
            $criteria->addSelectColumn(CatalogTableMap::COL_ALIAS);
            $criteria->addSelectColumn(CatalogTableMap::COL_DESC);
            $criteria->addSelectColumn(CatalogTableMap::COL_DOMAIN_ID);
            $criteria->addSelectColumn(CatalogTableMap::COL_ACTIVE);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.name');
            $criteria->addSelectColumn($alias . '.alias');
            $criteria->addSelectColumn($alias . '.desc');
            $criteria->addSelectColumn($alias . '.domain_id');
            $criteria->addSelectColumn($alias . '.active');
        }
    }

    /**
     * Remove all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be removed as they are only loaded on demand.
     *
     * @param Criteria $criteria Object containing the columns to remove.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function removeSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->removeSelectColumn(CatalogTableMap::COL_ID);
            $criteria->removeSelectColumn(CatalogTableMap::COL_NAME);
            $criteria->removeSelectColumn(CatalogTableMap::COL_ALIAS);
            $criteria->removeSelectColumn(CatalogTableMap::COL_DESC);
            $criteria->removeSelectColumn(CatalogTableMap::COL_DOMAIN_ID);
            $criteria->removeSelectColumn(CatalogTableMap::COL_ACTIVE);
        } else {
            $criteria->removeSelectColumn($alias . '.id');
            $criteria->removeSelectColumn($alias . '.name');
            $criteria->removeSelectColumn($alias . '.alias');
            $criteria->removeSelectColumn($alias . '.desc');
            $criteria->removeSelectColumn($alias . '.domain_id');
            $criteria->removeSelectColumn($alias . '.active');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap(): TableMap
    {
        return Propel::getServiceContainer()->getDatabaseMap(CatalogTableMap::DATABASE_NAME)->getTable(CatalogTableMap::TABLE_NAME);
    }

    /**
     * Performs a DELETE on the database, given a Catalog or Criteria object OR a primary key value.
     *
     * @param mixed $values Criteria or Catalog object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ?ConnectionInterface $con = null): int
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(CatalogTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Shop\Infrastructure\Models\Catalog\Catalog) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(CatalogTableMap::DATABASE_NAME);
            $criteria->add(CatalogTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = CatalogQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            CatalogTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                CatalogTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the shop_catalogs table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(?ConnectionInterface $con = null): int
    {
        return CatalogQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a Catalog or Criteria object.
     *
     * @param mixed $criteria Criteria or Catalog object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed The new primary key.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(CatalogTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from Catalog object
        }

        if ($criteria->containsKey(CatalogTableMap::COL_ID) && $criteria->keyContainsValue(CatalogTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.CatalogTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = CatalogQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

}
