<?php

namespace Shop\Presentation\Modules\AdminProductsLite;

use ActiveTable\ColumnTable;
use ActiveTable\DataTableEngine;
use Diamond\Helpers\Form;
use Shop\Domain\Product\Contracts\ProductEntityInterface;
use Shop\Presentation\Modules\AdminProducts\AdminProducts;
use Shop\Infrastructure\Repositories\Brand\BrandCriteria;
use Shop\Infrastructure\Repositories\Product\ProductCriteria;
use Shop\Infrastructure\Repositories\ProductCategory\ProductCategoryCriteria;
use Shop\Infrastructure\Repositories\ProductGroup\ProductGroupCriteria;

/**
 * Description of AdminProductsLite
 *
 * @author Diamond Code Generator
 */
class AdminProductsLite extends AdminProducts
{


    /**
     * @return string
     * @throws \ReflectionException
     * @throws \Repo\Concrete\Exceptions\Collection
     */
    public function process(): string
    {

        $table = $this->tableFactory->buildAdminTable($this->productRepository, ProductCriteria::create());

        $table
            ->removeControlAccess(DataTableEngine::CONTROL_ROWS_ACTION)
            ->setDefaultSortColumn('id', 'desc')
            ->addColumn(
                (new ColumnTable('id', '№'))
                    ->setWidth(40)
            )
            ->addColumn(
                (new ColumnTable('article', 'Артикул'))

            )
            ->addColumn(
                (new ColumnTable('title', 'Наименование'))

            )
            ->addColumn(
                (new ColumnTable('weight', 'Вес'))

            )
            ->addColumn(
                (new ColumnTable('price', 'Цена'))

            )
            ->addColumn(
                (new ColumnTable('categoryId', 'Раздел'))
                    ->setFormat($this, 'formatCategory')

            )
            ->addColumn(
                (new ColumnTable('brand', 'Производитель'))
                    ->setFormat($this, 'formatBrand')

            )
            ->addColumn(
                (new ColumnTable('active', 'Опубликован'))
                    ->setFormat($this, 'formatActive')

            )
            ->addColumn(
                (new ColumnTable('special', 'Спец. предложение'))
                    ->setFormat($this, 'formatSpecial')

            )
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setFormat($this, 'formatSelect')
                    ->setWidth(120)
            );

        $categories = $this->productCategoryRepository->findByCriteria(
            ProductCategoryCriteria::create()
        );

        $categoriesAr = Form::prepareDropdown($categories, 'Раздел каталога', 'getDropdownListWithParent');

        $table
            ->addFilter(
                $this->controlBuilder->buildInput('filter_by_id')
            )
            ->addFilter(
                $this->controlBuilder->buildInput('search_by_article')
            )
            ->addFilter(
                $this->controlBuilder->buildInput('search_by_title')
            )
            ->addFilter(
                $this->controlBuilder->buildInput('search_by_brand')
            )
            ->addFilter(
                $this->controlBuilder->buildDropdownUniform('filter_by_categoryId',
                    $categoriesAr
                )
            )
            ->addFilter(
                $this->controlBuilder->buildDropdownYNUniform('filter_by_active', [
                    null => 'любой'
                ])
            )
            ->addFilter(
                $this->controlBuilder->buildDropdownYNUniform('filter_by_special', [
                    null => 'любой'
                ])
            );

        $brands = $this->brandRepository->findByCriteria(
            BrandCriteria::create()
        );

        $brandsAr = Form::prepareDropdown($brands);

        //$groups
        $groups = $this->productGroupRepository->findByCriteria(
            ProductGroupCriteria::create()
        );
        $groupsAr = $groups->getDropDownList();

        $productGroupsIds = [];

        $this->buildForm($table, $categoriesAr, $brandsAr, $groupsAr, $productGroupsIds);

        return $table->render();
    }

    /**
     * @param ProductEntityInterface $product
     * @return string
     */
    public function formatSelect(ProductEntityInterface $product): string
    {
        return '<button value="'.htmlspecialchars($product->getName()).
            '" onclick="selectValueInWindow(opener.document,\'productId\',\''.$product->getId().
            '\',this);" type="button" name="select" class="search-button stdbtn btn_red">Выбрать</button>';
    }
}               