<?php


namespace Shop\Infrastructure\Repositories\ProductGroup;


use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;
use Shop\Domain\ProductGroup\ProductGroupCollection;
use Shop\Infrastructure\Models\ProductGroup\ProductGroup;
use Shop\Infrastructure\Models\ProductGroup\ProductGroupQuery;

class ProductGroupRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    public static function createEntity(): EntityInterface
    {
        return new ProductGroup();
    }

    protected function createQuery(): ModelCriteria
    {
        return ProductGroupQuery::create();
    }

    /**
     * @param PaginationInterface|ProductGroupCriteria $criteria
     * @param ModelCriteria|ProductGroupQuery $dbCriteria
     * @return void
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {
        $dbCriteria
            ->_if($criteria->getFilterByName() !== null)
            ->filterByName($criteria->getFilterByName())
            ->_endif()
        ;
    }

    protected function createCollection(): CollectionInterface
    {
        return new ProductGroupCollection();
    }
}