<?php

namespace Shop\Infrastructure\Models\Provider\Map;

use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;
use Shop\Infrastructure\Models\Provider\ShopProvidersArchive;
use Shop\Infrastructure\Models\Provider\ShopProvidersArchiveQuery;


/**
 * This class defines the structure of the 'shop_providers_archive' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class ShopProvidersArchiveTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    public const CLASS_NAME = 'Shop.Infrastructure.Models.Provider.Map.ShopProvidersArchiveTableMap';

    /**
     * The default database name for this class
     */
    public const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    public const TABLE_NAME = 'shop_providers_archive';

    /**
     * The related Propel class for this table
     */
    public const OM_CLASS = '\\Shop\\Infrastructure\\Models\\Provider\\ShopProvidersArchive';

    /**
     * A class that can be returned by this tableMap
     */
    public const CLASS_DEFAULT = 'Shop.Infrastructure.Models.Provider.ShopProvidersArchive';

    /**
     * The total number of columns
     */
    public const NUM_COLUMNS = 11;

    /**
     * The number of lazy-loaded columns
     */
    public const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    public const NUM_HYDRATE_COLUMNS = 11;

    /**
     * the column name for the id field
     */
    public const COL_ID = 'shop_providers_archive.id';

    /**
     * the column name for the name field
     */
    public const COL_NAME = 'shop_providers_archive.name';

    /**
     * the column name for the term field
     */
    public const COL_TERM = 'shop_providers_archive.term';

    /**
     * the column name for the desc field
     */
    public const COL_DESC = 'shop_providers_archive.desc';

    /**
     * the column name for the contact field
     */
    public const COL_CONTACT = 'shop_providers_archive.contact';

    /**
     * the column name for the destination field
     */
    public const COL_DESTINATION = 'shop_providers_archive.destination';

    /**
     * the column name for the color field
     */
    public const COL_COLOR = 'shop_providers_archive.color';

    /**
     * the column name for the shop_id field
     */
    public const COL_SHOP_ID = 'shop_providers_archive.shop_id';

    /**
     * the column name for the crrency_id field
     */
    public const COL_CRRENCY_ID = 'shop_providers_archive.crrency_id';

    /**
     * the column name for the contractor_id field
     */
    public const COL_CONTRACTOR_ID = 'shop_providers_archive.contractor_id';

    /**
     * the column name for the archived_at field
     */
    public const COL_ARCHIVED_AT = 'shop_providers_archive.archived_at';

    /**
     * The default string format for model objects of the related table
     */
    public const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     *
     * @var array<string, mixed>
     */
    protected static $fieldNames = [
        self::TYPE_PHPNAME       => ['Id', 'Name', 'Term', 'Desc', 'Contact', 'Destination', 'Color', 'ShopId', 'CurrencyId', 'ContractorId', 'ArchivedAt', ],
        self::TYPE_CAMELNAME     => ['id', 'name', 'term', 'desc', 'contact', 'destination', 'color', 'shopId', 'currencyId', 'contractorId', 'archivedAt', ],
        self::TYPE_COLNAME       => [ShopProvidersArchiveTableMap::COL_ID, ShopProvidersArchiveTableMap::COL_NAME, ShopProvidersArchiveTableMap::COL_TERM, ShopProvidersArchiveTableMap::COL_DESC, ShopProvidersArchiveTableMap::COL_CONTACT, ShopProvidersArchiveTableMap::COL_DESTINATION, ShopProvidersArchiveTableMap::COL_COLOR, ShopProvidersArchiveTableMap::COL_SHOP_ID, ShopProvidersArchiveTableMap::COL_CRRENCY_ID, ShopProvidersArchiveTableMap::COL_CONTRACTOR_ID, ShopProvidersArchiveTableMap::COL_ARCHIVED_AT, ],
        self::TYPE_FIELDNAME     => ['id', 'name', 'term', 'desc', 'contact', 'destination', 'color', 'shop_id', 'crrency_id', 'contractor_id', 'archived_at', ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, ]
    ];

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     *
     * @var array<string, mixed>
     */
    protected static $fieldKeys = [
        self::TYPE_PHPNAME       => ['Id' => 0, 'Name' => 1, 'Term' => 2, 'Desc' => 3, 'Contact' => 4, 'Destination' => 5, 'Color' => 6, 'ShopId' => 7, 'CurrencyId' => 8, 'ContractorId' => 9, 'ArchivedAt' => 10, ],
        self::TYPE_CAMELNAME     => ['id' => 0, 'name' => 1, 'term' => 2, 'desc' => 3, 'contact' => 4, 'destination' => 5, 'color' => 6, 'shopId' => 7, 'currencyId' => 8, 'contractorId' => 9, 'archivedAt' => 10, ],
        self::TYPE_COLNAME       => [ShopProvidersArchiveTableMap::COL_ID => 0, ShopProvidersArchiveTableMap::COL_NAME => 1, ShopProvidersArchiveTableMap::COL_TERM => 2, ShopProvidersArchiveTableMap::COL_DESC => 3, ShopProvidersArchiveTableMap::COL_CONTACT => 4, ShopProvidersArchiveTableMap::COL_DESTINATION => 5, ShopProvidersArchiveTableMap::COL_COLOR => 6, ShopProvidersArchiveTableMap::COL_SHOP_ID => 7, ShopProvidersArchiveTableMap::COL_CRRENCY_ID => 8, ShopProvidersArchiveTableMap::COL_CONTRACTOR_ID => 9, ShopProvidersArchiveTableMap::COL_ARCHIVED_AT => 10, ],
        self::TYPE_FIELDNAME     => ['id' => 0, 'name' => 1, 'term' => 2, 'desc' => 3, 'contact' => 4, 'destination' => 5, 'color' => 6, 'shop_id' => 7, 'crrency_id' => 8, 'contractor_id' => 9, 'archived_at' => 10, ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, ]
    ];

    /**
     * Holds a list of column names and their normalized version.
     *
     * @var array<string>
     */
    protected $normalizedColumnNameMap = [
        'Id' => 'ID',
        'ShopProvidersArchive.Id' => 'ID',
        'id' => 'ID',
        'shopProvidersArchive.id' => 'ID',
        'ShopProvidersArchiveTableMap::COL_ID' => 'ID',
        'COL_ID' => 'ID',
        'shop_providers_archive.id' => 'ID',
        'Name' => 'NAME',
        'ShopProvidersArchive.Name' => 'NAME',
        'name' => 'NAME',
        'shopProvidersArchive.name' => 'NAME',
        'ShopProvidersArchiveTableMap::COL_NAME' => 'NAME',
        'COL_NAME' => 'NAME',
        'shop_providers_archive.name' => 'NAME',
        'Term' => 'TERM',
        'ShopProvidersArchive.Term' => 'TERM',
        'term' => 'TERM',
        'shopProvidersArchive.term' => 'TERM',
        'ShopProvidersArchiveTableMap::COL_TERM' => 'TERM',
        'COL_TERM' => 'TERM',
        'shop_providers_archive.term' => 'TERM',
        'Desc' => 'DESC',
        'ShopProvidersArchive.Desc' => 'DESC',
        'desc' => 'DESC',
        'shopProvidersArchive.desc' => 'DESC',
        'ShopProvidersArchiveTableMap::COL_DESC' => 'DESC',
        'COL_DESC' => 'DESC',
        'shop_providers_archive.desc' => 'DESC',
        'Contact' => 'CONTACT',
        'ShopProvidersArchive.Contact' => 'CONTACT',
        'contact' => 'CONTACT',
        'shopProvidersArchive.contact' => 'CONTACT',
        'ShopProvidersArchiveTableMap::COL_CONTACT' => 'CONTACT',
        'COL_CONTACT' => 'CONTACT',
        'shop_providers_archive.contact' => 'CONTACT',
        'Destination' => 'DESTINATION',
        'ShopProvidersArchive.Destination' => 'DESTINATION',
        'destination' => 'DESTINATION',
        'shopProvidersArchive.destination' => 'DESTINATION',
        'ShopProvidersArchiveTableMap::COL_DESTINATION' => 'DESTINATION',
        'COL_DESTINATION' => 'DESTINATION',
        'shop_providers_archive.destination' => 'DESTINATION',
        'Color' => 'COLOR',
        'ShopProvidersArchive.Color' => 'COLOR',
        'color' => 'COLOR',
        'shopProvidersArchive.color' => 'COLOR',
        'ShopProvidersArchiveTableMap::COL_COLOR' => 'COLOR',
        'COL_COLOR' => 'COLOR',
        'shop_providers_archive.color' => 'COLOR',
        'ShopId' => 'SHOP_ID',
        'ShopProvidersArchive.ShopId' => 'SHOP_ID',
        'shopId' => 'SHOP_ID',
        'shopProvidersArchive.shopId' => 'SHOP_ID',
        'ShopProvidersArchiveTableMap::COL_SHOP_ID' => 'SHOP_ID',
        'COL_SHOP_ID' => 'SHOP_ID',
        'shop_id' => 'SHOP_ID',
        'shop_providers_archive.shop_id' => 'SHOP_ID',
        'CurrencyId' => 'CRRENCY_ID',
        'ShopProvidersArchive.CurrencyId' => 'CRRENCY_ID',
        'currencyId' => 'CRRENCY_ID',
        'shopProvidersArchive.currencyId' => 'CRRENCY_ID',
        'ShopProvidersArchiveTableMap::COL_CRRENCY_ID' => 'CRRENCY_ID',
        'COL_CRRENCY_ID' => 'CRRENCY_ID',
        'crrency_id' => 'CRRENCY_ID',
        'shop_providers_archive.crrency_id' => 'CRRENCY_ID',
        'ContractorId' => 'CONTRACTOR_ID',
        'ShopProvidersArchive.ContractorId' => 'CONTRACTOR_ID',
        'contractorId' => 'CONTRACTOR_ID',
        'shopProvidersArchive.contractorId' => 'CONTRACTOR_ID',
        'ShopProvidersArchiveTableMap::COL_CONTRACTOR_ID' => 'CONTRACTOR_ID',
        'COL_CONTRACTOR_ID' => 'CONTRACTOR_ID',
        'contractor_id' => 'CONTRACTOR_ID',
        'shop_providers_archive.contractor_id' => 'CONTRACTOR_ID',
        'ArchivedAt' => 'ARCHIVED_AT',
        'ShopProvidersArchive.ArchivedAt' => 'ARCHIVED_AT',
        'archivedAt' => 'ARCHIVED_AT',
        'shopProvidersArchive.archivedAt' => 'ARCHIVED_AT',
        'ShopProvidersArchiveTableMap::COL_ARCHIVED_AT' => 'ARCHIVED_AT',
        'COL_ARCHIVED_AT' => 'ARCHIVED_AT',
        'archived_at' => 'ARCHIVED_AT',
        'shop_providers_archive.archived_at' => 'ARCHIVED_AT',
    ];

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function initialize(): void
    {
        // attributes
        $this->setName('shop_providers_archive');
        $this->setPhpName('ShopProvidersArchive');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Shop\\Infrastructure\\Models\\Provider\\ShopProvidersArchive');
        $this->setPackage('Shop.Infrastructure.Models.Provider');
        $this->setUseIdGenerator(false);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('name', 'Name', 'VARCHAR', false, 255, null);
        $this->addColumn('term', 'Term', 'INTEGER', true, null, null);
        $this->addColumn('desc', 'Desc', 'LONGVARCHAR', false, null, null);
        $this->addColumn('contact', 'Contact', 'VARCHAR', false, 255, null);
        $this->addColumn('destination', 'Destination', 'VARCHAR', false, 255, null);
        $this->addColumn('color', 'Color', 'CHAR', false, 10, null);
        $this->addColumn('shop_id', 'ShopId', 'INTEGER', true, null, null);
        $this->addColumn('crrency_id', 'CurrencyId', 'INTEGER', true, null, null);
        $this->addColumn('contractor_id', 'ContractorId', 'INTEGER', true, null, null);
        $this->addColumn('archived_at', 'ArchivedAt', 'TIMESTAMP', false, null, null);
    }

    /**
     * Build the RelationMap objects for this table relationships
     *
     * @return void
     */
    public function buildRelations(): void
    {
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string|null The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): ?string
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param bool $withPrefix Whether to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass(bool $withPrefix = true): string
    {
        return $withPrefix ? ShopProvidersArchiveTableMap::CLASS_DEFAULT : ShopProvidersArchiveTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array $row Row returned by DataFetcher->fetch().
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array (ShopProvidersArchive object, last column rank)
     */
    public static function populateObject(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): array
    {
        $key = ShopProvidersArchiveTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = ShopProvidersArchiveTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + ShopProvidersArchiveTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = ShopProvidersArchiveTableMap::OM_CLASS;
            /** @var ShopProvidersArchive $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            ShopProvidersArchiveTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array<object>
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher): array
    {
        $results = [];

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = ShopProvidersArchiveTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = ShopProvidersArchiveTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var ShopProvidersArchive $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                ShopProvidersArchiveTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria Object containing the columns to add.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function addSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->addSelectColumn(ShopProvidersArchiveTableMap::COL_ID);
            $criteria->addSelectColumn(ShopProvidersArchiveTableMap::COL_NAME);
            $criteria->addSelectColumn(ShopProvidersArchiveTableMap::COL_TERM);
            $criteria->addSelectColumn(ShopProvidersArchiveTableMap::COL_DESC);
            $criteria->addSelectColumn(ShopProvidersArchiveTableMap::COL_CONTACT);
            $criteria->addSelectColumn(ShopProvidersArchiveTableMap::COL_DESTINATION);
            $criteria->addSelectColumn(ShopProvidersArchiveTableMap::COL_COLOR);
            $criteria->addSelectColumn(ShopProvidersArchiveTableMap::COL_SHOP_ID);
            $criteria->addSelectColumn(ShopProvidersArchiveTableMap::COL_CRRENCY_ID);
            $criteria->addSelectColumn(ShopProvidersArchiveTableMap::COL_CONTRACTOR_ID);
            $criteria->addSelectColumn(ShopProvidersArchiveTableMap::COL_ARCHIVED_AT);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.name');
            $criteria->addSelectColumn($alias . '.term');
            $criteria->addSelectColumn($alias . '.desc');
            $criteria->addSelectColumn($alias . '.contact');
            $criteria->addSelectColumn($alias . '.destination');
            $criteria->addSelectColumn($alias . '.color');
            $criteria->addSelectColumn($alias . '.shop_id');
            $criteria->addSelectColumn($alias . '.crrency_id');
            $criteria->addSelectColumn($alias . '.contractor_id');
            $criteria->addSelectColumn($alias . '.archived_at');
        }
    }

    /**
     * Remove all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be removed as they are only loaded on demand.
     *
     * @param Criteria $criteria Object containing the columns to remove.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function removeSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->removeSelectColumn(ShopProvidersArchiveTableMap::COL_ID);
            $criteria->removeSelectColumn(ShopProvidersArchiveTableMap::COL_NAME);
            $criteria->removeSelectColumn(ShopProvidersArchiveTableMap::COL_TERM);
            $criteria->removeSelectColumn(ShopProvidersArchiveTableMap::COL_DESC);
            $criteria->removeSelectColumn(ShopProvidersArchiveTableMap::COL_CONTACT);
            $criteria->removeSelectColumn(ShopProvidersArchiveTableMap::COL_DESTINATION);
            $criteria->removeSelectColumn(ShopProvidersArchiveTableMap::COL_COLOR);
            $criteria->removeSelectColumn(ShopProvidersArchiveTableMap::COL_SHOP_ID);
            $criteria->removeSelectColumn(ShopProvidersArchiveTableMap::COL_CRRENCY_ID);
            $criteria->removeSelectColumn(ShopProvidersArchiveTableMap::COL_CONTRACTOR_ID);
            $criteria->removeSelectColumn(ShopProvidersArchiveTableMap::COL_ARCHIVED_AT);
        } else {
            $criteria->removeSelectColumn($alias . '.id');
            $criteria->removeSelectColumn($alias . '.name');
            $criteria->removeSelectColumn($alias . '.term');
            $criteria->removeSelectColumn($alias . '.desc');
            $criteria->removeSelectColumn($alias . '.contact');
            $criteria->removeSelectColumn($alias . '.destination');
            $criteria->removeSelectColumn($alias . '.color');
            $criteria->removeSelectColumn($alias . '.shop_id');
            $criteria->removeSelectColumn($alias . '.crrency_id');
            $criteria->removeSelectColumn($alias . '.contractor_id');
            $criteria->removeSelectColumn($alias . '.archived_at');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap(): TableMap
    {
        return Propel::getServiceContainer()->getDatabaseMap(ShopProvidersArchiveTableMap::DATABASE_NAME)->getTable(ShopProvidersArchiveTableMap::TABLE_NAME);
    }

    /**
     * Performs a DELETE on the database, given a ShopProvidersArchive or Criteria object OR a primary key value.
     *
     * @param mixed $values Criteria or ShopProvidersArchive object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ?ConnectionInterface $con = null): int
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ShopProvidersArchiveTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Shop\Infrastructure\Models\Provider\ShopProvidersArchive) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(ShopProvidersArchiveTableMap::DATABASE_NAME);
            $criteria->add(ShopProvidersArchiveTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = ShopProvidersArchiveQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            ShopProvidersArchiveTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                ShopProvidersArchiveTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the shop_providers_archive table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(?ConnectionInterface $con = null): int
    {
        return ShopProvidersArchiveQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a ShopProvidersArchive or Criteria object.
     *
     * @param mixed $criteria Criteria or ShopProvidersArchive object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed The new primary key.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ShopProvidersArchiveTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from ShopProvidersArchive object
        }


        // Set the correct dbName
        $query = ShopProvidersArchiveQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

}
