<?php

namespace Shop\Infrastructure\Models\Order;

use Shop\Domain\CustomerOrder\Contracts\CustomerOrderEntityInterface;
use Shop\Domain\ProviderOrder\Contracts\ProviderOrderEntityInterface;
use Shop\Infrastructure\Models\Order\Base\Order as BaseOrder;

/**
 * Skeleton subclass for representing a row from the 'shop_orders' table.
 *
 *
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 */
class Order extends BaseOrder implements CustomerOrderEntityInterface, ProviderOrderEntityInterface
{

    /**
     * признак оплаты
     * @var bool
     */
    protected $isPayment = false;

    public function isPayment(): bool
    {
        return $this->isPayment;
    }

    public function setIsPayment(bool $r)
    {
        $this->isPayment = $r;
        return $this;
    }

    /**
     * @return float
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getSumm(): float
    {
        return $this->getSum();
    }

    /**
     * @return float
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getSum(): float
    {
        $sum = 0;
        foreach ($this->getOrderItems() as $item) {
            $sum = $sum + $item->getPrice() * $item->getAmount();
        }

        return (float)$sum;
    }

    /**
     * @return int
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getItemsCount(): int
    {
        return $this->getOrderItems()->count();
    }

    /**
     * @return string
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getOrderCode(): string
    {
        $mask = $this->getType()->getCodeMask();

        $params = array_change_key_case($this->toArray());

        $res = preg_replace_callback("~\{\{.*?\}\}~", function ($e) use ($params) {
            $k = rtrim(ltrim($e[0], "{{"), "}}");
            return isset($params[$k]) ? $params[$k] : null;
        }, $mask);

        //dd($res);
        //dd(str_replace());
//        "id" => 248
//  "typeid" => 1
//  "customerid" => 150
//  "datetime" => "2020-09-02T14:28:59+03:00"
//  "udatetime" => null
//  "discountsumm" => "0.00"
//  "reload" => "N"
//  "deliveryaddress" => "Старославянская д.2 кв.45"
//  "paymentid" => 1
//  "stateid" => 7
//  "comment" => "test"
//  "postcode" => ""
//  "shopid" => 1
//  "contractorid" => 486
        return $res;
    }

    /**
     * @return float
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getOrderFinalSumm(): float
    {
        $summ = $this->getSumm();

        return $summ - (float)$this->getDiscountSumm();
    }

    /**
     *
     * @return float
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getDiscountPercent(): float
    {
        if (!$this->getSumm()) {
            return 0;
        }
        return round($this->getDiscountSumm() / $this->getSumm() * 100);
    }

}
