<?php declare(strict_types=1);

namespace Shop\Application\Catalog\UpdateProduct;

use Psr\Log\LoggerAwareInterface;
use Psr\Log\LoggerAwareTrait;
use Psr\Log\LoggerInterface;
use Psr\Log\NullLogger;
use Shop\Domain\Product\Contracts\ProductEntityInterface;

class UpdateProductCommand implements LoggerAwareInterface
{
    use LoggerAwareTrait;

    public function __construct(private ProductEntityInterface  $product,
                                private string                  $name,
                                private string                  $sku,
                                private float                   $price,
                                private ?string                 $description,
                                private array                   $images,
                                private int                     $categoryId,
                                private int                     $brandId,
                                private array                   $groupIds,
                                private array $positionCollection
    )
    {
        $this->logger = new NullLogger();
    }

    public function getLogger(): LoggerInterface
    {
        return $this->logger;
    }

    /**
     * @return ProductEntityInterface|\Shop\Infrastructure\Models\Product\Product
     */
    public function getProduct(): ProductEntityInterface
    {
        return $this->product;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getSku(): string
    {
        return $this->sku;
    }

    public function getPrice(): float
    {
        return $this->price;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function getImages(): array
    {
        return $this->images;
    }

    public function getCategoryId(): int
    {
        return $this->categoryId;
    }

    public function getBrandId(): int
    {
        return $this->brandId;
    }

    public function getGroupIds(): array
    {
        return $this->groupIds;
    }

    public function getPositionCollection(): array
    {
        return $this->positionCollection;
    }

}