<?php


namespace Shop\Infrastructure\Repositories\Region;


use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;
use Shop\Domain\Region\Contracts\RegionCriteriaInterface;
use Shop\Domain\Region\RegionCollection;
use Shop\Infrastructure\Models\Region\Region;
use Shop\Infrastructure\Models\Region\RegionQuery;

class RegionRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    public static function createEntity(): EntityInterface
    {
        return new Region();
    }

    protected function createQuery(): ModelCriteria
    {
        return RegionQuery::create();
    }

    /**
     * @param PaginationInterface|RegionCriteriaInterface $criteria
     * @param ModelCriteria|RegionQuery $dbCriteria
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {

        $dbCriteria
            ->_if($criteria->getSearchByName() !== null)
            ->filterByName('%' . $criteria->getSearchByName() . '%', Criteria::LIKE)
            ->_endif()
            ->_if($criteria->getFilterByCountryId() !== null)
            ->filterByCountryId($criteria->getFilterByCountryId())
            ->_endif()
            ->_if($criteria->getSortByName() !== null)
            ->orderByName($criteria->getSortByName())
            ->_endif();
    }
    

    protected function createCollection(): CollectionInterface
    {
        return new RegionCollection();
    }
}