<?php

namespace Shop\Infrastructure\Models\PaymentTransaction\Map;

use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;
use Shop\Infrastructure\Models\PaymentTransaction\PaymentTransaction;
use Shop\Infrastructure\Models\PaymentTransaction\PaymentTransactionQuery;


/**
 * This class defines the structure of the 'shop_payment_transactions' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class PaymentTransactionTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    public const CLASS_NAME = 'Shop.Infrastructure.Models.PaymentTransaction.Map.PaymentTransactionTableMap';

    /**
     * The default database name for this class
     */
    public const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    public const TABLE_NAME = 'shop_payment_transactions';

    /**
     * The related Propel class for this table
     */
    public const OM_CLASS = '\\Shop\\Infrastructure\\Models\\PaymentTransaction\\PaymentTransaction';

    /**
     * A class that can be returned by this tableMap
     */
    public const CLASS_DEFAULT = 'Shop.Infrastructure.Models.PaymentTransaction.PaymentTransaction';

    /**
     * The total number of columns
     */
    public const NUM_COLUMNS = 12;

    /**
     * The number of lazy-loaded columns
     */
    public const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    public const NUM_HYDRATE_COLUMNS = 12;

    /**
     * the column name for the id field
     */
    public const COL_ID = 'shop_payment_transactions.id';

    /**
     * the column name for the code field
     */
    public const COL_CODE = 'shop_payment_transactions.code';

    /**
     * the column name for the datetime field
     */
    public const COL_DATETIME = 'shop_payment_transactions.datetime';

    /**
     * the column name for the udatetime field
     */
    public const COL_UDATETIME = 'shop_payment_transactions.udatetime';

    /**
     * the column name for the order_summ field
     */
    public const COL_ORDER_SUMM = 'shop_payment_transactions.order_summ';

    /**
     * the column name for the payed_summ field
     */
    public const COL_PAYED_SUMM = 'shop_payment_transactions.payed_summ';

    /**
     * the column name for the confirmed field
     */
    public const COL_CONFIRMED = 'shop_payment_transactions.confirmed';

    /**
     * the column name for the result field
     */
    public const COL_RESULT = 'shop_payment_transactions.result';

    /**
     * the column name for the desc field
     */
    public const COL_DESC = 'shop_payment_transactions.desc';

    /**
     * the column name for the commission field
     */
    public const COL_COMMISSION = 'shop_payment_transactions.commission';

    /**
     * the column name for the order_id field
     */
    public const COL_ORDER_ID = 'shop_payment_transactions.order_id';

    /**
     * the column name for the currency field
     */
    public const COL_CURRENCY = 'shop_payment_transactions.currency';

    /**
     * The default string format for model objects of the related table
     */
    public const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     *
     * @var array<string, mixed>
     */
    protected static $fieldNames = [
        self::TYPE_PHPNAME       => ['Id', 'Code', 'Datetime', 'UDatetime', 'OrderSumm', 'PayedSumm', 'Confirmed', 'Result', 'Desc', 'Commission', 'OrderId', 'Currency', ],
        self::TYPE_CAMELNAME     => ['id', 'code', 'datetime', 'uDatetime', 'orderSumm', 'payedSumm', 'confirmed', 'result', 'desc', 'commission', 'orderId', 'currency', ],
        self::TYPE_COLNAME       => [PaymentTransactionTableMap::COL_ID, PaymentTransactionTableMap::COL_CODE, PaymentTransactionTableMap::COL_DATETIME, PaymentTransactionTableMap::COL_UDATETIME, PaymentTransactionTableMap::COL_ORDER_SUMM, PaymentTransactionTableMap::COL_PAYED_SUMM, PaymentTransactionTableMap::COL_CONFIRMED, PaymentTransactionTableMap::COL_RESULT, PaymentTransactionTableMap::COL_DESC, PaymentTransactionTableMap::COL_COMMISSION, PaymentTransactionTableMap::COL_ORDER_ID, PaymentTransactionTableMap::COL_CURRENCY, ],
        self::TYPE_FIELDNAME     => ['id', 'code', 'datetime', 'udatetime', 'order_summ', 'payed_summ', 'confirmed', 'result', 'desc', 'commission', 'order_id', 'currency', ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, ]
    ];

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     *
     * @var array<string, mixed>
     */
    protected static $fieldKeys = [
        self::TYPE_PHPNAME       => ['Id' => 0, 'Code' => 1, 'Datetime' => 2, 'UDatetime' => 3, 'OrderSumm' => 4, 'PayedSumm' => 5, 'Confirmed' => 6, 'Result' => 7, 'Desc' => 8, 'Commission' => 9, 'OrderId' => 10, 'Currency' => 11, ],
        self::TYPE_CAMELNAME     => ['id' => 0, 'code' => 1, 'datetime' => 2, 'uDatetime' => 3, 'orderSumm' => 4, 'payedSumm' => 5, 'confirmed' => 6, 'result' => 7, 'desc' => 8, 'commission' => 9, 'orderId' => 10, 'currency' => 11, ],
        self::TYPE_COLNAME       => [PaymentTransactionTableMap::COL_ID => 0, PaymentTransactionTableMap::COL_CODE => 1, PaymentTransactionTableMap::COL_DATETIME => 2, PaymentTransactionTableMap::COL_UDATETIME => 3, PaymentTransactionTableMap::COL_ORDER_SUMM => 4, PaymentTransactionTableMap::COL_PAYED_SUMM => 5, PaymentTransactionTableMap::COL_CONFIRMED => 6, PaymentTransactionTableMap::COL_RESULT => 7, PaymentTransactionTableMap::COL_DESC => 8, PaymentTransactionTableMap::COL_COMMISSION => 9, PaymentTransactionTableMap::COL_ORDER_ID => 10, PaymentTransactionTableMap::COL_CURRENCY => 11, ],
        self::TYPE_FIELDNAME     => ['id' => 0, 'code' => 1, 'datetime' => 2, 'udatetime' => 3, 'order_summ' => 4, 'payed_summ' => 5, 'confirmed' => 6, 'result' => 7, 'desc' => 8, 'commission' => 9, 'order_id' => 10, 'currency' => 11, ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, ]
    ];

    /**
     * Holds a list of column names and their normalized version.
     *
     * @var array<string>
     */
    protected $normalizedColumnNameMap = [
        'Id' => 'ID',
        'PaymentTransaction.Id' => 'ID',
        'id' => 'ID',
        'paymentTransaction.id' => 'ID',
        'PaymentTransactionTableMap::COL_ID' => 'ID',
        'COL_ID' => 'ID',
        'shop_payment_transactions.id' => 'ID',
        'Code' => 'CODE',
        'PaymentTransaction.Code' => 'CODE',
        'code' => 'CODE',
        'paymentTransaction.code' => 'CODE',
        'PaymentTransactionTableMap::COL_CODE' => 'CODE',
        'COL_CODE' => 'CODE',
        'shop_payment_transactions.code' => 'CODE',
        'Datetime' => 'DATETIME',
        'PaymentTransaction.Datetime' => 'DATETIME',
        'datetime' => 'DATETIME',
        'paymentTransaction.datetime' => 'DATETIME',
        'PaymentTransactionTableMap::COL_DATETIME' => 'DATETIME',
        'COL_DATETIME' => 'DATETIME',
        'shop_payment_transactions.datetime' => 'DATETIME',
        'UDatetime' => 'UDATETIME',
        'PaymentTransaction.UDatetime' => 'UDATETIME',
        'uDatetime' => 'UDATETIME',
        'paymentTransaction.uDatetime' => 'UDATETIME',
        'PaymentTransactionTableMap::COL_UDATETIME' => 'UDATETIME',
        'COL_UDATETIME' => 'UDATETIME',
        'udatetime' => 'UDATETIME',
        'shop_payment_transactions.udatetime' => 'UDATETIME',
        'OrderSumm' => 'ORDER_SUMM',
        'PaymentTransaction.OrderSumm' => 'ORDER_SUMM',
        'orderSumm' => 'ORDER_SUMM',
        'paymentTransaction.orderSumm' => 'ORDER_SUMM',
        'PaymentTransactionTableMap::COL_ORDER_SUMM' => 'ORDER_SUMM',
        'COL_ORDER_SUMM' => 'ORDER_SUMM',
        'order_summ' => 'ORDER_SUMM',
        'shop_payment_transactions.order_summ' => 'ORDER_SUMM',
        'PayedSumm' => 'PAYED_SUMM',
        'PaymentTransaction.PayedSumm' => 'PAYED_SUMM',
        'payedSumm' => 'PAYED_SUMM',
        'paymentTransaction.payedSumm' => 'PAYED_SUMM',
        'PaymentTransactionTableMap::COL_PAYED_SUMM' => 'PAYED_SUMM',
        'COL_PAYED_SUMM' => 'PAYED_SUMM',
        'payed_summ' => 'PAYED_SUMM',
        'shop_payment_transactions.payed_summ' => 'PAYED_SUMM',
        'Confirmed' => 'CONFIRMED',
        'PaymentTransaction.Confirmed' => 'CONFIRMED',
        'confirmed' => 'CONFIRMED',
        'paymentTransaction.confirmed' => 'CONFIRMED',
        'PaymentTransactionTableMap::COL_CONFIRMED' => 'CONFIRMED',
        'COL_CONFIRMED' => 'CONFIRMED',
        'shop_payment_transactions.confirmed' => 'CONFIRMED',
        'Result' => 'RESULT',
        'PaymentTransaction.Result' => 'RESULT',
        'result' => 'RESULT',
        'paymentTransaction.result' => 'RESULT',
        'PaymentTransactionTableMap::COL_RESULT' => 'RESULT',
        'COL_RESULT' => 'RESULT',
        'shop_payment_transactions.result' => 'RESULT',
        'Desc' => 'DESC',
        'PaymentTransaction.Desc' => 'DESC',
        'desc' => 'DESC',
        'paymentTransaction.desc' => 'DESC',
        'PaymentTransactionTableMap::COL_DESC' => 'DESC',
        'COL_DESC' => 'DESC',
        'shop_payment_transactions.desc' => 'DESC',
        'Commission' => 'COMMISSION',
        'PaymentTransaction.Commission' => 'COMMISSION',
        'commission' => 'COMMISSION',
        'paymentTransaction.commission' => 'COMMISSION',
        'PaymentTransactionTableMap::COL_COMMISSION' => 'COMMISSION',
        'COL_COMMISSION' => 'COMMISSION',
        'shop_payment_transactions.commission' => 'COMMISSION',
        'OrderId' => 'ORDER_ID',
        'PaymentTransaction.OrderId' => 'ORDER_ID',
        'orderId' => 'ORDER_ID',
        'paymentTransaction.orderId' => 'ORDER_ID',
        'PaymentTransactionTableMap::COL_ORDER_ID' => 'ORDER_ID',
        'COL_ORDER_ID' => 'ORDER_ID',
        'order_id' => 'ORDER_ID',
        'shop_payment_transactions.order_id' => 'ORDER_ID',
        'Currency' => 'CURRENCY',
        'PaymentTransaction.Currency' => 'CURRENCY',
        'currency' => 'CURRENCY',
        'paymentTransaction.currency' => 'CURRENCY',
        'PaymentTransactionTableMap::COL_CURRENCY' => 'CURRENCY',
        'COL_CURRENCY' => 'CURRENCY',
        'shop_payment_transactions.currency' => 'CURRENCY',
    ];

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function initialize(): void
    {
        // attributes
        $this->setName('shop_payment_transactions');
        $this->setPhpName('PaymentTransaction');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Shop\\Infrastructure\\Models\\PaymentTransaction\\PaymentTransaction');
        $this->setPackage('Shop.Infrastructure.Models.PaymentTransaction');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('code', 'Code', 'VARCHAR', false, 100, null);
        $this->addColumn('datetime', 'Datetime', 'TIMESTAMP', true, null, 'CURRENT_TIMESTAMP');
        $this->addColumn('udatetime', 'UDatetime', 'TIMESTAMP', false, null, null);
        $this->addColumn('order_summ', 'OrderSumm', 'DECIMAL', false, 19, 0.00);
        $this->addColumn('payed_summ', 'PayedSumm', 'DECIMAL', false, 19, 0.00);
        $this->addColumn('confirmed', 'Confirmed', 'CHAR', true, null, 'N');
        $this->addColumn('result', 'Result', 'VARCHAR', false, 100, null);
        $this->addColumn('desc', 'Desc', 'VARCHAR', false, 255, null);
        $this->addColumn('commission', 'Commission', 'DECIMAL', false, 19, 0.00);
        $this->addForeignKey('order_id', 'OrderId', 'INTEGER', 'shop_orders', 'id', false, null, null);
        $this->addColumn('currency', 'Currency', 'CHAR', false, 10, null);
    }

    /**
     * Build the RelationMap objects for this table relationships
     *
     * @return void
     */
    public function buildRelations(): void
    {
        $this->addRelation('Order', '\\Shop\\Infrastructure\\Models\\Order\\Order', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':order_id',
    1 => ':id',
  ),
), null, null, null, false);
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string|null The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): ?string
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param bool $withPrefix Whether to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass(bool $withPrefix = true): string
    {
        return $withPrefix ? PaymentTransactionTableMap::CLASS_DEFAULT : PaymentTransactionTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array $row Row returned by DataFetcher->fetch().
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array (PaymentTransaction object, last column rank)
     */
    public static function populateObject(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): array
    {
        $key = PaymentTransactionTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = PaymentTransactionTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + PaymentTransactionTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = PaymentTransactionTableMap::OM_CLASS;
            /** @var PaymentTransaction $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            PaymentTransactionTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array<object>
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher): array
    {
        $results = [];

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = PaymentTransactionTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = PaymentTransactionTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var PaymentTransaction $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                PaymentTransactionTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria Object containing the columns to add.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function addSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->addSelectColumn(PaymentTransactionTableMap::COL_ID);
            $criteria->addSelectColumn(PaymentTransactionTableMap::COL_CODE);
            $criteria->addSelectColumn(PaymentTransactionTableMap::COL_DATETIME);
            $criteria->addSelectColumn(PaymentTransactionTableMap::COL_UDATETIME);
            $criteria->addSelectColumn(PaymentTransactionTableMap::COL_ORDER_SUMM);
            $criteria->addSelectColumn(PaymentTransactionTableMap::COL_PAYED_SUMM);
            $criteria->addSelectColumn(PaymentTransactionTableMap::COL_CONFIRMED);
            $criteria->addSelectColumn(PaymentTransactionTableMap::COL_RESULT);
            $criteria->addSelectColumn(PaymentTransactionTableMap::COL_DESC);
            $criteria->addSelectColumn(PaymentTransactionTableMap::COL_COMMISSION);
            $criteria->addSelectColumn(PaymentTransactionTableMap::COL_ORDER_ID);
            $criteria->addSelectColumn(PaymentTransactionTableMap::COL_CURRENCY);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.code');
            $criteria->addSelectColumn($alias . '.datetime');
            $criteria->addSelectColumn($alias . '.udatetime');
            $criteria->addSelectColumn($alias . '.order_summ');
            $criteria->addSelectColumn($alias . '.payed_summ');
            $criteria->addSelectColumn($alias . '.confirmed');
            $criteria->addSelectColumn($alias . '.result');
            $criteria->addSelectColumn($alias . '.desc');
            $criteria->addSelectColumn($alias . '.commission');
            $criteria->addSelectColumn($alias . '.order_id');
            $criteria->addSelectColumn($alias . '.currency');
        }
    }

    /**
     * Remove all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be removed as they are only loaded on demand.
     *
     * @param Criteria $criteria Object containing the columns to remove.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function removeSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->removeSelectColumn(PaymentTransactionTableMap::COL_ID);
            $criteria->removeSelectColumn(PaymentTransactionTableMap::COL_CODE);
            $criteria->removeSelectColumn(PaymentTransactionTableMap::COL_DATETIME);
            $criteria->removeSelectColumn(PaymentTransactionTableMap::COL_UDATETIME);
            $criteria->removeSelectColumn(PaymentTransactionTableMap::COL_ORDER_SUMM);
            $criteria->removeSelectColumn(PaymentTransactionTableMap::COL_PAYED_SUMM);
            $criteria->removeSelectColumn(PaymentTransactionTableMap::COL_CONFIRMED);
            $criteria->removeSelectColumn(PaymentTransactionTableMap::COL_RESULT);
            $criteria->removeSelectColumn(PaymentTransactionTableMap::COL_DESC);
            $criteria->removeSelectColumn(PaymentTransactionTableMap::COL_COMMISSION);
            $criteria->removeSelectColumn(PaymentTransactionTableMap::COL_ORDER_ID);
            $criteria->removeSelectColumn(PaymentTransactionTableMap::COL_CURRENCY);
        } else {
            $criteria->removeSelectColumn($alias . '.id');
            $criteria->removeSelectColumn($alias . '.code');
            $criteria->removeSelectColumn($alias . '.datetime');
            $criteria->removeSelectColumn($alias . '.udatetime');
            $criteria->removeSelectColumn($alias . '.order_summ');
            $criteria->removeSelectColumn($alias . '.payed_summ');
            $criteria->removeSelectColumn($alias . '.confirmed');
            $criteria->removeSelectColumn($alias . '.result');
            $criteria->removeSelectColumn($alias . '.desc');
            $criteria->removeSelectColumn($alias . '.commission');
            $criteria->removeSelectColumn($alias . '.order_id');
            $criteria->removeSelectColumn($alias . '.currency');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap(): TableMap
    {
        return Propel::getServiceContainer()->getDatabaseMap(PaymentTransactionTableMap::DATABASE_NAME)->getTable(PaymentTransactionTableMap::TABLE_NAME);
    }

    /**
     * Performs a DELETE on the database, given a PaymentTransaction or Criteria object OR a primary key value.
     *
     * @param mixed $values Criteria or PaymentTransaction object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ?ConnectionInterface $con = null): int
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(PaymentTransactionTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Shop\Infrastructure\Models\PaymentTransaction\PaymentTransaction) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(PaymentTransactionTableMap::DATABASE_NAME);
            $criteria->add(PaymentTransactionTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = PaymentTransactionQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            PaymentTransactionTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                PaymentTransactionTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the shop_payment_transactions table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(?ConnectionInterface $con = null): int
    {
        return PaymentTransactionQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a PaymentTransaction or Criteria object.
     *
     * @param mixed $criteria Criteria or PaymentTransaction object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed The new primary key.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(PaymentTransactionTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from PaymentTransaction object
        }

        if ($criteria->containsKey(PaymentTransactionTableMap::COL_ID) && $criteria->keyContainsValue(PaymentTransactionTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.PaymentTransactionTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = PaymentTransactionQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

}
