<?php declare(strict_types=1);

namespace Shop\Application\Catalog\UpdateProductPositions;

use Shop\Domain\Product\Contracts\ProductEntityInterface;

class UpdateProductPositionsCommand
{


    public function __construct(protected ProductEntityInterface $product, private array $positionCollection)
    {
    }

    public function getProduct(): ProductEntityInterface
    {
        return $this->product;
    }

    public function getPositionCollection(): array
    {
        return $this->positionCollection;
    }

}