<?php

namespace Shop\Presentation\Modules\AdminCategoriesLite;

use ActiveTable\ColumnTable;
use ActiveTable\DataTableEngine;
use Core\ModuleController;
use Shop\Domain\ProductCategory\Contracts\ProductCategoryEntityInterface;
use Shop\Presentation\Modules\AdminCategories\AdminCategories;
use Shop\Presentation\Modules\Traits\FormatterTrait;

/**
 * Description of AdminCategoriesLite
 *
 * @author Diamond Code Generator
 */
class AdminCategoriesLite extends AdminCategories
{

    use FormatterTrait;

    protected function prepareColumns(DataTableEngine $table): void
    {
        $table
            ->removeControlAccess(DataTableEngine::CONTROL_ROWS_SELECT)
            ->removeControlAccess(DataTableEngine::CONTROL_ROWS_ACTION)
            ->addColumn(
                (new ColumnTable('id', '№'))->setWidth(40)
            )
//            ->addColumn(
//                (new ColumnTable('parent', 'Родитель'))
//                    ->setFormat($this, 'formatParent')
//                    ->setWidth(10, true)
//            )
            ->addColumn(
                (new ColumnTable('title', 'Наименование'))
                    ->setFormat($this, 'formatTitle')
            )
            ->addColumn(
                (new ColumnTable('alias', 'Псевдоним'))
            )
            ->addColumn(
                (new ColumnTable('image', 'Изображение'))
            )
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setWidth(120)
                    ->setFormat($this, 'formatSelect')
            );
    }

    /**
     * @param ProductCategoryEntityInterface $model
     * @return string
     */
    public function formatSelect(ProductCategoryEntityInterface $model): string
    {
        return $this->formatRowSelect($model->getTitle(),'categoryId',$model->getId());
    }
}               