<?php declare(strict_types=1);

namespace Shop\Presentation\Controllers;

use Symfony\Component\HttpFoundation\JsonResponse;

class SiteController extends RestController
{
    use ClientApiKeyTrait;


    public function startUpdate():JsonResponse
    {
        $this->validateToken();

        $redis = $this->getConnection();

        $redis->set('SITE_UPDATE','1','EX',  3600 * 120);

        return $this->buildSuccessUpdate();
    }
    public function deleteUpdate():JsonResponse
    {
        $this->validateToken();

        $redis = $this->getConnection();

        $redis->del('SITE_UPDATE');

        return $this->buildSuccessUpdate();
    }


    protected function getConnection() : \Predis\Client
    {
        $redisClientSingleton= new \Predis\Client([
            'host'   => getenv('REDIS_HOST'),
            'port'   => getenv('REDIS_PORT'),
        ]);
        $redisClientSingleton->select(0);
        return $redisClientSingleton;
    }
}