<?php


namespace Shop\Infrastructure\Repositories\Country;


use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;
use Shop\Domain\Country\CountryCollection;
use Shop\Infrastructure\Models\Country\Country;
use Shop\Infrastructure\Models\Country\CountryQuery;

class CountryRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    public static function createEntity(): EntityInterface
    {
        return new Country();
    }

    protected function createQuery(): ModelCriteria
    {
        return CountryQuery::create();
    }

    /**
     * @param PaginationInterface|CountryCriteria $criteria
     * @param ModelCriteria|CountryQuery $dbCriteria
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {

        $dbCriteria
            ->_if($criteria->getFilterByCode()!==null)
            ->filterByCode($criteria->getFilterByCode())
            ->_endif()
            ->_if($criteria->getSearchByName()!==null)
            ->filterByName('%'.$criteria->getSearchByName().'%',Criteria::LIKE)
            ->_endif()
        ;
    }
    

    protected function createCollection(): CollectionInterface
    {
        return new CountryCollection();
    }
}