<?php

namespace Shop\Infrastructure\Models\Currency\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Infrastructure\Models\Currency\Currency as ChildCurrency;
use Shop\Infrastructure\Models\Currency\CurrencyQuery as ChildCurrencyQuery;
use Shop\Infrastructure\Models\Currency\ShopCurrenciesArchive as ChildShopCurrenciesArchive;
use Shop\Infrastructure\Models\Currency\Map\CurrencyTableMap;
use Shop\Infrastructure\Models\OrderItem\OrderItem;
use Shop\Infrastructure\Models\PricelistSheet\PricelistSheet;
use Shop\Infrastructure\Models\Provider\Provider;

/**
 * Base class that represents a query for the 'shop_currencies' table.
 *
 *
 *
 * @method     ChildCurrencyQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildCurrencyQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method     ChildCurrencyQuery orderByNative($order = Criteria::ASC) Order by the native column
 * @method     ChildCurrencyQuery orderByPosition($order = Criteria::ASC) Order by the position column
 * @method     ChildCurrencyQuery orderByHtmlSign($order = Criteria::ASC) Order by the html_sign column
 * @method     ChildCurrencyQuery orderByRoundPrice($order = Criteria::ASC) Order by the round_price column
 * @method     ChildCurrencyQuery orderByDisplayed($order = Criteria::ASC) Order by the displayed column
 * @method     ChildCurrencyQuery orderByIso($order = Criteria::ASC) Order by the iso column
 * @method     ChildCurrencyQuery orderByRbkSync($order = Criteria::ASC) Order by the rbk_sync column
 * @method     ChildCurrencyQuery orderByRoundMode($order = Criteria::ASC) Order by the round_mode column
 *
 * @method     ChildCurrencyQuery groupById() Group by the id column
 * @method     ChildCurrencyQuery groupByName() Group by the name column
 * @method     ChildCurrencyQuery groupByNative() Group by the native column
 * @method     ChildCurrencyQuery groupByPosition() Group by the position column
 * @method     ChildCurrencyQuery groupByHtmlSign() Group by the html_sign column
 * @method     ChildCurrencyQuery groupByRoundPrice() Group by the round_price column
 * @method     ChildCurrencyQuery groupByDisplayed() Group by the displayed column
 * @method     ChildCurrencyQuery groupByIso() Group by the iso column
 * @method     ChildCurrencyQuery groupByRbkSync() Group by the rbk_sync column
 * @method     ChildCurrencyQuery groupByRoundMode() Group by the round_mode column
 *
 * @method     ChildCurrencyQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildCurrencyQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildCurrencyQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildCurrencyQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildCurrencyQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildCurrencyQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildCurrencyQuery leftJoinOrderItem($relationAlias = null) Adds a LEFT JOIN clause to the query using the OrderItem relation
 * @method     ChildCurrencyQuery rightJoinOrderItem($relationAlias = null) Adds a RIGHT JOIN clause to the query using the OrderItem relation
 * @method     ChildCurrencyQuery innerJoinOrderItem($relationAlias = null) Adds a INNER JOIN clause to the query using the OrderItem relation
 *
 * @method     ChildCurrencyQuery joinWithOrderItem($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the OrderItem relation
 *
 * @method     ChildCurrencyQuery leftJoinWithOrderItem() Adds a LEFT JOIN clause and with to the query using the OrderItem relation
 * @method     ChildCurrencyQuery rightJoinWithOrderItem() Adds a RIGHT JOIN clause and with to the query using the OrderItem relation
 * @method     ChildCurrencyQuery innerJoinWithOrderItem() Adds a INNER JOIN clause and with to the query using the OrderItem relation
 *
 * @method     ChildCurrencyQuery leftJoinPricelistSheet($relationAlias = null) Adds a LEFT JOIN clause to the query using the PricelistSheet relation
 * @method     ChildCurrencyQuery rightJoinPricelistSheet($relationAlias = null) Adds a RIGHT JOIN clause to the query using the PricelistSheet relation
 * @method     ChildCurrencyQuery innerJoinPricelistSheet($relationAlias = null) Adds a INNER JOIN clause to the query using the PricelistSheet relation
 *
 * @method     ChildCurrencyQuery joinWithPricelistSheet($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the PricelistSheet relation
 *
 * @method     ChildCurrencyQuery leftJoinWithPricelistSheet() Adds a LEFT JOIN clause and with to the query using the PricelistSheet relation
 * @method     ChildCurrencyQuery rightJoinWithPricelistSheet() Adds a RIGHT JOIN clause and with to the query using the PricelistSheet relation
 * @method     ChildCurrencyQuery innerJoinWithPricelistSheet() Adds a INNER JOIN clause and with to the query using the PricelistSheet relation
 *
 * @method     ChildCurrencyQuery leftJoinProvider($relationAlias = null) Adds a LEFT JOIN clause to the query using the Provider relation
 * @method     ChildCurrencyQuery rightJoinProvider($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Provider relation
 * @method     ChildCurrencyQuery innerJoinProvider($relationAlias = null) Adds a INNER JOIN clause to the query using the Provider relation
 *
 * @method     ChildCurrencyQuery joinWithProvider($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Provider relation
 *
 * @method     ChildCurrencyQuery leftJoinWithProvider() Adds a LEFT JOIN clause and with to the query using the Provider relation
 * @method     ChildCurrencyQuery rightJoinWithProvider() Adds a RIGHT JOIN clause and with to the query using the Provider relation
 * @method     ChildCurrencyQuery innerJoinWithProvider() Adds a INNER JOIN clause and with to the query using the Provider relation
 *
 * @method     \Shop\Infrastructure\Models\OrderItem\OrderItemQuery|\Shop\Infrastructure\Models\PricelistSheet\PricelistSheetQuery|\Shop\Infrastructure\Models\Provider\ProviderQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildCurrency|null findOne(?ConnectionInterface $con = null) Return the first ChildCurrency matching the query
 * @method     ChildCurrency findOneOrCreate(?ConnectionInterface $con = null) Return the first ChildCurrency matching the query, or a new ChildCurrency object populated from the query conditions when no match is found
 *
 * @method     ChildCurrency|null findOneById(int $id) Return the first ChildCurrency filtered by the id column
 * @method     ChildCurrency|null findOneByName(string $name) Return the first ChildCurrency filtered by the name column
 * @method     ChildCurrency|null findOneByNative(string $native) Return the first ChildCurrency filtered by the native column
 * @method     ChildCurrency|null findOneByPosition(int $position) Return the first ChildCurrency filtered by the position column
 * @method     ChildCurrency|null findOneByHtmlSign(string $html_sign) Return the first ChildCurrency filtered by the html_sign column
 * @method     ChildCurrency|null findOneByRoundPrice(int $round_price) Return the first ChildCurrency filtered by the round_price column
 * @method     ChildCurrency|null findOneByDisplayed(string $displayed) Return the first ChildCurrency filtered by the displayed column
 * @method     ChildCurrency|null findOneByIso(string $iso) Return the first ChildCurrency filtered by the iso column
 * @method     ChildCurrency|null findOneByRbkSync(string $rbk_sync) Return the first ChildCurrency filtered by the rbk_sync column
 * @method     ChildCurrency|null findOneByRoundMode(string $round_mode) Return the first ChildCurrency filtered by the round_mode column *

 * @method     ChildCurrency requirePk($key, ?ConnectionInterface $con = null) Return the ChildCurrency by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCurrency requireOne(?ConnectionInterface $con = null) Return the first ChildCurrency matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildCurrency requireOneById(int $id) Return the first ChildCurrency filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCurrency requireOneByName(string $name) Return the first ChildCurrency filtered by the name column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCurrency requireOneByNative(string $native) Return the first ChildCurrency filtered by the native column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCurrency requireOneByPosition(int $position) Return the first ChildCurrency filtered by the position column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCurrency requireOneByHtmlSign(string $html_sign) Return the first ChildCurrency filtered by the html_sign column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCurrency requireOneByRoundPrice(int $round_price) Return the first ChildCurrency filtered by the round_price column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCurrency requireOneByDisplayed(string $displayed) Return the first ChildCurrency filtered by the displayed column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCurrency requireOneByIso(string $iso) Return the first ChildCurrency filtered by the iso column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCurrency requireOneByRbkSync(string $rbk_sync) Return the first ChildCurrency filtered by the rbk_sync column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCurrency requireOneByRoundMode(string $round_mode) Return the first ChildCurrency filtered by the round_mode column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildCurrency[]|Collection find(?ConnectionInterface $con = null) Return ChildCurrency objects based on current ModelCriteria
 * @psalm-method Collection&\Traversable<ChildCurrency> find(?ConnectionInterface $con = null) Return ChildCurrency objects based on current ModelCriteria
 * @method     ChildCurrency[]|Collection findById(int $id) Return ChildCurrency objects filtered by the id column
 * @psalm-method Collection&\Traversable<ChildCurrency> findById(int $id) Return ChildCurrency objects filtered by the id column
 * @method     ChildCurrency[]|Collection findByName(string $name) Return ChildCurrency objects filtered by the name column
 * @psalm-method Collection&\Traversable<ChildCurrency> findByName(string $name) Return ChildCurrency objects filtered by the name column
 * @method     ChildCurrency[]|Collection findByNative(string $native) Return ChildCurrency objects filtered by the native column
 * @psalm-method Collection&\Traversable<ChildCurrency> findByNative(string $native) Return ChildCurrency objects filtered by the native column
 * @method     ChildCurrency[]|Collection findByPosition(int $position) Return ChildCurrency objects filtered by the position column
 * @psalm-method Collection&\Traversable<ChildCurrency> findByPosition(int $position) Return ChildCurrency objects filtered by the position column
 * @method     ChildCurrency[]|Collection findByHtmlSign(string $html_sign) Return ChildCurrency objects filtered by the html_sign column
 * @psalm-method Collection&\Traversable<ChildCurrency> findByHtmlSign(string $html_sign) Return ChildCurrency objects filtered by the html_sign column
 * @method     ChildCurrency[]|Collection findByRoundPrice(int $round_price) Return ChildCurrency objects filtered by the round_price column
 * @psalm-method Collection&\Traversable<ChildCurrency> findByRoundPrice(int $round_price) Return ChildCurrency objects filtered by the round_price column
 * @method     ChildCurrency[]|Collection findByDisplayed(string $displayed) Return ChildCurrency objects filtered by the displayed column
 * @psalm-method Collection&\Traversable<ChildCurrency> findByDisplayed(string $displayed) Return ChildCurrency objects filtered by the displayed column
 * @method     ChildCurrency[]|Collection findByIso(string $iso) Return ChildCurrency objects filtered by the iso column
 * @psalm-method Collection&\Traversable<ChildCurrency> findByIso(string $iso) Return ChildCurrency objects filtered by the iso column
 * @method     ChildCurrency[]|Collection findByRbkSync(string $rbk_sync) Return ChildCurrency objects filtered by the rbk_sync column
 * @psalm-method Collection&\Traversable<ChildCurrency> findByRbkSync(string $rbk_sync) Return ChildCurrency objects filtered by the rbk_sync column
 * @method     ChildCurrency[]|Collection findByRoundMode(string $round_mode) Return ChildCurrency objects filtered by the round_mode column
 * @psalm-method Collection&\Traversable<ChildCurrency> findByRoundMode(string $round_mode) Return ChildCurrency objects filtered by the round_mode column
 * @method     ChildCurrency[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 * @psalm-method \Propel\Runtime\Util\PropelModelPager&\Traversable<ChildCurrency> paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class CurrencyQuery extends ModelCriteria
{

    // archivable behavior
    protected $archiveOnDelete = true;
protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Infrastructure\Models\Currency\Base\CurrencyQuery object.
     *
     * @param string $dbName The database name
     * @param string $modelName The phpName of a model, e.g. 'Book'
     * @param string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Infrastructure\\Models\\Currency\\Currency', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildCurrencyQuery object.
     *
     * @param string $modelAlias The alias of a model in the query
     * @param Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildCurrencyQuery
     */
    public static function create(?string $modelAlias = null, ?Criteria $criteria = null): Criteria
    {
        if ($criteria instanceof ChildCurrencyQuery) {
            return $criteria;
        }
        $query = new ChildCurrencyQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildCurrency|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ?ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(CurrencyTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = CurrencyTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildCurrency A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `name`, `native`, `position`, `html_sign`, `round_price`, `displayed`, `iso`, `rbk_sync`, `round_mode` FROM `shop_currencies` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildCurrency $obj */
            $obj = new ChildCurrency();
            $obj->hydrate($row);
            CurrencyTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @return ChildCurrency|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param array $keys Primary keys to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return Collection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param mixed $key Primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        $this->addUsingAlias(CurrencyTableMap::COL_ID, $key, Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param array|int $keys The list of primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        $this->addUsingAlias(CurrencyTableMap::COL_ID, $keys, Criteria::IN);

        return $this;
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterById($id = null, ?string $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(CurrencyTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(CurrencyTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CurrencyTableMap::COL_ID, $id, $comparison);

        return $this;
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%', Criteria::LIKE); // WHERE name LIKE '%fooValue%'
     * $query->filterByName(['foo', 'bar']); // WHERE name IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $name The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByName($name = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CurrencyTableMap::COL_NAME, $name, $comparison);

        return $this;
    }

    /**
     * Filter the query on the native column
     *
     * Example usage:
     * <code>
     * $query->filterByNative('fooValue');   // WHERE native = 'fooValue'
     * $query->filterByNative('%fooValue%', Criteria::LIKE); // WHERE native LIKE '%fooValue%'
     * $query->filterByNative(['foo', 'bar']); // WHERE native IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $native The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByNative($native = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($native)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CurrencyTableMap::COL_NATIVE, $native, $comparison);

        return $this;
    }

    /**
     * Filter the query on the position column
     *
     * Example usage:
     * <code>
     * $query->filterByPosition(1234); // WHERE position = 1234
     * $query->filterByPosition(array(12, 34)); // WHERE position IN (12, 34)
     * $query->filterByPosition(array('min' => 12)); // WHERE position > 12
     * </code>
     *
     * @param mixed $position The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPosition($position = null, ?string $comparison = null)
    {
        if (is_array($position)) {
            $useMinMax = false;
            if (isset($position['min'])) {
                $this->addUsingAlias(CurrencyTableMap::COL_POSITION, $position['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($position['max'])) {
                $this->addUsingAlias(CurrencyTableMap::COL_POSITION, $position['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CurrencyTableMap::COL_POSITION, $position, $comparison);

        return $this;
    }

    /**
     * Filter the query on the html_sign column
     *
     * Example usage:
     * <code>
     * $query->filterByHtmlSign('fooValue');   // WHERE html_sign = 'fooValue'
     * $query->filterByHtmlSign('%fooValue%', Criteria::LIKE); // WHERE html_sign LIKE '%fooValue%'
     * $query->filterByHtmlSign(['foo', 'bar']); // WHERE html_sign IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $htmlSign The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByHtmlSign($htmlSign = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($htmlSign)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CurrencyTableMap::COL_HTML_SIGN, $htmlSign, $comparison);

        return $this;
    }

    /**
     * Filter the query on the round_price column
     *
     * Example usage:
     * <code>
     * $query->filterByRoundPrice(1234); // WHERE round_price = 1234
     * $query->filterByRoundPrice(array(12, 34)); // WHERE round_price IN (12, 34)
     * $query->filterByRoundPrice(array('min' => 12)); // WHERE round_price > 12
     * </code>
     *
     * @param mixed $roundPrice The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByRoundPrice($roundPrice = null, ?string $comparison = null)
    {
        if (is_array($roundPrice)) {
            $useMinMax = false;
            if (isset($roundPrice['min'])) {
                $this->addUsingAlias(CurrencyTableMap::COL_ROUND_PRICE, $roundPrice['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($roundPrice['max'])) {
                $this->addUsingAlias(CurrencyTableMap::COL_ROUND_PRICE, $roundPrice['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CurrencyTableMap::COL_ROUND_PRICE, $roundPrice, $comparison);

        return $this;
    }

    /**
     * Filter the query on the displayed column
     *
     * Example usage:
     * <code>
     * $query->filterByDisplayed('fooValue');   // WHERE displayed = 'fooValue'
     * $query->filterByDisplayed('%fooValue%', Criteria::LIKE); // WHERE displayed LIKE '%fooValue%'
     * $query->filterByDisplayed(['foo', 'bar']); // WHERE displayed IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $displayed The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByDisplayed($displayed = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($displayed)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CurrencyTableMap::COL_DISPLAYED, $displayed, $comparison);

        return $this;
    }

    /**
     * Filter the query on the iso column
     *
     * Example usage:
     * <code>
     * $query->filterByIso('fooValue');   // WHERE iso = 'fooValue'
     * $query->filterByIso('%fooValue%', Criteria::LIKE); // WHERE iso LIKE '%fooValue%'
     * $query->filterByIso(['foo', 'bar']); // WHERE iso IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $iso The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByIso($iso = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($iso)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CurrencyTableMap::COL_ISO, $iso, $comparison);

        return $this;
    }

    /**
     * Filter the query on the rbk_sync column
     *
     * Example usage:
     * <code>
     * $query->filterByRbkSync('fooValue');   // WHERE rbk_sync = 'fooValue'
     * $query->filterByRbkSync('%fooValue%', Criteria::LIKE); // WHERE rbk_sync LIKE '%fooValue%'
     * $query->filterByRbkSync(['foo', 'bar']); // WHERE rbk_sync IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $rbkSync The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByRbkSync($rbkSync = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($rbkSync)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CurrencyTableMap::COL_RBK_SYNC, $rbkSync, $comparison);

        return $this;
    }

    /**
     * Filter the query on the round_mode column
     *
     * Example usage:
     * <code>
     * $query->filterByRoundMode('fooValue');   // WHERE round_mode = 'fooValue'
     * $query->filterByRoundMode('%fooValue%', Criteria::LIKE); // WHERE round_mode LIKE '%fooValue%'
     * $query->filterByRoundMode(['foo', 'bar']); // WHERE round_mode IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $roundMode The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByRoundMode($roundMode = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($roundMode)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CurrencyTableMap::COL_ROUND_MODE, $roundMode, $comparison);

        return $this;
    }

    /**
     * Filter the query by a related \Shop\Infrastructure\Models\OrderItem\OrderItem object
     *
     * @param \Shop\Infrastructure\Models\OrderItem\OrderItem|ObjectCollection $orderItem the related object to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByOrderItem($orderItem, ?string $comparison = null)
    {
        if ($orderItem instanceof \Shop\Infrastructure\Models\OrderItem\OrderItem) {
            $this
                ->addUsingAlias(CurrencyTableMap::COL_ID, $orderItem->getCurrencyId(), $comparison);

            return $this;
        } elseif ($orderItem instanceof ObjectCollection) {
            $this
                ->useOrderItemQuery()
                ->filterByPrimaryKeys($orderItem->getPrimaryKeys())
                ->endUse();

            return $this;
        } else {
            throw new PropelException('filterByOrderItem() only accepts arguments of type \Shop\Infrastructure\Models\OrderItem\OrderItem or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the OrderItem relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinOrderItem(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('OrderItem');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'OrderItem');
        }

        return $this;
    }

    /**
     * Use the OrderItem relation OrderItem object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\OrderItem\OrderItemQuery A secondary query class using the current class as primary query
     */
    public function useOrderItemQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinOrderItem($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'OrderItem', '\Shop\Infrastructure\Models\OrderItem\OrderItemQuery');
    }

    /**
     * Use the OrderItem relation OrderItem object
     *
     * @param callable(\Shop\Infrastructure\Models\OrderItem\OrderItemQuery):\Shop\Infrastructure\Models\OrderItem\OrderItemQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withOrderItemQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useOrderItemQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to OrderItem table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\OrderItem\OrderItemQuery The inner query object of the EXISTS statement
     */
    public function useOrderItemExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('OrderItem', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to OrderItem table for a NOT EXISTS query.
     *
     * @see useOrderItemExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\OrderItem\OrderItemQuery The inner query object of the NOT EXISTS statement
     */
    public function useOrderItemNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('OrderItem', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Shop\Infrastructure\Models\PricelistSheet\PricelistSheet object
     *
     * @param \Shop\Infrastructure\Models\PricelistSheet\PricelistSheet|ObjectCollection $pricelistSheet the related object to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPricelistSheet($pricelistSheet, ?string $comparison = null)
    {
        if ($pricelistSheet instanceof \Shop\Infrastructure\Models\PricelistSheet\PricelistSheet) {
            $this
                ->addUsingAlias(CurrencyTableMap::COL_ID, $pricelistSheet->getCurrencyId(), $comparison);

            return $this;
        } elseif ($pricelistSheet instanceof ObjectCollection) {
            $this
                ->usePricelistSheetQuery()
                ->filterByPrimaryKeys($pricelistSheet->getPrimaryKeys())
                ->endUse();

            return $this;
        } else {
            throw new PropelException('filterByPricelistSheet() only accepts arguments of type \Shop\Infrastructure\Models\PricelistSheet\PricelistSheet or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the PricelistSheet relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinPricelistSheet(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('PricelistSheet');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'PricelistSheet');
        }

        return $this;
    }

    /**
     * Use the PricelistSheet relation PricelistSheet object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\PricelistSheet\PricelistSheetQuery A secondary query class using the current class as primary query
     */
    public function usePricelistSheetQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinPricelistSheet($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'PricelistSheet', '\Shop\Infrastructure\Models\PricelistSheet\PricelistSheetQuery');
    }

    /**
     * Use the PricelistSheet relation PricelistSheet object
     *
     * @param callable(\Shop\Infrastructure\Models\PricelistSheet\PricelistSheetQuery):\Shop\Infrastructure\Models\PricelistSheet\PricelistSheetQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withPricelistSheetQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->usePricelistSheetQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to PricelistSheet table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\PricelistSheet\PricelistSheetQuery The inner query object of the EXISTS statement
     */
    public function usePricelistSheetExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('PricelistSheet', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to PricelistSheet table for a NOT EXISTS query.
     *
     * @see usePricelistSheetExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\PricelistSheet\PricelistSheetQuery The inner query object of the NOT EXISTS statement
     */
    public function usePricelistSheetNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('PricelistSheet', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Shop\Infrastructure\Models\Provider\Provider object
     *
     * @param \Shop\Infrastructure\Models\Provider\Provider|ObjectCollection $provider the related object to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByProvider($provider, ?string $comparison = null)
    {
        if ($provider instanceof \Shop\Infrastructure\Models\Provider\Provider) {
            $this
                ->addUsingAlias(CurrencyTableMap::COL_ID, $provider->getCurrencyId(), $comparison);

            return $this;
        } elseif ($provider instanceof ObjectCollection) {
            $this
                ->useProviderQuery()
                ->filterByPrimaryKeys($provider->getPrimaryKeys())
                ->endUse();

            return $this;
        } else {
            throw new PropelException('filterByProvider() only accepts arguments of type \Shop\Infrastructure\Models\Provider\Provider or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Provider relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinProvider(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Provider');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Provider');
        }

        return $this;
    }

    /**
     * Use the Provider relation Provider object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\Provider\ProviderQuery A secondary query class using the current class as primary query
     */
    public function useProviderQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProvider($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Provider', '\Shop\Infrastructure\Models\Provider\ProviderQuery');
    }

    /**
     * Use the Provider relation Provider object
     *
     * @param callable(\Shop\Infrastructure\Models\Provider\ProviderQuery):\Shop\Infrastructure\Models\Provider\ProviderQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withProviderQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useProviderQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to Provider table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Shop\Infrastructure\Models\Provider\ProviderQuery The inner query object of the EXISTS statement
     */
    public function useProviderExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('Provider', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to Provider table for a NOT EXISTS query.
     *
     * @see useProviderExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Shop\Infrastructure\Models\Provider\ProviderQuery The inner query object of the NOT EXISTS statement
     */
    public function useProviderNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('Provider', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Exclude object from result
     *
     * @param ChildCurrency $currency Object to remove from the list of results
     *
     * @return $this The current query, for fluid interface
     */
    public function prune($currency = null)
    {
        if ($currency) {
            $this->addUsingAlias(CurrencyTableMap::COL_ID, $currency->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Code to execute before every DELETE statement
     *
     * @param ConnectionInterface $con The connection object used by the query
     * @return int|null
     */
    protected function basePreDelete(ConnectionInterface $con): ?int
    {
        // archivable behavior

        if ($this->archiveOnDelete) {
            $this->archive($con);
        } else {
            $this->archiveOnDelete = true;
        }


        return $this->preDelete($con);
    }

    /**
     * Deletes all rows from the shop_currencies table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(CurrencyTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            CurrencyTableMap::clearInstancePool();
            CurrencyTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(CurrencyTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(CurrencyTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            CurrencyTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            CurrencyTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    // archivable behavior

    /**
     * Copy the data of the objects satisfying the query into ChildShopCurrenciesArchive archive objects.
     * The archived objects are then saved.
     * If any of the objects has already been archived, the archived object
     * is updated and not duplicated.
     * Warning: This termination methods issues 2n+1 queries.
     *
     * @param ConnectionInterface|null $con    Connection to use.
     * @param bool $useLittleMemory Whether to use OnDemandFormatter to retrieve objects.
     *               Set to false if the identity map matters.
     *               Set to true (default) to use less memory.
     *
     * @return int the number of archived objects
     */
    public function archive($con = null, $useLittleMemory = true)
    {
        $criteria = clone $this;
        // prepare the query
        $criteria->setWith(array());
        if ($useLittleMemory) {
            $criteria->setFormatter(ModelCriteria::FORMAT_ON_DEMAND);
        }
        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(CurrencyTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con, $criteria) {
            $totalArchivedObjects = 0;

            // archive all results one by one
            foreach ($criteria->find($con) as $object) {
                $object->archive($con);
                $totalArchivedObjects++;
            }

            return $totalArchivedObjects;
        });
    }

    /**
     * Enable/disable auto-archiving on delete for the next query.
     *
     * @param bool True if the query must archive deleted objects, false otherwise.
     */
    public function setArchiveOnDelete(bool $archiveOnDelete)
    {
        $this->archiveOnDelete = $archiveOnDelete;
    }

    /**
     * Delete records matching the current query without archiving them.
     *
     * @param ConnectionInterface|null $con    Connection to use.
     *
     * @return int The number of deleted rows
     */
    public function deleteWithoutArchive($con = null): int
    {
        $this->archiveOnDelete = false;

        return $this->delete($con);
    }

    /**
     * Delete all records without archiving them.
     *
     * @param ConnectionInterface|null $con    Connection to use.
     *
     * @return int The number of deleted rows
     */
    public function deleteAllWithoutArchive($con = null): int
    {
        $this->archiveOnDelete = false;

        return $this->deleteAll($con);
    }

}
