<?php

namespace Shop\Infrastructure\Models\Catalog;

use Diamond\Domain\Site\Contracts\SiteEntityInterface;
use Diamond\Domain\Site\Contracts\SiteGetterInterface;
use Shop\Domain\Catalog\Contracts\CatalogEntityInterface;
use Shop\Infrastructure\Models\Catalog\Base\Catalog as BaseCatalog;

/**
 * Skeleton subclass for representing a row from the 'shop_catalogs' table.
 *
 *
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 */
class Catalog extends BaseCatalog implements CatalogEntityInterface, SiteGetterInterface
{
    public function getSite(): SiteEntityInterface
    {
        return $this->getDomain();
    }

}
