<?php


namespace Shop\Presentation\UseCases\Checkout;


use Diamond\UseCases\Notification\NotificationException;
use ExportEngine\Exporter;
use Propel\Runtime\Map\TableMap;
use Shop\Application\Shopping\ShoppingService;
use Shop\Presentation\Config\Main;
use Shop\Domain\CustomerOrder\Contracts\CustomerOrderEntityInterface;
use Shop\Domain\CustomerOrder\CustomerOrderCollection;
use Shop\Domain\OrderItem\Contracts\OrderItemEntityInterface;
use Shop\Domain\ProviderOrder\Contracts\ProviderOrderEntityInterface;
use Shop\Domain\ProviderOrder\ProviderOrderCollection;
use Shop\Domain\State\Contracts\StateEntityInterface;
use Shop\Infrastructure\Models\Currency\Currency;
use Shop\Infrastructure\Models\Order\Order;
use Shop\Infrastructure\Models\OrderItem\OrderItem;
use Shop\Infrastructure\Models\OrderType\OrderType;
use Shop\Infrastructure\Models\ProviderOrderItem\ProviderOrderItem;
use Shop\Infrastructure\Models\State\State;
use Shop\Infrastructure\Models\StateLog\StateLog;
use Shop\Infrastructure\Repositories\CustomerOrder\CustomerOrderCriteria;
use Shop\Infrastructure\Repositories\CustomerOrder\CustomerOrderRepository;
use Shop\Infrastructure\Repositories\OrderItem\OrderItemCriteria;
use Shop\Infrastructure\Repositories\OrderItem\OrderItemRepository;
use Shop\Infrastructure\Repositories\ProviderOrder\ProviderOrderRepository;
use Shop\Infrastructure\Repositories\ProviderOrderItem\ProviderOrderItemCriteria;
use Shop\Infrastructure\Repositories\ProviderOrderItem\ProviderOrderItemRepository;
use Shop\Infrastructure\Repositories\State\StateRepository;
use Shop\Infrastructure\Repositories\StateLog\StateLogRepository;
use Shop\Infrastructure\Repositories\Stock\StockRepository;
use Shop\Presentation\UseCases\Checkout\Exceptions\CheckoutException;
use Shop\Presentation\UseCases\Checkout\Exceptions\CreateProviderOrdersException;
use Shop\Presentation\UseCases\Checkout\Exceptions\MergeCountOrdersException;
use Shop\Presentation\UseCases\Checkout\Exceptions\MergeOrdersFoundSomeContractorsException;
use Shop\Presentation\UseCases\Checkout\Exceptions\MergeOrdersFoundSomeCustomerException;
use Shop\Presentation\UseCases\Checkout\Exceptions\SendCustomerOrdersException;
use Shop\Presentation\UseCases\Checkout\Exceptions\SendProviderOrdersException;
use Shop\Presentation\UseCases\Imaging\Imaging;
use Shop\Presentation\UseCases\Notification\Notification;

/**
 * @deprecated
 * Class Checkout
 * @package Shop\Presentation\UseCases\Checkout
 */
class Checkout extends ShoppingService
{
//    protected $stateRepository;
//    protected $itemRepository;
//    protected $stateLogRepository;
//    protected $providerOrderRepository;
//    protected $mainConf;
//    protected $customerOrderRepository;
//    protected $notificationUseCase;
//    protected $stockRepository;
//    protected $imagingUseCase;
//    protected $providerOrderItemRepository;
//
//    /**
//     * Checkout constructor.
//     * @param StateRepository $stateRepository
//     * @param OrderItemRepository $itemRepository
//     * @param ProviderOrderItemRepository $providerOrderItemRepository
//     * @param StateLogRepository $stateLogRepository
//     * @param ProviderOrderRepository $providerOrderRepository
//     * @param CustomerOrderRepository $customerOrderRepository
//     * @param Main $mainConf
//     * @param Notification $notification
//     * @param StockRepository $stockRepository
//     * @param Imaging $imagingUseCase
//     */
//    public function __construct(StateRepository $stateRepository,
//                                OrderItemRepository $itemRepository,
//                                ProviderOrderItemRepository $providerOrderItemRepository,
//                                StateLogRepository $stateLogRepository,
//                                ProviderOrderRepository $providerOrderRepository,
//                                CustomerOrderRepository $customerOrderRepository,
//                                Main $mainConf,
//                                Notification $notification,
//                                StockRepository $stockRepository,
//                                Imaging $imagingUseCase
//    )
//    {
//        $this->stateRepository = $stateRepository;
//        $this->itemRepository = $itemRepository;
//        $this->stateLogRepository = $stateLogRepository;
//        $this->providerOrderRepository = $providerOrderRepository;
//        $this->mainConf = $mainConf;
//        $this->customerOrderRepository = $customerOrderRepository;
//        $this->notificationUseCase = $notification;
//        $this->stockRepository = $stockRepository;
//        $this->imagingUseCase = $imagingUseCase;
//        $this->providerOrderItemRepository = $providerOrderItemRepository;
//    }
//
//
//
//    /**
//     * @deprecated
//     * Создание заказа поставщику от торговой точки
//     * @param OrderRequest $orderRequest
//     * @return ProviderOrderEntityInterface
//     * @throws \Propel\Runtime\Exception\PropelException
//     */
//    public function createProviderOrder(OrderRequest $orderRequest): ProviderOrderEntityInterface
//    {
//
//    }
//
//    /**
//     * @deprecated
//     * @param OrderItemRequest $item
//     * @return OrderItemEntityInterface|OrderItem
//     */
//    protected function buildOrderItem(OrderItemRequest $item): OrderItemEntityInterface
//    {
//
//    }
//
//    /**
//     * @deprecated
//     * Создание заказа клиента к торговой точке
//     * @param OrderRequest $orderRequest
//     * @return CustomerOrderEntityInterface
//     */
//    public function createCustomerOrder(OrderRequest $orderRequest): CustomerOrderEntityInterface
//    {
//
//    }
//
//    /**
//     * @deprecated
//     * @param array $ids
//     * @return ProviderOrderCollection
//     * @throws \Propel\Runtime\Exception\PropelException
//     * @throws \Repo\Concrete\Exceptions\Collection
//     * @throws \Throwable
//     * @throws \Twig\Error\LoaderError
//     * @throws \Twig\Error\RuntimeError
//     * @throws \Twig\Error\SyntaxError
//     */
//    public function sendProviderOrdersByIds(array $ids): ProviderOrderCollection
//    {
//
//    }
//
//    /**
//     * @deprecated
//     * @param ProviderOrderEntityInterface $order
//     * @return array
//     */
//    public function prepareProviderOrderDataForReport(ProviderOrderEntityInterface $order): array
//    {
//
//    }
//
//    /**
//     * @deprecated
//     * Отправка уведомление о заказе клиентам заказов
//     * @param array $ids
//     * @param bool $notifyCustomer
//     * @param bool $notifyManager
//     * @return CustomerOrderCollection
//     * @throws \Propel\Runtime\Exception\PropelException
//     * @throws \Repo\Concrete\Exceptions\Collection
//     * @throws \Twig\Error\LoaderError
//     * @throws \Twig\Error\RuntimeError
//     * @throws \Twig\Error\SyntaxError
//     */
//    public function sendCustomerOrdersByIds(array $ids, $notifyCustomer = true, $notifyManager = true): CustomerOrderCollection
//    {
//
//    }
//
//    /**
//     * @deprecated
//     * Подгтовка данных для отчета по заказу
//     * @param CustomerOrderEntityInterface $order
//     * @return array
//     */
//    public function prepareCustomerOrderDataForReport(CustomerOrderEntityInterface $order): array
//    {
//
//    }
//
//    /**
//     * @deprecated
//     * @param array $items
//     * @return string
//     */
//    public function createFileFromOrderItems(array $items, string $fileName):string{
//
//
//
//        return $link;
//    }
}