<?php


namespace Shop\Presentation\Modules\AdminOrders;


use Core\Form\ControlBuilder;
use Core\Helpers\Date;
use Diamond\Helpers\Form;
use Shop\Domain\CustomerOrder\Contracts\CustomerOrderEntityInterface;
use Shop\Presentation\Helpers\Formatter;
use Shop\Presentation\Helpers\Price;
use Shop\Presentation\Helpers\State;
use Shop\Infrastructure\Models\Order\Order;

/**
 * Trait FormatTrait
 * @package Shop\Presentation\Modules\AdminOrders
 */
trait FormatTrait
{


    public function formatNum(\Shop\Infrastructure\Models\OrderItem\OrderItem $item)
    {
        $this->num++;
        return $this->num;
    }

    /**
     * @param CustomerOrderEntityInterface $order
     * @return string
     */
    public function formatCode(CustomerOrderEntityInterface $order)
    {
        return sprintf('<nobr>%s</nobr>', $order->getOrderCode());
    }

    /**
     * @param CustomerOrderEntityInterface $order
     * @return mixed
     */
    public function formatShop(CustomerOrderEntityInterface $order)
    {
        if(!$order->getContractor()){
            return \Shop\Presentation\Helpers\Form::buildIcon('alert');
        }
        return $order->getContractor()->getName();
    }

    /**
     * @param CustomerOrderEntityInterface $order
     * @return mixed
     */
    public function formatDate(CustomerOrderEntityInterface $order)
    {
        return sprintf('<nobr>%s</nobr>', $order->getDatetime(Date::formatDisplay()));
    }


    /**
     * @param CustomerOrderEntityInterface $order
     * @return string
     */
    public function formatClientFull(CustomerOrderEntityInterface $order): string
    {
        return sprintf('%s,<br/>группа: %s',
            $order->getCustomer()->getName(),
            $order->getCustomer()->getCustomerGroup()->getName()
        );
    }

    /**
     * @param CustomerOrderEntityInterface $order
     * @return string
     */
    public function formatClientContacts(CustomerOrderEntityInterface $order): string
    {
        return sprintf('email: %s,<br/>телефон: %s',
            $order->getCustomer()->getEmail(),
            $order->getCustomer()->getPhone()
        );
    }

    /**
     * @param CustomerOrderEntityInterface $order
     * @return string
     */
    public function formatManager(CustomerOrderEntityInterface $order): string
    {
        $manager = $order->getCustomer()->getManager();
        return sprintf('%s [%s]',
            $manager->getName(), $manager->getEmail()
        );
    }

    /**
     * @param CustomerOrderEntityInterface $order
     * @return string
     */
    public function formatStock(CustomerOrderEntityInterface $order): string
    {
        return $order->getContractor()->getName();
    }


    /**
     * @param CustomerOrderEntityInterface $order
     * @return string
     */
    public function formatPayment(CustomerOrderEntityInterface $order): string
    {
        return $order->getPayment()->getTitle();
    }

    /**
     * @param CustomerOrderEntityInterface $order
     * @return string
     */
    public function formatItemsCount(CustomerOrderEntityInterface $order): string
    {
        return (string)$order->getItemsCount();
    }

    /**
     * @param CustomerOrderEntityInterface $order
     * @return string
     */
    public function formatSumm(CustomerOrderEntityInterface $order): string
    {
        return '<nobr>' . Price::format($order->getOrderFinalSumm()) . '</nobr>';
    }

    /**
     * @param CustomerOrderEntityInterface $order
     * @return string
     */
    public function formatSummOrder(CustomerOrderEntityInterface $order): string
    {
        return '<nobr>' . Price::format($order->getSumm()) . '</nobr>';
    }

    /**
     * @param CustomerOrderEntityInterface $order
     * @return string
     */
    public function formatDiscount(CustomerOrderEntityInterface $order): string
    {
        return sprintf(
            '%s (%s)',
            Price::format($order->getDiscountSumm()),
            $order->getDiscountPercent() . '%'
        );
    }



    /**
     * @param \Shop\Infrastructure\Models\OrderItem\OrderItem $item
     * @return string
     */
    public function formatItemSumm(\Shop\Infrastructure\Models\OrderItem\OrderItem $item)
    {
        return '<nobr>' . Price::format($item->getSumm()) . '</nobr>';
    }

    /**
     * @param CustomerOrderEntityInterface $order
     * @return string
     */
    public function formatActions(CustomerOrderEntityInterface $order): string
    {
        $popup = sprintf(
            "window.open('/admin/shop/customers/order_print?id=%s&type=customer_order', 'test','right=100,width=600,height=400,left=100,menubar=no,location=no,status=no')",
            $order->getId()
        );

        return $this->controlBuilder->buildActionMenuAdmin([
            anchor(
                '/admin/shop/customers/order_items?filter_by_orderCode=' . $order->getId(),
                Form::buildSpriteIcon('fa fa-list', ' Содержимое')
            ),
            '<a onclick="' . $popup . '" href="javascript:void(0)">' . Form::buildSpriteIcon('fa fa-group', ' Печать документа') . '</a>',


            anchor('javascript:void(0);', Form::buildSpriteIcon('fa fa-envelope', ' Отправить клиенту'), [
                'onclick' => "action_row({$order->getId()},'send-orders-selected','Отправить письмо с заказом клиенту на email?')"
            ]),
            anchor('javascript:void(0);', Form::buildSpriteIcon('fa fa-envelope', ' Отправить менеджеру'), [
                'onclick' => "action_row({$order->getId()},'send-orders-managers-selected','Отправить письмо с заказом менеджеру на email?')"
            ])
        ], $order->getId())->render();

    }
}