<?php


namespace Shop\Infrastructure\Repositories\Currency;


use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;
use Shop\Domain\Currency\CurrencyCollection;
use Shop\Infrastructure\Models\Currency\Currency;
use Shop\Infrastructure\Models\Currency\CurrencyQuery;

class CurrencyRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    public static function createEntity(): EntityInterface
    {
        return new Currency();
    }

    protected function createQuery(): ModelCriteria
    {
        return CurrencyQuery::create();
    }

    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {
        // TODO: Implement modifyCriteria() method.
    }


    protected function createCollection(): CollectionInterface
    {
        return new CurrencyCollection();
    }
    
}