<?php

namespace Shop\Infrastructure\Models\Currency\Map;

use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;
use Shop\Infrastructure\Models\Currency\Currency;
use Shop\Infrastructure\Models\Currency\CurrencyQuery;


/**
 * This class defines the structure of the 'shop_currencies' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class CurrencyTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    public const CLASS_NAME = 'Shop.Infrastructure.Models.Currency.Map.CurrencyTableMap';

    /**
     * The default database name for this class
     */
    public const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    public const TABLE_NAME = 'shop_currencies';

    /**
     * The related Propel class for this table
     */
    public const OM_CLASS = '\\Shop\\Infrastructure\\Models\\Currency\\Currency';

    /**
     * A class that can be returned by this tableMap
     */
    public const CLASS_DEFAULT = 'Shop.Infrastructure.Models.Currency.Currency';

    /**
     * The total number of columns
     */
    public const NUM_COLUMNS = 10;

    /**
     * The number of lazy-loaded columns
     */
    public const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    public const NUM_HYDRATE_COLUMNS = 10;

    /**
     * the column name for the id field
     */
    public const COL_ID = 'shop_currencies.id';

    /**
     * the column name for the name field
     */
    public const COL_NAME = 'shop_currencies.name';

    /**
     * the column name for the native field
     */
    public const COL_NATIVE = 'shop_currencies.native';

    /**
     * the column name for the position field
     */
    public const COL_POSITION = 'shop_currencies.position';

    /**
     * the column name for the html_sign field
     */
    public const COL_HTML_SIGN = 'shop_currencies.html_sign';

    /**
     * the column name for the round_price field
     */
    public const COL_ROUND_PRICE = 'shop_currencies.round_price';

    /**
     * the column name for the displayed field
     */
    public const COL_DISPLAYED = 'shop_currencies.displayed';

    /**
     * the column name for the iso field
     */
    public const COL_ISO = 'shop_currencies.iso';

    /**
     * the column name for the rbk_sync field
     */
    public const COL_RBK_SYNC = 'shop_currencies.rbk_sync';

    /**
     * the column name for the round_mode field
     */
    public const COL_ROUND_MODE = 'shop_currencies.round_mode';

    /**
     * The default string format for model objects of the related table
     */
    public const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     *
     * @var array<string, mixed>
     */
    protected static $fieldNames = [
        self::TYPE_PHPNAME       => ['Id', 'Name', 'Native', 'Position', 'HtmlSign', 'RoundPrice', 'Displayed', 'Iso', 'RbkSync', 'RoundMode', ],
        self::TYPE_CAMELNAME     => ['id', 'name', 'native', 'position', 'htmlSign', 'roundPrice', 'displayed', 'iso', 'rbkSync', 'roundMode', ],
        self::TYPE_COLNAME       => [CurrencyTableMap::COL_ID, CurrencyTableMap::COL_NAME, CurrencyTableMap::COL_NATIVE, CurrencyTableMap::COL_POSITION, CurrencyTableMap::COL_HTML_SIGN, CurrencyTableMap::COL_ROUND_PRICE, CurrencyTableMap::COL_DISPLAYED, CurrencyTableMap::COL_ISO, CurrencyTableMap::COL_RBK_SYNC, CurrencyTableMap::COL_ROUND_MODE, ],
        self::TYPE_FIELDNAME     => ['id', 'name', 'native', 'position', 'html_sign', 'round_price', 'displayed', 'iso', 'rbk_sync', 'round_mode', ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, ]
    ];

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     *
     * @var array<string, mixed>
     */
    protected static $fieldKeys = [
        self::TYPE_PHPNAME       => ['Id' => 0, 'Name' => 1, 'Native' => 2, 'Position' => 3, 'HtmlSign' => 4, 'RoundPrice' => 5, 'Displayed' => 6, 'Iso' => 7, 'RbkSync' => 8, 'RoundMode' => 9, ],
        self::TYPE_CAMELNAME     => ['id' => 0, 'name' => 1, 'native' => 2, 'position' => 3, 'htmlSign' => 4, 'roundPrice' => 5, 'displayed' => 6, 'iso' => 7, 'rbkSync' => 8, 'roundMode' => 9, ],
        self::TYPE_COLNAME       => [CurrencyTableMap::COL_ID => 0, CurrencyTableMap::COL_NAME => 1, CurrencyTableMap::COL_NATIVE => 2, CurrencyTableMap::COL_POSITION => 3, CurrencyTableMap::COL_HTML_SIGN => 4, CurrencyTableMap::COL_ROUND_PRICE => 5, CurrencyTableMap::COL_DISPLAYED => 6, CurrencyTableMap::COL_ISO => 7, CurrencyTableMap::COL_RBK_SYNC => 8, CurrencyTableMap::COL_ROUND_MODE => 9, ],
        self::TYPE_FIELDNAME     => ['id' => 0, 'name' => 1, 'native' => 2, 'position' => 3, 'html_sign' => 4, 'round_price' => 5, 'displayed' => 6, 'iso' => 7, 'rbk_sync' => 8, 'round_mode' => 9, ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, ]
    ];

    /**
     * Holds a list of column names and their normalized version.
     *
     * @var array<string>
     */
    protected $normalizedColumnNameMap = [
        'Id' => 'ID',
        'Currency.Id' => 'ID',
        'id' => 'ID',
        'currency.id' => 'ID',
        'CurrencyTableMap::COL_ID' => 'ID',
        'COL_ID' => 'ID',
        'shop_currencies.id' => 'ID',
        'Name' => 'NAME',
        'Currency.Name' => 'NAME',
        'name' => 'NAME',
        'currency.name' => 'NAME',
        'CurrencyTableMap::COL_NAME' => 'NAME',
        'COL_NAME' => 'NAME',
        'shop_currencies.name' => 'NAME',
        'Native' => 'NATIVE',
        'Currency.Native' => 'NATIVE',
        'native' => 'NATIVE',
        'currency.native' => 'NATIVE',
        'CurrencyTableMap::COL_NATIVE' => 'NATIVE',
        'COL_NATIVE' => 'NATIVE',
        'shop_currencies.native' => 'NATIVE',
        'Position' => 'POSITION',
        'Currency.Position' => 'POSITION',
        'position' => 'POSITION',
        'currency.position' => 'POSITION',
        'CurrencyTableMap::COL_POSITION' => 'POSITION',
        'COL_POSITION' => 'POSITION',
        'shop_currencies.position' => 'POSITION',
        'HtmlSign' => 'HTML_SIGN',
        'Currency.HtmlSign' => 'HTML_SIGN',
        'htmlSign' => 'HTML_SIGN',
        'currency.htmlSign' => 'HTML_SIGN',
        'CurrencyTableMap::COL_HTML_SIGN' => 'HTML_SIGN',
        'COL_HTML_SIGN' => 'HTML_SIGN',
        'html_sign' => 'HTML_SIGN',
        'shop_currencies.html_sign' => 'HTML_SIGN',
        'RoundPrice' => 'ROUND_PRICE',
        'Currency.RoundPrice' => 'ROUND_PRICE',
        'roundPrice' => 'ROUND_PRICE',
        'currency.roundPrice' => 'ROUND_PRICE',
        'CurrencyTableMap::COL_ROUND_PRICE' => 'ROUND_PRICE',
        'COL_ROUND_PRICE' => 'ROUND_PRICE',
        'round_price' => 'ROUND_PRICE',
        'shop_currencies.round_price' => 'ROUND_PRICE',
        'Displayed' => 'DISPLAYED',
        'Currency.Displayed' => 'DISPLAYED',
        'displayed' => 'DISPLAYED',
        'currency.displayed' => 'DISPLAYED',
        'CurrencyTableMap::COL_DISPLAYED' => 'DISPLAYED',
        'COL_DISPLAYED' => 'DISPLAYED',
        'shop_currencies.displayed' => 'DISPLAYED',
        'Iso' => 'ISO',
        'Currency.Iso' => 'ISO',
        'iso' => 'ISO',
        'currency.iso' => 'ISO',
        'CurrencyTableMap::COL_ISO' => 'ISO',
        'COL_ISO' => 'ISO',
        'shop_currencies.iso' => 'ISO',
        'RbkSync' => 'RBK_SYNC',
        'Currency.RbkSync' => 'RBK_SYNC',
        'rbkSync' => 'RBK_SYNC',
        'currency.rbkSync' => 'RBK_SYNC',
        'CurrencyTableMap::COL_RBK_SYNC' => 'RBK_SYNC',
        'COL_RBK_SYNC' => 'RBK_SYNC',
        'rbk_sync' => 'RBK_SYNC',
        'shop_currencies.rbk_sync' => 'RBK_SYNC',
        'RoundMode' => 'ROUND_MODE',
        'Currency.RoundMode' => 'ROUND_MODE',
        'roundMode' => 'ROUND_MODE',
        'currency.roundMode' => 'ROUND_MODE',
        'CurrencyTableMap::COL_ROUND_MODE' => 'ROUND_MODE',
        'COL_ROUND_MODE' => 'ROUND_MODE',
        'round_mode' => 'ROUND_MODE',
        'shop_currencies.round_mode' => 'ROUND_MODE',
    ];

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function initialize(): void
    {
        // attributes
        $this->setName('shop_currencies');
        $this->setPhpName('Currency');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Shop\\Infrastructure\\Models\\Currency\\Currency');
        $this->setPackage('Shop.Infrastructure.Models.Currency');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('name', 'Name', 'VARCHAR', false, 255, null);
        $this->addColumn('native', 'Native', 'CHAR', false, null, 'Y');
        $this->addColumn('position', 'Position', 'TINYINT', true, null, 0);
        $this->addColumn('html_sign', 'HtmlSign', 'CHAR', false, 10, null);
        $this->addColumn('round_price', 'RoundPrice', 'TINYINT', true, null, 0);
        $this->addColumn('displayed', 'Displayed', 'CHAR', false, null, 'Y');
        $this->addColumn('iso', 'Iso', 'CHAR', false, 10, null);
        $this->addColumn('rbk_sync', 'RbkSync', 'CHAR', false, null, 'N');
        $this->addColumn('round_mode', 'RoundMode', 'CHAR', false, null, 'ceil');
    }

    /**
     * Build the RelationMap objects for this table relationships
     *
     * @return void
     */
    public function buildRelations(): void
    {
        $this->addRelation('OrderItem', '\\Shop\\Infrastructure\\Models\\OrderItem\\OrderItem', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':crrency_id',
    1 => ':id',
  ),
), null, null, 'OrderItems', false);
        $this->addRelation('PricelistSheet', '\\Shop\\Infrastructure\\Models\\PricelistSheet\\PricelistSheet', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':crrency_id',
    1 => ':id',
  ),
), null, null, 'PricelistSheets', false);
        $this->addRelation('Provider', '\\Shop\\Infrastructure\\Models\\Provider\\Provider', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':crrency_id',
    1 => ':id',
  ),
), null, null, 'Providers', false);
    }

    /**
     *
     * Gets the list of behaviors registered for this table
     *
     * @return array<string, array> Associative array (name => parameters) of behaviors
     */
    public function getBehaviors(): array
    {
        return [
            'archivable' => ['archive_table' => '', 'archive_phpname' => NULL, 'archive_class' => '', 'log_archived_at' => 'true', 'archived_at_column' => 'archived_at', 'archive_on_insert' => 'false', 'archive_on_update' => 'false', 'archive_on_delete' => 'true'],
        ];
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string|null The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): ?string
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param bool $withPrefix Whether to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass(bool $withPrefix = true): string
    {
        return $withPrefix ? CurrencyTableMap::CLASS_DEFAULT : CurrencyTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array $row Row returned by DataFetcher->fetch().
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array (Currency object, last column rank)
     */
    public static function populateObject(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): array
    {
        $key = CurrencyTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = CurrencyTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + CurrencyTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = CurrencyTableMap::OM_CLASS;
            /** @var Currency $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            CurrencyTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array<object>
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher): array
    {
        $results = [];

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = CurrencyTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = CurrencyTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var Currency $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                CurrencyTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria Object containing the columns to add.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function addSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->addSelectColumn(CurrencyTableMap::COL_ID);
            $criteria->addSelectColumn(CurrencyTableMap::COL_NAME);
            $criteria->addSelectColumn(CurrencyTableMap::COL_NATIVE);
            $criteria->addSelectColumn(CurrencyTableMap::COL_POSITION);
            $criteria->addSelectColumn(CurrencyTableMap::COL_HTML_SIGN);
            $criteria->addSelectColumn(CurrencyTableMap::COL_ROUND_PRICE);
            $criteria->addSelectColumn(CurrencyTableMap::COL_DISPLAYED);
            $criteria->addSelectColumn(CurrencyTableMap::COL_ISO);
            $criteria->addSelectColumn(CurrencyTableMap::COL_RBK_SYNC);
            $criteria->addSelectColumn(CurrencyTableMap::COL_ROUND_MODE);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.name');
            $criteria->addSelectColumn($alias . '.native');
            $criteria->addSelectColumn($alias . '.position');
            $criteria->addSelectColumn($alias . '.html_sign');
            $criteria->addSelectColumn($alias . '.round_price');
            $criteria->addSelectColumn($alias . '.displayed');
            $criteria->addSelectColumn($alias . '.iso');
            $criteria->addSelectColumn($alias . '.rbk_sync');
            $criteria->addSelectColumn($alias . '.round_mode');
        }
    }

    /**
     * Remove all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be removed as they are only loaded on demand.
     *
     * @param Criteria $criteria Object containing the columns to remove.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function removeSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->removeSelectColumn(CurrencyTableMap::COL_ID);
            $criteria->removeSelectColumn(CurrencyTableMap::COL_NAME);
            $criteria->removeSelectColumn(CurrencyTableMap::COL_NATIVE);
            $criteria->removeSelectColumn(CurrencyTableMap::COL_POSITION);
            $criteria->removeSelectColumn(CurrencyTableMap::COL_HTML_SIGN);
            $criteria->removeSelectColumn(CurrencyTableMap::COL_ROUND_PRICE);
            $criteria->removeSelectColumn(CurrencyTableMap::COL_DISPLAYED);
            $criteria->removeSelectColumn(CurrencyTableMap::COL_ISO);
            $criteria->removeSelectColumn(CurrencyTableMap::COL_RBK_SYNC);
            $criteria->removeSelectColumn(CurrencyTableMap::COL_ROUND_MODE);
        } else {
            $criteria->removeSelectColumn($alias . '.id');
            $criteria->removeSelectColumn($alias . '.name');
            $criteria->removeSelectColumn($alias . '.native');
            $criteria->removeSelectColumn($alias . '.position');
            $criteria->removeSelectColumn($alias . '.html_sign');
            $criteria->removeSelectColumn($alias . '.round_price');
            $criteria->removeSelectColumn($alias . '.displayed');
            $criteria->removeSelectColumn($alias . '.iso');
            $criteria->removeSelectColumn($alias . '.rbk_sync');
            $criteria->removeSelectColumn($alias . '.round_mode');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap(): TableMap
    {
        return Propel::getServiceContainer()->getDatabaseMap(CurrencyTableMap::DATABASE_NAME)->getTable(CurrencyTableMap::TABLE_NAME);
    }

    /**
     * Performs a DELETE on the database, given a Currency or Criteria object OR a primary key value.
     *
     * @param mixed $values Criteria or Currency object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ?ConnectionInterface $con = null): int
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(CurrencyTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Shop\Infrastructure\Models\Currency\Currency) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(CurrencyTableMap::DATABASE_NAME);
            $criteria->add(CurrencyTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = CurrencyQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            CurrencyTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                CurrencyTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the shop_currencies table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(?ConnectionInterface $con = null): int
    {
        return CurrencyQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a Currency or Criteria object.
     *
     * @param mixed $criteria Criteria or Currency object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed The new primary key.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(CurrencyTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from Currency object
        }

        if ($criteria->containsKey(CurrencyTableMap::COL_ID) && $criteria->keyContainsValue(CurrencyTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.CurrencyTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = CurrencyQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

}
