<?php


namespace Shop\Application\Office\AuthCustomer;


class AuthCustomerCommand
{

    /**
     * @var string
     */
    protected $login;

    /**
     * @var string|null
     */
    protected $password;

    /**
     * @var string|null
     */
    protected $hashPassword;

    /**
     * @var Конкретная группа клиента
     */
    protected $customerGroupId;

    /**
     * AuthCustomerCommand constructor.
     * @param string $login
     * @param string|null $password
     * @param string|null $hashPassword
     * @param int|null $customerGroupId
     */
    public function __construct(string $login, ?string $password, ?string $hashPassword = null, int $customerGroupId = null)
    {
        $this->login = $login;
        $this->password = $password;
        $this->hashPassword = $hashPassword;
        $this->customerGroupId = $customerGroupId;
    }

    /**
     * @return Конкретная
     */
    public function getCustomerGroupId()
    {
        return $this->customerGroupId;
    }


    /**
     * @return string
     */
    public function getLogin(): string
    {
        return $this->login;
    }

    /**
     * @return string
     */
    public function getPassword(): ?string
    {
        return $this->password;
    }

    /**
     * @return string|null
     */
    public function getHashPassword(): ?string
    {
        return $this->hashPassword;
    }


}