<?php

namespace Shop\Infrastructure\Repositories\CustomerCart;

use Diamond\Infrastructure\Models\Session\Session;
use Diamond\Infrastructure\Models\Session\SessionQuery;
use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;
use Shop\Domain\CustomerCart\CustomerCartCollection;
use Shop\Infrastructure\Models\CustomerCart\CustomerCart;

class CustomerCartRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    public static function createEntity(): EntityInterface
    {
        return new Session();
    }

    protected function createQuery(): ModelCriteria
    {
        return SessionQuery::create();
    }

    protected function createCollection(): CollectionInterface
    {
        return new CustomerCartCollection();
    }

    /**
     * @param PaginationInterface|CustomerCartCriteria $criteria
     * @param ModelCriteria|SessionQuery $dbCriteria
     * @return void
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {
        $dbCriteria
            ->_if($criteria->getSortByTime() !== null)
            ->orderByTime($criteria->getSortByTime() )
            ->_endif();
    }

}