<?php

namespace Shop\Domain\PriceList;

use Core\Repository\DropDownInterface;
use Repo\Concrete\AbstractCollection;
use Shop\Domain\PriceList\Contracts\PriceListEntityInterface;
use Shop\Infrastructure\Models\PricelistFile\PricelistFile;
use Shop\Infrastructure\Models\PricelistSheet\PricelistSheet;

/**
 * Description of PriceList
 *
 * @author Diamond Code Generator
 */
class PriceListCollection extends AbstractCollection implements DropDownInterface
{

    /**
     * @return string
     */
    protected function getEntityClass(): string
    {
        return PriceListEntityInterface::class;
    }

    /**
     * @return array
     */
    public function getDropdownList(): array
    {
        $ar = [];
        foreach ($this->_entities as $entity) {
            $ar[$entity->getId()] = $entity->getTitle();
        }

        return $ar;
    }

    /**
     * @return array
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getDropdownListWithFileName(): array
    {
        $ar = [];
        /**
         * @var PricelistSheet $entity
         */
        foreach ($this->_entities as $entity) {
            $ar[$entity->getId()] = $entity->getTitle() . ' (' . $entity->getPricelistFile()->getName() . ')';
        }

        return $ar;
    }
}               