<?php declare(strict_types=1);

namespace Shop\Presentation\Validators;

use Fi1a\Validation\AbstractRuleSet;
class ProductStockValidator extends AbstractRuleSet
{
    protected $titles = [
        '*:id' => 'Ид товара',
        '*:positions' => 'Размерные позиции',
        '*:positions:*:remain' => 'Остаток позиции',
        '*:positions:*:price' => 'Цена позиции',
        '*:positions:*:id' => 'Ид позиции'
    ];

    public function init(): bool
    {
        $this->fields('*:id')->allOf()->required();
        $this->fields('*:positions')->allOf()->array();
        $this->fields('*:positions:*:price')->allOf()->required()->numeric();
        $this->fields('*:positions:*:amount')->allOf()->required()->numeric();
        $this->fields('*:positions:*:description')->allOf()->required()->string();
        $this->fields('*:positions:*:sizes')->allOf()->array();
        return true;
    }


    public function getTitles(): array
    {
        return $this->titles;
    }

}