<?

namespace Shop\Presentation\Modules\AdminSettingsSms;

use Core\Form\ControlBuilder;
use Core\Form\FormBuilder;
use Shop\Presentation\Config\Sms;

/**
 * Description of AdminSettingsSms
 *
 * @author Diamond Code Generator
 */
class AdminSettingsSms extends \Core\ModuleController
{

    protected $formBuilder;
    protected $controlBuilder;
    protected $conf;
    protected $confMain;

    function __construct(FormBuilder $form, ControlBuilder $controlBuilder, Sms $conf, \Shop\Presentation\Config\Main $confMain
    )
    {
        $this->formBuilder = $form;
        $this->controlBuilder = $controlBuilder;
        $this->conf = $conf;
        $this->confMain = $confMain;
    }

    public function process():string
    {
        $form = $this->formBuilder->buildSettingsForm($this->conf, "sms");
        $form->setClass('panel-body form-horizontal form-padding');
        $builder = $this->controlBuilder;
        $options = array(
            'DISSABLED'     => 'Не использовать',
            'DEBUG_OFF'     => 'Рабочий режим',
            'DEBUG_DISPLAY' => 'Вывод на экран',
            'DEBUG_PHONE'   => 'Отправка на тестовый телефон'
        );

        $form
                ->addField(
                        $builder->buildDropdownUniform("debug", $options), "Режим работы смс уведомлений", "required"
                )
                ->addField(
                        $builder->buildInputSmall("login"), "Логин"
                )
                ->addField(
                        $builder->buildInputPassword("password"), "Пароль"
                )
                ->addField(
                        $builder->buildInputSmall("from"), "Email адрес отправителя", "required|valid_email"
                )
                ->addField(
                        $builder->buildInputSmall("debugPhone")->setId("debugPhone"), "Телефон для тестового режима", null,
                                                  "Смс отправляются на указанный телефон"
                )

        ;

        $builder->buildJmask("debugPhone", $this->confMain->getMobileMask())->Render();

        return $form->render();
    }

}