<?php

namespace Shop\Infrastructure\Repositories\CustomerCart;

use Repo\Concrete\AbstractCriteria;
use Shop\Domain\CustomerCart\Contracts\CustomerCartCriteriaInterface;

class CustomerCartCriteria extends AbstractCriteria implements CustomerCartCriteriaInterface
{
    private string|null $sortByTime = null;
    
    public static function create()
    {
        return new self;
    }

    /**
     * @return string|null
     */
    public function getSortByTime(): ?string
    {
        return $this->sortByTime;
    }

    /**
     * @param string|null $sortByTime
     * @return CustomerCartCriteria
     */
    public function setSortByTime(?string $sortByTime): CustomerCartCriteria
    {
        $this->sortByTime = $sortByTime;
        return $this;
    }
    
}