<?php


namespace Shop\Application\Shopping\SendNotifyAboutState;


use Core\Helpers\Date;
use Diamond\Application\Notification\NotificationService;
use Shop\Application\Shopping\ShoppingService;

class SendNotifyAboutStateHandler
{
    protected $main;
    protected $notificationService;
    protected $shoppingService;

    /**
     * SendNotifyAboutStateHandler constructor.
     * @param NotificationService $notificationService
     */
    public function __construct(NotificationService $notificationService,
                                ShoppingService $shoppingService)
    {
        $this->notificationService = $notificationService;
        $this->shoppingService = $shoppingService;
    }

    /**
     * @param SendNotifyAboutStateCommand $command
     * @throws \Propel\Runtime\Exception\PropelException
     * @throws \Repo\Concrete\Exceptions\Collection
     * @throws \Twig\Error\LoaderError
     * @throws \Twig\Error\RuntimeError
     * @throws \Twig\Error\SyntaxError
     */
    public function handle(SendNotifyAboutStateCommand $command): void
    {
        $order = $command->getOrder();
        $customer = $order->getCustomer();

        if ($customer->getNotifyOrder() === 'N') {
            return;
        }

        $data = $this->shoppingService->prepareCustomerOrderDataForReport($order);

        //на email
        //отправляем уведомление
        if ($customer->isNotifyEmail() === true && $customer->getEmail()) {
            $this->notificationService->sendToEmailByReport('change_state_order_email', $customer->getEmail(), $data);
        }
        //на cmc
        if ($customer->isNotifySms() === true && $customer->getPhone()) {

            $this->notificationService->sendToPhoneByReport('change_state_order_sms', $customer->getPhone(), $data);
        }
    }
}