<?php

namespace Shop\Domain\CustomerOrder\Contracts;

use Repo\PaginationInterface;
use Repo\RepositoryCriteriaInterface;
use Shop\Infrastructure\Repositories\CustomerOrder\CustomerOrderCriteria;

/**
 * Description of CustomerOrder
 *
 * @author Diamond Code Generator
 */
interface CustomerOrderCriteriaInterface extends RepositoryCriteriaInterface, PaginationInterface
{
    /**
     * @return string|null
     */
    public function getSortById(): ?string;

    /**
     * @return int|null
     */
    public function getFilterByStateId(): ?int;

    /**
     * @return string|null
     */
    public function getFilterByOrderCode():?string;

    /**
     * @return int|null
     */
    public function getFilterByStockId():?int;

    /**
     * @return array|null
     */
    public function getFilterByStockIds():?array;

    /**
     * @return int|null
     */
    public function getFilterByCustomerId():?int;

    public function setFilterByCreateMonthDate(?string $filterByCreateMonthDate): CustomerOrderCriteriaInterface;

    public function getFilterByCreateMonthDate(): ?string;
}           