<?php declare(strict_types=1);

namespace Shop\Presentation\Validators;

use Fi1a\Validation\AbstractRuleSet;
class ProductValidator extends AbstractRuleSet
{


    protected $titles = [
        'name' => 'Наименование',
        'article' => 'Артикул',
        'brand' => 'Производитель',
        'price' => 'Цена',
        'groups' => 'Группа товара',
        'positions' => 'Размерные позиции',
        'positions:*:amount' => 'Остаток позиции',
        'positions:*:price' => 'Цена позиции',
        'positions:*:description' => 'Описание позиции',
        'positions:*:sizes' => 'Размеры позиции',
    ];

    public function init(): bool
    {
        $this->fields('name')->allOf()->required();
        $this->fields('article')->allOf()->required();
        $this->fields('brand')->allOf()->required();
        $this->fields('price')->allOf()->numeric();
        $this->fields('groups')->allOf()->array();
        $this->fields('positions')->allOf()->array();
        $this->fields('positions:*:price')->allOf()->required()->numeric();
        $this->fields('positions:*:amount')->allOf()->required()->numeric();
        $this->fields('positions:*:description')->allOf()->required()->string();
        $this->fields('positions:*:sizes')->allOf()->array();
        return true;
    }


    public function getTitles(): array
    {
        return $this->titles;
    }

}