<?php

namespace Shop\Presentation\Modules\AdminDiscountRules;

use ActiveTable\ColumnTable;
use Core\Form\ControlBuilder;
use Core\ModuleController;
use Core\Registry\Column;
use Core\Registry\Field;
use DiamondTable\TableFactory;
use Shop\Domain\DiscountRule\Contracts\DiscountRuleEntityInterface;
use Shop\Infrastructure\Repositories\Brand\BrandCriteria;
use Shop\Infrastructure\Repositories\Brand\BrandRepository;
use Shop\Infrastructure\Repositories\DiscountRule\DiscountRuleCriteria;
use Shop\Infrastructure\Repositories\DiscountRule\DiscountRuleRepository;
use Shop\Infrastructure\Repositories\ProductCategory\ProductCategoryCriteria;
use Shop\Infrastructure\Repositories\ProductCategory\ProductCategoryRepository;

/**
 * Description of AdminDiscountRules
 *
 * @author Diamond Code Generator
 */
class AdminDiscountRules extends ModuleController
{

    protected $repo;
    protected $tableFactory;
    protected $cBuilder;
    protected $brandRepo;
    protected $categoryRepo;

    /**
     * AdminDiscountRules constructor.
     * @param TableFactory $tableFactory
     * @param ControlBuilder $cBuilder
     * @param DiscountRuleRepository $repo
     * @param BrandRepository $brandRepo
     * @param ProductCategoryRepository $categoryRepo
     */
    public function __construct(TableFactory $tableFactory,
                                ControlBuilder $cBuilder,
                                DiscountRuleRepository $repo,
                                BrandRepository $brandRepo,
                                ProductCategoryRepository $categoryRepo
    )
    {
        $this->tableFactory = $tableFactory;
        $this->repo = $repo;
        $this->cBuilder = $cBuilder;
        $this->brandRepo = $brandRepo;
        $this->categoryRepo = $categoryRepo;
    }

    public function process(): string
    {

        $table = $this->tableFactory->buildAdminTable($this->repo, DiscountRuleCriteria::create());

        $table
            ->addColumn(new ColumnTable("id", "№"))
            ->addColumn((new ColumnTable("brandId", "Производитель"))->setFormat($this, "formatBrand"))
            ->addColumn((new ColumnTable("categoryId", "Раздел каталога"))->setFormat($this, "formatCategory"))
            ->addColumn(new ColumnTable("rate", "Максимальная скидка,%"))
            ->addColumn(new ColumnTable("priority", "Приоритет"))
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setFormat($this->tableFactory, 'formatActions')
                    ->setWidth(120)
            );

        $brandsCollection = $this->brandRepo->findByCriteria(
            BrandCriteria::create()
        );

        $categoryCollection = $this->categoryRepo->findByCriteria(
            ProductCategoryCriteria::create()
        );

        $brands = \Shop\Presentation\Helpers\Form::prepareDropdownWithDef($brandsCollection, "%");
        $categories = \Shop\Presentation\Helpers\Form::prepareDropdown($categoryCollection, "раздел", "getDropdownListWithParent");

        $pri = [];
        for ($pr = 0; $pr <= 100; $pr++) {
            $pri [] = $pr;
        }

        $table
            ->addField(
                $this
                    ->cBuilder
                    ->buildInputLittle("rate"), true, null, "0 - отключает все скидки"
            )
            ->addField(
                $this
                    ->cBuilder
                    ->buildDropdownUniform("brandId", $brands)
            )
            ->addField(
                $this
                    ->cBuilder
                    ->buildDropdownUniform("categoryId", $categories), false,"Раздел каталога")
            ->addField(
                $this
                    ->cBuilder
                    ->buildDropdownUniform("priority", $pri)
            );

        return $table->render();
    }

    /**
     * @param DiscountRuleEntityInterface $rule
     * @return string
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function formatBrand(DiscountRuleEntityInterface $rule): string
    {
        return $rule->getBrand() ? $rule->getBrand()->getName() : "";
    }

    /**
     * @param DiscountRuleEntityInterface $rule
     * @return string
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function formatCategory(DiscountRuleEntityInterface $rule): string
    {
        return $rule->getCategory() ? $rule->getCategory()->getNameWithParent() : "";
    }

}