<?php

namespace Shop\Infrastructure\Repositories\DraftProduct;

use Diamond\Repositories\PropelAbstractRepository;
use Shop\Domain\DraftProduct\DraftProductCollection;
use Shop\Infrastructure\Models\DraftProduct\DraftProduct;
use Shop\Infrastructure\Models\DraftProduct\DraftProductQuery;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;

class DraftProductRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    public static function createEntity(): EntityInterface
    {
        return new DraftProduct();
    }

    protected function createQuery(): ModelCriteria
    {
        return DraftProductQuery::create();
    }

    /**
     * @param PaginationInterface|DraftProductCriteria $criteria
     * @param ModelCriteria|DraftProductQuery $dbCriteria
     * @return void
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {
        $dbCriteria
            ->_if($criteria->getFilterByCustomerId() !== null)
            ->filterByCustomerId($criteria->getFilterByCustomerId())
            ->_endif()
            ;
    }


    protected function createCollection(): CollectionInterface
    {
        return new DraftProductCollection();
    }
}