<?php

namespace Shop\Domain\Manager;

use Core\Repository\DropDownInterface;
use Repo\Concrete\AbstractCollection;
use Shop\Domain\Manager\Contracts\ManagerEntityInterface;
use Shop\Infrastructure\Models\Manager\Manager;

/**
 * Description of Manager
 *
 * @author Diamond Code Generator
 */
class ManagerCollection extends AbstractCollection implements DropDownInterface
{

    /**
     * @return string
     */
    protected function getEntityClass(): string
    {
        return ManagerEntityInterface::class;
    }

    public function getDropdownList(): array
    {
        $ar = [];
        foreach ($this->_entities as $entity) {
            $ar[$entity->getId()] = $entity->getName();
        }

        return $ar;
    }

    public function getDropdownListWithShop(): array
    {
        $ar = [];
        /**
         * @var Manager $entity
         */
        foreach ($this->_entities as $entity) {
            $ar[$entity->getId()] = sprintf('%s (%s)', $entity->getName(), $entity->getShop()->getTitle());
        }

        return $ar;
    }

}               