<?php declare(strict_types=1);

namespace Shop\Application\Client\ClientUpdate;

use Shop\Domain\Customer\Contracts\CustomerEntityInterface;

class ClientUpdateCommand
{

    protected CustomerEntityInterface|null $customer = null;

    public function __construct(protected string $fullName,
                                protected string $email,
                                protected string $phone,
                                protected string $cityName)
    {
    }

    public function getFullName(): string
    {
        return $this->fullName;
    }

    public function getEmail(): string
    {
        return $this->email;
    }

    public function getPhone(): string
    {
        return $this->phone;
    }

    public function getCustomer(): ?CustomerEntityInterface
    {
        return $this->customer;
    }

    public function getCityName(): string
    {
        return $this->cityName;
    }


    public function setCustomer(?CustomerEntityInterface $customer): ClientUpdateCommand
    {
        $this->customer = $customer;
        return $this;
    }

}